/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.protocol;

import eu.europa.ec.jrc.qcs.dao.ProtocolToRuleDAO;
import eu.europa.ec.jrc.qcs.dao.RuleToFieldDAO;
import eu.europa.ec.jrc.qcs.dao.ValidationMessageDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.SerializableModel;
import eu.europa.ec.jrc.qcs.dao.model.protocol.CaseSensitivity;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolToRule;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleToField;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ValidationMessage;
import eu.europa.ec.jrc.qcs.engine.ValidationCycle;
import eu.europa.ec.jrc.qcs.engine.ValidationLevel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleDefinition
extends SerializableModel {
    protected boolean positive;
    protected CaseSensitivity caseSensitivity;
    protected String location;
    protected String implementation;
    protected ValidationMessage validationMessage;
    protected RuleType ruleType;
    protected List<ProtocolToRule> protocolToRules;
    protected List<RuleToField> ruleToFields;
    public static final String FK_VALIDATION_MESSAGE_ID = "validationMessageId";
    public static final String FK_ALTERNATE_MESSAGE_ID = "alternateMessageId";
    public static final RuleDefinition UNDEF = new RuleDefinition();
    public static final List<RuleDefinition> EMPTY_LIST = new ArrayList<RuleDefinition>();
    protected static ValidationMessageDAO validationMessageDAO;
    protected static ProtocolToRuleDAO protocolToRuleDAO;
    protected static RuleToFieldDAO ruleToFieldDAO;
    protected static Logger logger;

    public RuleDefinition() {
        this.setValid(false);
        this.setName("undefined_rule");
        this.setDescription("Empty reference for a \"null\" RuleDefinition instance");
    }

    public RuleDefinition(int id, String name, String description, boolean positive, CaseSensitivity caseSensitivity, String location, String implementation, String ruleTypeID, String messageID) {
        super(id, name, description);
        this.positive = positive;
        this.setCaseSensitivity(caseSensitivity);
        this.location = location;
        this.implementation = implementation;
        this.setRuleTypeID(ruleTypeID);
        this.setValidationMessageID(messageID);
    }

    public RuleDefinition(String id, String name, String description, String positive, String caseSensitivity, String location, String implementation, String messageID, String ruleTypeID) {
        this();
        this.setName(name);
        this.setId(id);
        this.setDescription(description);
        this.setPositive(positive);
        this.setCaseSensitivity(caseSensitivity);
        this.setLocation(location);
        this.setImplementation(implementation);
        this.setRuleTypeID(ruleTypeID);
        this.setValidationMessageID(messageID);
    }

    public RuleDefinition(String[] array) {
        this(array[0], array[1], array[2], array[3], array[4], array[5], array[6], array[7], array[8]);
    }

    public RuleDefinition(eu.europa.ec.jrc.qcs.dao.dto.RuleDefinition dto) {
        this();
        if (dto == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Costructor(dto) - Null argument");
            }
            this.valid = false;
            return;
        }
        this.valid = true;
        this.setId(dto.getId());
        this.setRuleTypeID(dto.getRuleType().getId());
        this.setPositive(dto.getPositive());
        this.setValidationMessageID(dto.getValidationMessage().getId());
        this.setCaseSensitivity(dto.getCaseSensitivity());
        this.setDescription(dto.getDescription());
        this.setImplementation(dto.getImplementation());
        this.setLocation(dto.getLocation());
        this.setName(dto.getName());
        if (logger.isTraceEnabled()) {
            logger.trace("RuleDefinition(dto) - Created new instance: " + String.valueOf(this));
        }
    }

    public RuleType getRuleType() {
        if (this.ruleType != null) {
            return this.ruleType;
        }
        int ruleTypeID = this.getForeignId();
        if (logger.isTraceEnabled()) {
            logger.trace("getRuleType() - Getting RuleType from foreign ID: " + ruleTypeID);
        }
        if (this.isWrongID(ruleTypeID)) {
            return RuleType.UNDEF;
        }
        this.ruleType = RuleType.getByID(ruleTypeID);
        return this.ruleType;
    }

    public ValidationMessage getValidationMessage() {
        if (this.validationMessage != null) {
            return this.validationMessage;
        }
        int validationMessageID = this.getValidationMessageID();
        this.validationMessage = (ValidationMessage)validationMessageDAO.getByID(validationMessageID);
        if (this.validationMessage == null) {
            this.validationMessage = ValidationMessage.UNDEF;
        }
        return this.validationMessage;
    }

    public List<ProtocolToRule> getAllProtocolToRule() {
        if (this.protocolToRules == null) {
            int ruleID = this.getId();
            this.protocolToRules = protocolToRuleDAO.getByRuleID(ruleID);
        }
        return this.protocolToRules;
    }

    public List<RuleToField> getAllRuleToField() {
        if (this.ruleToFields == null) {
            int ruleID = this.getId();
            this.ruleToFields = ruleToFieldDAO.getByRuleID(ruleID);
        }
        return this.ruleToFields;
    }

    public ProtocolToRule getProtocolToRule(int protocolID) {
        List<ProtocolToRule> list = this.getAllProtocolToRule();
        for (ProtocolToRule protocolTorule : list) {
            if (protocolTorule.getProtocolID() != protocolID) continue;
            return protocolTorule;
        }
        return ProtocolToRule.UNDEF;
    }

    public List<RuleToField> getRuleToField(int protocolID) {
        List<RuleToField> list = this.getAllRuleToField();
        if (list == null || list.size() == 0) {
            return RuleToField.EMPTY_LIST;
        }
        ArrayList<RuleToField> result = new ArrayList<RuleToField>();
        for (RuleToField ruleToField : list) {
            if (ruleToField.getProtocolID() != protocolID) continue;
            result.add(ruleToField);
        }
        return result;
    }

    public ValidationCycle getValidationCycle() {
        RuleType ruleType = this.getRuleType();
        ValidationLevel validationLevel = ruleType.validationLevel;
        ValidationCycle cycle = validationLevel.cycle;
        return cycle;
    }

    public void setPositive(String positive) {
        this.positive = this.parseBoolean("positive", positive, true);
    }

    public void setCaseSensitivity(String caseSensitivity) {
        CaseSensitivity sensitivity = CaseSensitivity.parseCaseSensitivityValue(caseSensitivity);
        this.setCaseSensitivity(sensitivity);
    }

    public void setCaseSensitivity(CaseSensitivity caseSensitivity) {
        if (caseSensitivity != CaseSensitivity.UNDEF) {
            if (caseSensitivity != null) {
                this.caseSensitivity = caseSensitivity;
            } else {
                this.caseSensitivity = CaseSensitivity.INSENSITIVE;
                logger.error("setCaseSensitivity() - Null sensitity value -> forced to INSENSITIVE");
            }
        } else {
            this.caseSensitivity = CaseSensitivity.INSENSITIVE;
            if (logger.isWarnEnabled()) {
                logger.warn("setCaseSensitivity() - Unknown sensitity value (" + String.valueOf((Object)caseSensitivity) + ") -> forced to INSENSITIVE");
            }
        }
    }

    public void setRuleTypeID(int ruleTypeID) {
        this.setRuleTypeID(Integer.toString(ruleTypeID));
    }

    public void setRuleTypeID(String ruleTypeID) {
        this.setForeignId(ruleTypeID);
        if (logger.isTraceEnabled()) {
            logger.trace("setRuleTypeID() - ruleTypeID: " + ruleTypeID);
        }
        RuleType type = RuleType.parseRuleTypeID(ruleTypeID);
        this.setRuleType(type);
    }

    public void setRuleType(RuleType ruleType) {
        this.ruleType = ruleType;
    }

    public void setValidationMessageID(int messageID) {
        this.setValidationMessageID(Integer.toString(messageID));
    }

    public void setValidationMessageID(String messageID) {
        this.setForeignId(FK_VALIDATION_MESSAGE_ID, messageID);
    }

    public int getRuleTypeID() {
        return this.getForeignId();
    }

    public int getValidationMessageID() {
        int messageID = this.getForeignId(FK_VALIDATION_MESSAGE_ID);
        if (logger.isTraceEnabled()) {
            logger.trace("getValidationMessageID() - Fetched first messageID: " + messageID);
        }
        return messageID;
    }

    public int getAlternateMessageID() {
        int messageID = this.getForeignId(FK_ALTERNATE_MESSAGE_ID);
        if (logger.isTraceEnabled()) {
            logger.trace("getAlternateMessageID() - Fetched second messageID: " + messageID);
        }
        return messageID;
    }

    public boolean hasAlternateMessageID() {
        return this.getAlternateMessageID() > 0;
    }

    public boolean isPositive() {
        return this.positive;
    }

    public void setPositive(boolean positive) {
        this.positive = positive;
    }

    public CaseSensitivity getCaseSensitivity() {
        return this.caseSensitivity;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public void setValidationMessage(ValidationMessage validationMessage) {
        this.validationMessage = validationMessage;
    }

    @Override
    public String[] serialize() {
        String ruleDefinitionID = this.getIdAsString();
        String description = this.description != null ? this.description : this.name;
        String positive = this.valueOf(this.isPositive());
        String caseSensitivity = this.caseSensitivity != null ? this.caseSensitivity.symbol : "N/A";
        String messageID = String.valueOf(this.getValidationMessageID());
        String ruleTypeID = String.valueOf(this.getRuleTypeID());
        if (logger.isTraceEnabled()) {
            logger.trace("serialize() - serialising record having ID: " + ruleDefinitionID);
        }
        String[] values = new String[]{ruleDefinitionID, this.name, description, positive, caseSensitivity, this.location, this.implementation, messageID, ruleTypeID};
        return values;
    }

    @Override
    protected String[] getHeader() {
        String[] values = new String[]{"ID", "RULE_NAME", "DESCRIPTION", "POSITIVE", "CASE_SENSITIVITY", "LOCATION", "IMPLEMENTATION", "MESSAGE_ID", "RULE_TYPE_ID"};
        return values;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleDefinition other = (RuleDefinition)obj;
        if (this.caseSensitivity != other.caseSensitivity) {
            return false;
        }
        if (this.implementation == null ? other.implementation != null : !this.implementation.equals(other.implementation)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.positive != other.positive) {
            return false;
        }
        if (this.protocolToRules == null ? other.protocolToRules != null : !this.protocolToRules.equals(other.protocolToRules)) {
            return false;
        }
        if (this.ruleToFields == null ? other.ruleToFields != null : !this.ruleToFields.equals(other.ruleToFields)) {
            return false;
        }
        if (this.ruleType == null ? other.ruleType != null : !this.ruleType.equals((Object)other.ruleType)) {
            return false;
        }
        return !(this.validationMessage == null ? other.validationMessage != null : !this.validationMessage.equals(other.validationMessage));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("id=");
        builder.append(this.getIdAsString());
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", class=");
        if (this.implementation != null) {
            builder.append(this.implementation);
        } else {
            builder.append("default");
        }
        builder.append(", type=");
        builder.append((Object)this.ruleType);
        builder.append("]");
        return builder.toString();
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[Name: ");
        builder.append(this.name);
        builder.append(" , Description: ");
        builder.append(this.description);
        builder.append(", RuleId: ");
        builder.append(this.getIdAsString());
        builder.append("]");
        return builder.toString();
    }

    static {
        logger = LoggerFactory.getLogger(RuleDefinition.class);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        ruleToFieldDAO = (RuleToFieldDAO)((Object)daoFactory.getDAO(DAO.RULE_TO_FIELD));
        protocolToRuleDAO = (ProtocolToRuleDAO)((Object)daoFactory.getDAO(DAO.PROTOCOL_TO_RULE));
        validationMessageDAO = (ValidationMessageDAO)((Object)daoFactory.getDAO(DAO.VALIDATION_MESSAGE));
    }
}

