/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.protocol;

import eu.europa.ec.jrc.qcs.dao.CachedMap;
import eu.europa.ec.jrc.qcs.dao.SchemaViewDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolToRule;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.schema.Schema;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemasGroup;
import eu.europa.ec.jrc.qcs.engine.ValidationLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolView
extends ProtocolToRule
implements CachedMap {
    protected SchemaView schemaView;
    protected List<ProtocolToRule> protocolToRules;
    protected List<RuleDefinition> ruleDefinitions;
    protected Set<Integer> levels;
    protected Set<Integer> priorities;
    protected Map<Integer, RuleDefinition> rulesByRuleID;
    protected Map<Integer, List<RuleDefinition>> rulesByPriority;
    protected Map<ValidationLevel, List<RuleDefinition>> rulesByLevel;
    protected Map<Integer, ProtocolToRule> protocolToRulesByRuleID;
    protected Map<Integer, List<ProtocolToRule>> protocolToRulesByLevel;
    protected Map<Integer, List<ProtocolToRule>> protocolToRulesByPriority;
    protected int maxLevel;
    public static final String FK_SCHEMA_ID = "schemaId";
    public static final ProtocolView UNDEF = new ProtocolView();
    protected static SchemaViewDAO schemaViewDAO = null;
    protected static Logger logger = LoggerFactory.getLogger(ProtocolView.class);

    public ProtocolView() {
        this.setValid(false);
        this.setId(0);
        this.setName("undefined_protocol_view");
        this.setDescription("Empty reference for a \"null\" ProtocolView instance");
    }

    public ProtocolView(Protocol protocol, List<ProtocolToRule> protocolToRules) {
        this();
        this.protocol = protocol;
        this.protocolToRules = protocolToRules;
        this.setId(protocol.getId());
        this.setProtocolID(Integer.toString(protocol.getId()));
        this.setRuleID(0);
        this.setName(protocol.getName());
        this.setDescription(protocol.getDescription());
        this.loadData();
    }

    @Override
    public void initCache() {
        this.ruleDefinitions = new ArrayList<RuleDefinition>();
        this.levels = new TreeSet<Integer>();
        this.priorities = new TreeSet<Integer>();
        this.rulesByRuleID = new HashMap<Integer, RuleDefinition>();
        this.rulesByPriority = new HashMap<Integer, List<RuleDefinition>>();
        this.protocolToRulesByRuleID = new HashMap<Integer, ProtocolToRule>();
        this.protocolToRulesByLevel = new HashMap<Integer, List<ProtocolToRule>>();
        this.protocolToRulesByPriority = new HashMap<Integer, List<ProtocolToRule>>();
        this.rulesByLevel = new HashMap<ValidationLevel, List<RuleDefinition>>();
    }

    protected void loadData() {
        this.initCache();
        for (ProtocolToRule protocolToRule : this.protocolToRules) {
            List<RuleDefinition> rulesAtLevel;
            RuleDefinition rule = protocolToRule.getRule();
            if (logger.isDebugEnabled()) {
                logger.debug("loadData() - Loading rule: " + String.valueOf(protocolToRule));
            }
            int ruleID = rule.getId();
            int priority = protocolToRule.getPriority();
            this.ruleDefinitions.add(rule);
            this.priorities.add(priority);
            this.rulesByRuleID.put(ruleID, rule);
            this.protocolToRulesByRuleID.put(ruleID, protocolToRule);
            List<RuleDefinition> rulesAtPriority = this.rulesByPriority.get(priority);
            if (rulesAtPriority == null) {
                rulesAtPriority = new ArrayList<RuleDefinition>();
                this.rulesByPriority.put(priority, rulesAtPriority);
            }
            rulesAtPriority.add(rule);
            List<ProtocolToRule> protocolToRulesAtPriority = this.protocolToRulesByPriority.get(priority);
            if (protocolToRulesAtPriority == null) {
                protocolToRulesAtPriority = new ArrayList<ProtocolToRule>();
                this.protocolToRulesByPriority.put(priority, protocolToRulesAtPriority);
            }
            protocolToRulesAtPriority.add(protocolToRule);
            RuleType ruleType = rule.getRuleType();
            ValidationLevel validationLevel = ruleType.validationLevel;
            this.levels.add(validationLevel.level);
            if (validationLevel.level > this.maxLevel) {
                this.maxLevel = validationLevel.level;
            }
            if ((rulesAtLevel = this.rulesByLevel.get((Object)validationLevel)) == null) {
                rulesAtLevel = new ArrayList<RuleDefinition>();
                this.rulesByLevel.put(validationLevel, rulesAtLevel);
            }
            rulesAtLevel.add(rule);
            List<ProtocolToRule> protocolToRulesAtLevel = this.protocolToRulesByLevel.get(validationLevel.level);
            if (protocolToRulesAtLevel == null) {
                protocolToRulesAtLevel = new ArrayList<ProtocolToRule>();
                this.protocolToRulesByLevel.put(validationLevel.level, protocolToRulesAtLevel);
            }
            protocolToRulesAtLevel.add(protocolToRule);
        }
    }

    public int getNumberOfRules() {
        if (this.protocolToRules == null) {
            return 0;
        }
        return this.protocolToRules.size();
    }

    public List<RuleDefinition> getRuleDefinitions() {
        return this.ruleDefinitions;
    }

    public Set<Integer> getLevels() {
        return this.levels;
    }

    public Set<Integer> getPriorities() {
        return this.priorities;
    }

    public RuleDefinition getRuleDefinitionByRuleID(int ruleID) {
        RuleDefinition rule = this.rulesByRuleID.get(ruleID);
        if (rule != null) {
            return rule;
        }
        return RuleDefinition.UNDEF;
    }

    public List<RuleDefinition> getRulesByLevel(int level) {
        List<RuleDefinition> rules = this.rulesByLevel.get(level);
        if (rules != null) {
            return rules;
        }
        return RuleDefinition.EMPTY_LIST;
    }

    public List<RuleDefinition> getRulesByPriority(int priority) {
        List<RuleDefinition> rules = this.rulesByPriority.get(priority);
        if (rules != null) {
            return rules;
        }
        return RuleDefinition.EMPTY_LIST;
    }

    public int getRulePriorityByRuleID(int ruleID) {
        ProtocolToRule protocolToRule = this.getProtocolToRuleByRuleID(ruleID);
        if (protocolToRule == ProtocolToRule.UNDEF) {
            return -1;
        }
        return protocolToRule.getPriority();
    }

    public ProtocolToRule getProtocolToRuleByRuleID(int ruleID) {
        ProtocolToRule protocolToRule = this.protocolToRulesByRuleID.get(ruleID);
        if (protocolToRule != null) {
            return protocolToRule;
        }
        return ProtocolToRule.UNDEF;
    }

    public List<ProtocolToRule> getProtocolToRuleByLevel(int level) {
        List<ProtocolToRule> protocolTorules = this.protocolToRulesByLevel.get(level);
        if (protocolTorules != null) {
            return protocolTorules;
        }
        return ProtocolToRule.EMPTY_LIST;
    }

    public List<ProtocolToRule> getProtocolToRuleByPrioriry(int priority) {
        List<ProtocolToRule> protocolTorules = this.protocolToRulesByPriority.get(priority);
        if (protocolTorules != null) {
            return protocolTorules;
        }
        return ProtocolToRule.EMPTY_LIST;
    }

    public SchemaView getFullSchemaView() {
        if (this.schemaView == null) {
            int schemaID = this.getSchemaID();
            this.schemaView = schemaViewDAO.getFullSchemaViewByID(schemaID);
        }
        return this.schemaView;
    }

    public SchemaView getSchemaView() {
        int schemaID = this.getSchemaID();
        SchemaView schemaView = (SchemaView)schemaViewDAO.getByID(schemaID);
        return schemaView;
    }

    public int getSchemaID() {
        return this.getSchema().getId();
    }

    public Schema getSchema() {
        return this.getProtocol().getSchema();
    }

    public int getSchemaGroupID() {
        SchemasGroup schemasGroup = this.getSchemaGroup();
        return schemasGroup.getId();
    }

    public SchemasGroup getSchemaGroup() {
        SchemaView schemaView = this.getSchemaView();
        Schema schema = schemaView.getSchema();
        SchemasGroup schemasGroup = schema.getSchemaGroup();
        return schemasGroup;
    }

    public List<ProtocolToRule> getProtocolToRules() {
        return this.protocolToRules;
    }

    public void setProtocolToRules(List<ProtocolToRule> protocolToRules) {
        this.protocolToRules = protocolToRules;
    }

    public Map<Integer, RuleDefinition> getRulesByRuleID() {
        return this.rulesByRuleID;
    }

    public void setRulesByRuleID(Map<Integer, RuleDefinition> rulesByID) {
        this.rulesByRuleID = rulesByID;
    }

    public Map<Integer, List<RuleDefinition>> getRulesByPriority() {
        return this.rulesByPriority;
    }

    public void setRulesByPriority(Map<Integer, List<RuleDefinition>> rulesByPriority) {
        this.rulesByPriority = rulesByPriority;
    }

    public Map<Integer, ProtocolToRule> getProtocolToRulesByRuleID() {
        return this.protocolToRulesByRuleID;
    }

    public void setProtocolToRulesByRuleID(Map<Integer, ProtocolToRule> protocolToRulesByID) {
        this.protocolToRulesByRuleID = protocolToRulesByID;
    }

    public Map<Integer, List<ProtocolToRule>> getProtocolToRulesByLevel() {
        return this.protocolToRulesByLevel;
    }

    public void setProtocolToRulesByLevel(Map<Integer, List<ProtocolToRule>> protocolToRulesByLevel) {
        this.protocolToRulesByLevel = protocolToRulesByLevel;
    }

    public Map<Integer, List<ProtocolToRule>> getProtocolToRulesByPriority() {
        return this.protocolToRulesByPriority;
    }

    public void setProtocolToRulesByPriority(Map<Integer, List<ProtocolToRule>> protocolToRulesByPriority) {
        this.protocolToRulesByPriority = protocolToRulesByPriority;
    }

    public void setRuleDefinitions(List<RuleDefinition> ruleDefinitions) {
        this.ruleDefinitions = ruleDefinitions;
    }

    public void setLevels(Set<Integer> levels) {
        this.levels = levels;
    }

    public void setPriorities(Set<Integer> priorities) {
        this.priorities = priorities;
    }

    public Map<ValidationLevel, List<RuleDefinition>> getRulesByLevel() {
        return this.rulesByLevel;
    }

    public void setRulesByLevel(Map<ValidationLevel, List<RuleDefinition>> rulesByLevel) {
        this.rulesByLevel = rulesByLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("id=");
        builder.append(this.getId());
        builder.append(", name=");
        builder.append(this.getName());
        builder.append(", =");
        if (this.protocol != null) {
            builder.append(this.protocol.getSchema().getName());
        } else {
            builder.append(Schema.UNDEF.getName());
        }
        builder.append(" [ID=");
        builder.append(this.getSchemaID());
        builder.append("]");
        builder.append(", rules=");
        builder.append(this.getNumberOfRules());
        builder.append("]");
        return builder.toString();
    }

    static {
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        schemaViewDAO = (SchemaViewDAO)((Object)daoFactory.getDAO(DAO.SCHEMA_VIEW));
    }
}

