/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.protocol;

import eu.europa.ec.jrc.qcs.dao.ProtocolDAO;
import eu.europa.ec.jrc.qcs.dao.RuleDefinitionDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.SerializableModel;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolToRule
extends SerializableModel {
    protected Protocol protocol;
    protected RuleDefinition rule;
    protected int priority;
    protected boolean blocking;
    public static int globalCounter = 1;
    public static final String FK_PROTOCOL_ID = "protocolId";
    public static final ProtocolToRule UNDEF = new ProtocolToRule();
    public static final List<ProtocolToRule> EMPTY_LIST = new ArrayList<ProtocolToRule>();
    protected static ProtocolDAO protocolDAO;
    protected static RuleDefinitionDAO ruleDefinitionDAO;
    protected static Logger logger;

    public ProtocolToRule() {
        this.setValid(false);
        this.setId(0);
        this.setName("undefined_protocol_to_rule");
        this.setDescription("Empty reference for a \"null\" protocolToRule instance");
    }

    public ProtocolToRule(int id, String protocolID, String priority, String blocking, String ruleID) {
        this.setId(id);
        this.setProtocolID(protocolID);
        this.setPriority(priority);
        this.setBlocking(blocking);
        this.setRuleID(ruleID);
    }

    public ProtocolToRule(String id, String protocolID, String priority, String blocking, String ruleID) {
        this();
        this.setName(this.name);
        this.setId(id);
        this.setDescription(this.description);
        this.setPriority(priority);
        this.setBlocking(blocking);
        this.setRuleID(ruleID);
        this.setProtocolID(protocolID);
    }

    public ProtocolToRule(int id, int protocolID, int priority, boolean blocking, int ruleID) {
        String protocolIDAsString = String.valueOf(protocolID);
        this.setId(id);
        this.setProtocolID(protocolIDAsString);
        this.setPriority(priority);
        this.setBlocking(blocking);
        this.setRuleID(ruleID);
    }

    public ProtocolToRule(RuleConfiguration cfg) {
        this(0, cfg.getProtocolID(), cfg.getPriority(), cfg.isBlocking(), 0);
    }

    public ProtocolToRule(String[] array) {
        this(array[0], array[1], array[2], array[3], array[4]);
    }

    public ProtocolToRule(eu.europa.ec.jrc.qcs.dao.dto.ProtocolToRule dto) {
        this();
        if (dto == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Costructor(dto) - Null argument");
            }
            this.valid = false;
            return;
        }
        this.valid = true;
        this.setId(dto.getId());
        this.setProtocolID(Integer.toString(dto.getProtocol().getId()));
        this.setPriority(dto.getPriority());
        this.setBlocking(dto.getBlock());
        this.setRuleID(dto.getRuleDefinition().getId());
        if (logger.isTraceEnabled()) {
            logger.trace("RuleDefinition(dto) - Created new instance: " + String.valueOf(this));
        }
    }

    public RuleDefinition getRule() {
        int ruleID = this.getRuleID();
        if (this.isWrongID(ruleID)) {
            return RuleDefinition.UNDEF;
        }
        if (this.rule == null) {
            this.rule = (RuleDefinition)ruleDefinitionDAO.getByID(ruleID);
        }
        return this.rule;
    }

    public Protocol getProtocol() {
        int protocolID = this.getProtocolID();
        if (this.isWrongID(protocolID)) {
            return Protocol.UNDEF;
        }
        if (this.protocol == null) {
            this.protocol = (Protocol)protocolDAO.getByID(protocolID);
        }
        return this.protocol;
    }

    public void setProtocolID(String value) {
        this.setForeignId(FK_PROTOCOL_ID, value);
    }

    public int getProtocolID() {
        return this.getForeignId(FK_PROTOCOL_ID);
    }

    public void setRuleID(String value) {
        if (GenericModel.isNullInteger(value) && this.isNillableForeignKey()) {
            this.setNullForeignId();
        } else {
            this.setForeignId(value);
        }
    }

    public void setRuleID(int ruleID) {
        this.setForeignId(ruleID);
    }

    public int getRuleID() {
        return this.getForeignId();
    }

    public void setPriority(String priority) {
        this.priority = this.parseInteger("priority", priority);
    }

    public void setPriority(int priority) {
        this.priority = this.parseInteger("priority", priority);
    }

    public void setBlocking(String blocking) {
        this.blocking = this.parseBoolean("blocking", blocking, true);
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public void setRule(RuleDefinition rule) {
        this.rule = rule;
    }

    public boolean isCriticallyInvalid(int protocolID) {
        if (this.getPriority() < 0) {
            return true;
        }
        return this.getProtocolID() != protocolID;
    }

    @Override
    public String[] serialize() {
        String protocolToRuleID = this.getIdAsString();
        String priority = String.valueOf(this.getPriority());
        String blocking = String.valueOf(this.isBlocking());
        String ruleID = String.valueOf(this.getRuleID());
        if (logger.isTraceEnabled()) {
            logger.trace("serialize() - serialising record having ID: " + protocolToRuleID);
        }
        String[] values = new String[]{protocolToRuleID, priority, blocking, ruleID};
        return values;
    }

    @Override
    protected String[] getHeader() {
        String[] values = new String[]{"PROTOCOL_ID", "PRIORITY", "BLOCKING", "RULE_ID"};
        return values;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("id=");
        builder.append(this.getId());
        builder.append(", protocolID=");
        builder.append(this.getIntegerLabel(this.getProtocolID()));
        builder.append(", priority=");
        builder.append(this.getIntegerLabel(this.priority));
        builder.append(", block=");
        builder.append(this.isBlocking());
        builder.append(", ruleID=");
        builder.append(this.getForeignIdAsString());
        builder.append("]");
        return builder.toString();
    }

    static {
        logger = LoggerFactory.getLogger(ProtocolToRule.class);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        ruleDefinitionDAO = (RuleDefinitionDAO)((Object)daoFactory.getDAO(DAO.RULE_DEFINITION));
        protocolDAO = (ProtocolDAO)((Object)daoFactory.getDAO(DAO.PROTOCOL));
    }
}

