/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.protocol;

import eu.europa.ec.jrc.qcs.dao.ProtocolDAO;
import eu.europa.ec.jrc.qcs.dao.ProtocolToRuleDAO;
import eu.europa.ec.jrc.qcs.dao.RuleToFieldDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaDAO;
import eu.europa.ec.jrc.qcs.dao.ValidationRunDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.SerializableModel;
import eu.europa.ec.jrc.qcs.dao.model.output.ValidationRun;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolToRule;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleToField;
import eu.europa.ec.jrc.qcs.dao.model.schema.Schema;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Protocol
extends SerializableModel {
    protected int order;
    protected Schema schema;
    protected Protocol parent;
    protected List<ProtocolToRule> protocolToRules;
    protected List<RuleToField> ruleToFields;
    protected List<ValidationRun> validationRuns;
    public static final String FK_PARENT_ID = "parentId";
    public static final Protocol UNDEF = new Protocol();
    public static final List<Protocol> EMPTY_LIST = new ArrayList<Protocol>();
    protected static SchemaDAO schemaDAO = null;
    protected static ProtocolDAO protocolDAO = null;
    protected static ProtocolToRuleDAO protocolToRuleDAO = null;
    protected static RuleToFieldDAO ruleToFieldDAO = null;
    protected static ValidationRunDAO validationRunDAO = null;
    protected static Logger logger = LoggerFactory.getLogger(Protocol.class);

    public Protocol() {
        this.setValid(false);
        this.setName("undefined_protocol");
        this.setDescription("Empty reference for a \"null\" protocol instance");
    }

    public Protocol(String id, String name, String description, String order, String parentID, String schemaID) {
        this();
        this.setName(name.trim());
        this.setId(id);
        this.setDescription(description);
        this.setOrder(order);
        this.setSchemaID(schemaID);
        this.setParentID(parentID);
    }

    public Protocol(String[] array) {
        this(array[0], array[1], array[2], array[3], array[4], array[5]);
    }

    public Protocol(eu.europa.ec.jrc.qcs.dao.dto.Protocol dto) {
        this();
        if (dto == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Costructor(dto) - Null argument");
            }
            this.valid = false;
            return;
        }
        this.valid = true;
        this.setId(dto.getId());
        this.setName(dto.getName());
        this.setDescription(dto.getDescription());
        this.setOrder(dto.getOrderNumber());
        if (dto.getParent() != null) {
            this.setParentID(dto.getParent().getId());
        } else {
            this.setParentID("0");
        }
        if (dto.getSchema() != null) {
            this.setSchemaID(dto.getSchema().getId());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Schema(dto) - Created new instance: " + String.valueOf(this));
        }
    }

    public Schema getSchema() {
        int schemaID = this.getForeignId();
        if (this.isWrongID(schemaID)) {
            return Schema.UNDEF;
        }
        if (this.schema == null) {
            this.schema = (Schema)schemaDAO.getByID(schemaID);
        }
        return this.schema;
    }

    public Protocol getParent() {
        if (this.parent == null) {
            int parentID = this.getParentID();
            this.parent = (Protocol)protocolDAO.getByID(parentID);
        }
        return this.parent;
    }

    public List<ProtocolToRule> getAllProtocolToRule() {
        if (this.protocolToRules == null) {
            int protocolID = this.getId();
            this.protocolToRules = protocolToRuleDAO.getByProtocolID(protocolID);
        }
        return this.protocolToRules;
    }

    public List<RuleToField> getAllRuleToField() {
        if (this.ruleToFields == null) {
            int protocolID = this.getId();
            this.ruleToFields = ruleToFieldDAO.getByProtocolID(protocolID);
        }
        return this.ruleToFields;
    }

    public List<ValidationRun> getAllValidationRun() {
        if (this.validationRuns == null) {
            int protocolID = this.getId();
            this.validationRuns = validationRunDAO.getByProtocolID(protocolID);
        }
        return this.validationRuns;
    }

    public ProtocolToRule getProtocolToRule(int ruleID) {
        List<ProtocolToRule> list = this.getAllProtocolToRule();
        for (ProtocolToRule protocolTorule : list) {
            if (protocolTorule.getRuleID() != ruleID) continue;
            return protocolTorule;
        }
        return ProtocolToRule.UNDEF;
    }

    public List<RuleToField> getRuleToField(int ruleID) {
        List<RuleToField> list = this.getAllRuleToField();
        if (list == null) {
            return RuleToField.EMPTY_LIST;
        }
        ArrayList<RuleToField> result = new ArrayList<RuleToField>();
        for (RuleToField ruleToField : list) {
            if (ruleToField.getRuleID() != ruleID) continue;
            result.add(ruleToField);
        }
        return result;
    }

    public void setOrder(String order) {
        this.order = this.parseInteger("order", order);
    }

    public void setOrder(int order) {
        this.order = this.parseInteger("order", order);
    }

    public void setSchemaID(String schemaID) {
        this.setForeignId(schemaID);
    }

    public void setSchemaID(int schemaID) {
        this.setForeignId(schemaID);
    }

    public int getSchemaID() {
        return this.getForeignId();
    }

    public void setParentID(int value) {
        String parentID = Integer.toString(value);
        this.setParentID(parentID);
    }

    public void setParentID(String value) {
        if (GenericModel.isNullInteger(value) && this.isNillableForeignKey()) {
            this.setNullForeignId(FK_PARENT_ID);
        } else {
            this.setForeignId(FK_PARENT_ID, value);
        }
    }

    public int getParentID() {
        return this.getForeignId(FK_PARENT_ID);
    }

    public int getOrder() {
        return this.order;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setRuleSetConfigurations(List<ProtocolToRule> ruleSetConfigurations) {
        this.protocolToRules = ruleSetConfigurations;
    }

    @Override
    public String[] serialize() {
        String protocolID = this.getIdAsString();
        String description = this.description != null ? this.description : this.name;
        String order = String.valueOf(this.getOrder());
        String parentID = String.valueOf(this.getParentID());
        String schemaID = String.valueOf(this.getSchemaID());
        if (logger.isTraceEnabled()) {
            logger.trace("serialize() - serialising record having ID: " + protocolID);
        }
        String[] values = new String[]{protocolID, this.name, description, order, parentID, schemaID};
        return values;
    }

    @Override
    protected String[] getHeader() {
        String[] values = new String[]{"ID", "PROTOCOL_NAME", "DESCRIPTION", "ORDER", "PARENT_ID", "SCHEMA_ID"};
        return values;
    }

    public boolean equals(Object object) {
        if (object instanceof Protocol) {
            Protocol anotherProtocol = (Protocol)object;
            return this.getId() == anotherProtocol.getId();
        }
        return false;
    }

    public boolean perfectEquals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Protocol other = (Protocol)object;
        if (this.protocolToRules == null ? other.protocolToRules != null : !this.protocolToRules.equals(other.protocolToRules)) {
            return false;
        }
        return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
    }

    public String toString() {
        return this.name;
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("name=");
        builder.append(this.name);
        builder.append(", id=");
        builder.append(this.getIdAsString());
        builder.append(", order=");
        builder.append(this.getIntegerLabel(this.order));
        builder.append(", schemaID=");
        builder.append(this.getIntegerLabel(this.getSchemaID()));
        builder.append(", parentID=");
        builder.append(this.getIntegerLabel(this.getParentID()));
        builder.append("]");
        return builder.toString();
    }

    static {
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        schemaDAO = (SchemaDAO)((Object)daoFactory.getDAO(DAO.SCHEMA));
        protocolDAO = (ProtocolDAO)((Object)daoFactory.getDAO(DAO.PROTOCOL));
        ruleToFieldDAO = (RuleToFieldDAO)((Object)daoFactory.getDAO(DAO.RULE_TO_FIELD));
        validationRunDAO = (ValidationRunDAO)((Object)daoFactory.getDAO(DAO.VALIDATION_RUN));
        protocolToRuleDAO = (ProtocolToRuleDAO)((Object)daoFactory.getDAO(DAO.PROTOCOL_TO_RULE));
    }
}

