/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.output;

import eu.europa.ec.jrc.qcs.dao.ProtocolDAO;
import eu.europa.ec.jrc.qcs.dao.RuleOutputDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.SerializableModel;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.engine.rule.AbstractRule;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationRun
extends SerializableModel {
    protected Date processStart;
    protected Date processEnd;
    protected int recordsIn;
    protected int recordsOut;
    protected int recordsKO;
    protected int errorsNumber;
    protected int warningsNumber;
    protected String userName;
    protected Protocol protocol;
    protected List<Integer> failedPreliminaryRuleIds;
    protected List<RuleOutput> ruleOutputs;
    protected static SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    public static final ValidationRun UNDEF = new ValidationRun();
    public static final List<ValidationRun> EMPTY_LIST = new ArrayList<ValidationRun>();
    public static final String RULE_ID_SEPARATOR = "-";
    protected static ProtocolDAO protocolDAO = null;
    protected static RuleOutputDAO ruleOutputDAO = null;
    protected static Logger logger = LoggerFactory.getLogger(ValidationRun.class);

    public ValidationRun() {
        this.setValid(false);
        this.setName("undefined_validationRun");
        this.setDescription("Empty reference for a \"null\" ValidationRun instance");
    }

    public ValidationRun(String id, String dataSetName, String processStart, String processEnd, String recordsIn, String recordsOut, String recordsKO, String ruleIDs, String errorsNumber, String warningsNumber, String userName, String protocolID) {
        this();
        this.valid = true;
        this.setName(dataSetName.trim());
        this.setId(id);
        this.setDescription(this.description);
        this.setProcessStart(processStart);
        this.setProcessEnd(processEnd);
        this.setRecordsIn(recordsIn);
        this.setRecordsOut(recordsOut);
        this.setRecordsKO(recordsKO);
        this.setFailedPreliminaryRuleIds(ruleIDs);
        this.setErrorsNumber(errorsNumber);
        this.setWarningsNumber(warningsNumber);
        this.setUserName(userName);
        this.setProtocolID(protocolID);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        protocolDAO = (ProtocolDAO)((Object)daoFactory.getDAO(DAO.PROTOCOL));
        ruleOutputDAO = (RuleOutputDAO)((Object)daoFactory.getDAO(DAO.RULE_OUTPUT));
    }

    public ValidationRun(String dataSetName, String processStart, String processEnd, String recordsIn, String recordsOut, String recordsKO, String ruleIDs, String errorsNumber, String warningsNumber, String userName, String protocolID) {
        this("0", dataSetName, processStart, processEnd, recordsIn, recordsOut, recordsKO, ruleIDs, errorsNumber, warningsNumber, userName, protocolID);
    }

    public ValidationRun(String dataSetName, Date processStart, Date processEnd, String recordsIn, String recordsOut, String recordsKO, String ruleIDs, String errorsNumber, String warningsNumber, String userName, String protocolID) {
        this("0", dataSetName, formatter.format(processStart), formatter.format(processEnd), recordsIn, recordsOut, recordsKO, ruleIDs, errorsNumber, warningsNumber, userName, protocolID);
    }

    public ValidationRun(String[] array) {
        this(array[0], array[1], array[2], array[3], array[4], array[5], array[6], array[7], array[8], array[9], array[10], array[11]);
    }

    public Protocol getProtocol() {
        int protocolID = this.getProtocolID();
        if (this.isWrongID(protocolID)) {
            return Protocol.UNDEF;
        }
        if (this.protocol == null) {
            this.protocol = (Protocol)protocolDAO.getByID(protocolID);
        }
        return this.protocol;
    }

    public List<RuleOutput> getAllRuleOutput() {
        if (this.ruleOutputs == null) {
            int validationRunID = this.getId();
            this.ruleOutputs = ruleOutputDAO.getByValidationRunID(validationRunID);
        }
        return this.ruleOutputs;
    }

    public List<RuleOutput> getRuleOutput(int lineNumber) {
        List<RuleOutput> list = this.getAllRuleOutput();
        if (list == null) {
            return RuleOutput.EMPTY_LIST;
        }
        ArrayList<RuleOutput> result = new ArrayList<RuleOutput>();
        for (RuleOutput ruleOutput : list) {
            if (ruleOutput.getLineNumber() != lineNumber) continue;
            result.add(ruleOutput);
        }
        return result;
    }

    public void setProtocolID(String protocolID) {
        this.setForeignId(protocolID);
    }

    public void setProtocolID(int protocolID) {
        this.setForeignId(protocolID);
    }

    public int getProtocolID() {
        return this.getForeignId();
    }

    public void setDataSetName(String name) {
        this.setName(name);
    }

    public String getDataSetName() {
        return this.getName();
    }

    public void setProcessStart(Date processStart) {
        this.processStart = processStart;
    }

    public void setProcessStart(String processStart) {
        try {
            Date date = formatter.parse(processStart);
            this.setProcessStart(date);
        }
        catch (ParseException e) {
            logger.error("setProcessStart() - Wrong input value: " + processStart);
            e.printStackTrace();
        }
    }

    public void setProcessEnd(Date processEnd) {
        this.processEnd = processEnd;
    }

    public void setProcessEnd(String processEnd) {
        try {
            Date date = formatter.parse(processEnd);
            this.setProcessEnd(date);
        }
        catch (ParseException e) {
            logger.error("setProcessEnd() - Wrong input value: " + processEnd);
            e.printStackTrace();
        }
    }

    public String getFormattedProcessTime() {
        long ms = this.getProcessTime();
        long seconds = ms / 1000L;
        Object string = String.format("%d:%02d:%02d", seconds / 3600L, seconds % 3600L / 60L, seconds % 60L);
        string = (String)string + " (" + String.format("%,d", ms) + " ms)";
        return string;
    }

    public long getProcessTime() {
        Date start = this.getProcessStart();
        Date end = this.getProcessEnd();
        long difference = Math.abs(start.getTime() - end.getTime());
        return difference;
    }

    public void setRecordsIn(String recordsIn) {
        this.recordsIn = this.parseIntegerValue(recordsIn);
    }

    public void setRecordsOut(String recordsOut) {
        this.recordsOut = this.parseIntegerValue(recordsOut);
    }

    public void setRecordsKO(String recordsKO) {
        this.recordsKO = this.parseIntegerValue(recordsKO);
    }

    public void incrementRecordsKO(AbstractRule rule) {
        RuleType ruleType = rule.getRuleConfiguration().getRuleType();
        if (ruleType == RuleType.RECORD_FORMAT) {
            ++this.recordsKO;
        }
    }

    public void setErrorsNumber(String errorsNumber) {
        this.errorsNumber = this.parseIntegerValue(errorsNumber);
    }

    public void setWarningsNumber(String warningsNumber) {
        this.warningsNumber = this.parseIntegerValue(warningsNumber);
    }

    public void setFailedPreliminaryRuleIds(String ruleIds) {
        if (ruleIds == null || ruleIds.isEmpty() || ruleIds.trim().isEmpty()) {
            return;
        }
        Object[] tokens = ruleIds.split(RULE_ID_SEPARATOR);
        this.failedPreliminaryRuleIds = new ArrayList<Integer>();
        if (logger.isDebugEnabled()) {
            logger.debug("setFailedPreliminaryRuleIDs() - Rule ids: " + Arrays.toString(tokens));
        }
        for (Object ruleIdAsString : tokens) {
            int ruleId = 0;
            try {
                ruleId = Integer.parseInt((String)ruleIdAsString);
            }
            catch (NumberFormatException e) {
                ruleId = RuleDefinition.UNDEF.getId();
                logger.error("setFailedPreliminaryRuleIDs() - Wrong ruleId (not numeric): " + (String)ruleIdAsString);
            }
            this.failedPreliminaryRuleIds.add(ruleId);
        }
    }

    public void addFailedPreliminaryRuleIDs(AbstractRule rule) {
        if (this.failedPreliminaryRuleIds == null) {
            this.failedPreliminaryRuleIds = new ArrayList<Integer>();
        }
        this.failedPreliminaryRuleIds.add(rule.getId());
    }

    public String getFailedPreliminaryRuleIdsAsString() {
        if (this.failedPreliminaryRuleIds == null) {
            return "";
        }
        String sep = "";
        StringBuilder builder = new StringBuilder();
        for (int ruleID : this.failedPreliminaryRuleIds) {
            builder.append(sep);
            builder.append(ruleID);
            sep = RULE_ID_SEPARATOR;
        }
        return builder.toString();
    }

    public Date getProcessStart() {
        return this.processStart;
    }

    public Date getProcessEnd() {
        return this.processEnd;
    }

    public void setRecordsIn(int recordsIn) {
        this.recordsIn = recordsIn;
    }

    public int getRecordsIn() {
        return this.recordsIn;
    }

    public void setRecordsOut(int recordsOut) {
        this.recordsOut = recordsOut;
    }

    public int getRecordsOut() {
        return this.recordsOut;
    }

    public int getRecordsKO() {
        return this.recordsKO;
    }

    public void setRecordsKO(int recordsKO) {
        this.recordsKO = recordsKO;
    }

    public void setErrorsNumber(int errorsNumber) {
        this.errorsNumber = errorsNumber;
    }

    public int getErrorsNumber() {
        return this.errorsNumber;
    }

    public void setWarningsNumber(int warningsNumber) {
        this.warningsNumber = warningsNumber;
    }

    public int getWarningsNumber() {
        return this.warningsNumber;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public List<Integer> getFailedPreliminaryRuleIds() {
        return this.failedPreliminaryRuleIds;
    }

    public void setFailedPreliminaryRuleIds(List<Integer> failedPreliminaryRuleIds) {
        this.failedPreliminaryRuleIds = failedPreliminaryRuleIds;
    }

    @Override
    public String[] serialize() {
        String start = formatter.format(this.processStart);
        String end = formatter.format(this.processEnd);
        String recordsIn = String.valueOf(this.recordsIn);
        String recordsOut = String.valueOf(this.recordsOut);
        String recordsKO = String.valueOf(this.recordsKO);
        String ruleIDs = this.getFailedPreliminaryRuleIdsAsString();
        String errors = String.valueOf(this.errorsNumber);
        String warnings = String.valueOf(this.warningsNumber);
        String protocolId = String.valueOf(this.getProtocolID());
        String[] values = new String[]{this.getIdAsString(), this.name, start, end, recordsIn, recordsOut, recordsKO, ruleIDs, errors, warnings, this.userName, protocolId};
        return values;
    }

    @Override
    protected String[] getHeader() {
        String[] values = new String[]{"RUN_ID", "DATA_SET_NAME", "PROCESS_START", "PROCESS_END", "RECORDS_IN", "RECORDS_OUT", "RECORDS_KO", "RULES_IDS", "ERRORS", "WARNINGS", "USER_NAME", "PROTOCOL_ID"};
        return values;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationRun other = (ValidationRun)obj;
        if (this.errorsNumber != other.errorsNumber) {
            return false;
        }
        if (this.processEnd == null ? other.processEnd != null : !this.processEnd.equals(other.processEnd)) {
            return false;
        }
        if (this.processStart == null ? other.processStart != null : !this.processStart.equals(other.processStart)) {
            return false;
        }
        if (this.recordsIn != other.recordsIn) {
            return false;
        }
        if (this.recordsOut != other.recordsOut) {
            return false;
        }
        if (this.userName == null ? other.userName != null : !this.userName.equals(other.userName)) {
            return false;
        }
        return this.warningsNumber == other.warningsNumber;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("id=");
        builder.append(this.getIdAsString());
        builder.append(", dataset=");
        if (this.name != null) {
            int maxSize = 30;
            int length = this.name.length();
            if (length <= maxSize) {
                builder.append(this.name);
            } else {
                builder.append("...");
                builder.append(this.name.substring(length - maxSize, length));
            }
        }
        builder.append(", in=");
        builder.append(this.recordsIn);
        builder.append(", out=");
        builder.append(this.recordsOut);
        builder.append(", rules=");
        builder.append(this.failedPreliminaryRuleIds);
        builder.append(", errors=");
        builder.append(this.errorsNumber);
        builder.append(", warnings=");
        builder.append(this.warningsNumber);
        builder.append(", user=");
        builder.append(this.userName);
        builder.append(", protocolID=");
        builder.append(this.getProtocolID());
        builder.append("]");
        return builder.toString();
    }
}

