/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.output;

import eu.europa.ec.jrc.qcs.dao.RuleOutputDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.SerializableModel;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleOutputDetail
extends SerializableModel {
    protected int fieldID;
    protected String fieldValue;
    protected RuleOutput ruleOutput;
    public static final RuleOutputDetail UNDEF = new RuleOutputDetail();
    public static final List<RuleOutputDetail> EMPTY_LIST = new ArrayList<RuleOutputDetail>();
    protected static RuleOutputDAO ruleOutputDAO = null;
    protected static Logger logger = LoggerFactory.getLogger(RuleOutputDetail.class);

    public RuleOutputDetail() {
        this.setValid(false);
        this.setName("undefined_errorDetail");
        this.setDescription("Empty reference for a \"null\" ErrorDetail instance");
    }

    public RuleOutputDetail(Field field, String fieldValue) {
        this.setFieldID(field.getId());
        this.setFieldName(field.getName());
        this.setFieldValue(fieldValue);
    }

    public RuleOutputDetail(String label) {
        this.setFieldID(0);
        this.setFieldName("UNKNOWN");
        this.setFieldValue(label);
    }

    public RuleOutputDetail(String id, String fieldID, String fieldName, String fieldValue, String ruleOutputID) {
        this();
        this.valid = true;
        this.setId(id);
        this.setFieldID(fieldID);
        this.setFieldName(fieldName);
        this.setFieldValue(fieldValue);
        this.setRuleOutputID(ruleOutputID);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        ruleOutputDAO = (RuleOutputDAO)((Object)daoFactory.getDAO(DAO.RULE_OUTPUT));
        ruleOutputDAO.setLastValidationRun(true);
    }

    public RuleOutputDetail(String fieldName, String fieldValue) {
        this("0", "0", fieldName, fieldValue, "0");
    }

    public RuleOutputDetail(String fieldID, String fieldName, String fieldValue, String ruleOutputID) {
        this("0", fieldID, fieldName, fieldValue, ruleOutputID);
    }

    public RuleOutputDetail(String[] array) {
        this(array[0], array[1], array[2], array[3], array[4]);
    }

    public RuleOutput getRuleOutput() {
        int ruleOutputID = this.getRuleOutputID();
        if (this.isWrongID(ruleOutputID)) {
            return RuleOutput.UNDEF;
        }
        if (this.ruleOutput == null) {
            this.ruleOutput = (RuleOutput)ruleOutputDAO.getByID(ruleOutputID);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getRuleOutput() - Fetched RuleOutput: " + this.ruleOutput.toShortString());
        }
        if (this.ruleOutput.equals(RuleOutput.UNDEF)) {
            String message = ruleOutputDAO.isLastValidationRun() ? "Lazy fetching of RuleOutput failed because this RuleOutputDetail belongs to an old validation run" : "Lazy fetching of RuleOutput failed for unknown reasons";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        return this.ruleOutput;
    }

    public void setRuleOutput(RuleOutput ruleOutput) {
        this.ruleOutput = ruleOutput;
        if (this.ruleOutput != null) {
            int ruleOutputID = this.ruleOutput.getId();
            this.setRuleOutputID(ruleOutputID);
            logger.warn("setRuleOutput(): " + String.valueOf(ruleOutput) + " -> " + ruleOutputID);
        }
    }

    public void setRuleOutputID(String ruleOutputID) {
        this.setForeignId(ruleOutputID);
    }

    public void setRuleOutputID(int ruleOutputID) {
        this.setForeignId(ruleOutputID);
    }

    public int getRuleOutputID() {
        return this.getForeignId();
    }

    public void setFieldID(String fieldID) {
        this.fieldID = this.parseInteger("fieldID", fieldID);
    }

    public void setFieldName(String fieldName) {
        this.setName(fieldName);
    }

    public String getFieldName() {
        return this.getName();
    }

    public int getFieldID() {
        return this.fieldID;
    }

    public void setFieldID(int fieldID) {
        this.fieldID = fieldID;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    @Override
    public String[] serialize() {
        String fieldID = String.valueOf(this.getFieldID());
        String fieldName = String.valueOf(this.getFieldName());
        String fieldValue = String.valueOf(this.getFieldValue());
        String ruleOututID = String.valueOf(this.getRuleOutputID());
        String[] values = new String[]{this.getIdAsString(), fieldID, fieldName, fieldValue, ruleOututID};
        return values;
    }

    @Override
    protected String[] getHeader() {
        String[] values = new String[]{"ID", "FIELD_ID", "FIELD_NAME", "FIELD_VALUE", "RULE_OUTPUT_ID"};
        return values;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("id=");
        builder.append(this.getIdAsString());
        builder.append(", fieldName=");
        builder.append(this.name);
        builder.append(", fieldValue=");
        builder.append(this.fieldValue);
        builder.append(", outputID=");
        builder.append(this.getRuleOutputID());
        builder.append("]");
        return builder.toString();
    }
}

