/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.output;

import eu.europa.ec.jrc.qcs.dao.RuleDefinitionDAO;
import eu.europa.ec.jrc.qcs.dao.RuleOutputDetailDAO;
import eu.europa.ec.jrc.qcs.dao.ValidationRunDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.MessageType;
import eu.europa.ec.jrc.qcs.dao.model.SerializableModel;
import eu.europa.ec.jrc.qcs.dao.model.output.ReferenceData;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.dao.model.output.ValidationRun;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ValidationMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleOutput
extends SerializableModel {
    protected int messageNumber;
    protected int lineNumber;
    protected boolean validRecord;
    protected int ruleID;
    protected ReferenceData referenceData;
    protected ValidationRun validationRun;
    protected String errorCode;
    protected MessageType messageType;
    protected boolean additionalInfo;
    protected List<RuleOutputDetail> ruleOutputDetails;
    protected boolean detached;
    public static final RuleOutput UNDEF = new RuleOutput();
    public static final List<RuleOutput> EMPTY_LIST = new ArrayList<RuleOutput>();
    public static final List<RuleOutput> VALID = new ArrayList<RuleOutput>();
    public static final List<RuleOutput> INVALID = new ArrayList<RuleOutput>();
    public static final List<RuleOutput> CRITICAL = new ArrayList<RuleOutput>(Arrays.asList(UNDEF));
    public static final List<RuleOutput> NOT_APPLICABLE = new ArrayList<RuleOutput>();
    protected static ValidationRunDAO validationRunDAO;
    protected static RuleOutputDetailDAO ruleOutputDetailDAO;
    protected static RuleDefinitionDAO ruleDAO;
    protected static Logger logger;

    public RuleOutput() {
        this.setValid(false);
        this.setName("undefined_ruleOutput");
        this.setDescription("Empty reference for a \"null\" RuleOutput instance");
        this.setMessageType(MessageType.CRITICAL);
        this.setId(0);
        this.setValidationRunID(0);
    }

    public RuleOutput(ValidationMessage message) {
        this.detached = true;
        if (message != null) {
            this.setErrorCode(message.getCode());
            this.setMessageType(message.getMessageType());
            this.setDescription(message.getDescription());
        } else {
            this.setRuleID(0);
            this.setErrorCode("E-TEST");
            this.setMessageType(MessageType.WARNING);
            this.setDescription("Placehodlder: rule not fetched from DAO layer");
        }
        this.setReferenceData(ReferenceData.UNDEF);
    }

    public RuleOutput(String id, String messageNumber, String lineNumber, String validRecord, String ruleID, String errorCode, String messageType, String errorDescription, ReferenceData referenceData, String validationRunID) {
        this();
        this.valid = true;
        this.setName(errorCode);
        this.setId(id);
        this.setMessageNumber(messageNumber);
        this.setLineNumber(lineNumber);
        this.setValidRecord(validRecord);
        this.setRuleID(ruleID);
        this.setErrorCode(errorCode);
        this.setMessageType(messageType);
        this.setDescription(errorDescription);
        this.setReferenceData(referenceData);
        this.setValidationRunID(validationRunID);
    }

    public RuleOutput(String messageNumber, String lineNumber, String validRecord, String ruleID, String errorCode, String messageType, String description, ReferenceData referenceData, String validationRunID) {
        this("0", messageNumber, lineNumber, validRecord, ruleID, errorCode, messageType, description, referenceData, validationRunID);
        if (logger.isTraceEnabled()) {
            logger.trace("Created new object with reference data: " + referenceData.toShortString());
        }
    }

    public RuleOutput(String[] array) {
        this(array[0], array[1], array[2], array[3], array[4], array[5], array[6], array[7], new ReferenceData(array[8]), array[9]);
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor() - Received ReferenceData : " + array[8]);
        }
    }

    public ValidationRun getValidationRun() {
        int validatioRunID = this.getValidationRunID();
        if (this.isWrongID(validatioRunID)) {
            return ValidationRun.UNDEF;
        }
        if (this.validationRun == null) {
            this.validationRun = (ValidationRun)validationRunDAO.getByID(validatioRunID);
        }
        return this.validationRun;
    }

    public List<RuleOutputDetail> getAllRuleOutputDetail() {
        if (logger.isDebugEnabled()) {
            logger.debug("getAllRuleOutputDetail() - detached: " + this.detached);
        }
        if (this.detached) {
            return this.ruleOutputDetails;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getAllRuleOutputDetail() - using cached details? " + (this.ruleOutputDetails != null));
        }
        if (this.ruleOutputDetails == null) {
            int ruleOutputID = this.getId();
            this.ruleOutputDetails = ruleOutputDetailDAO.getByRuleOutputID(ruleOutputID);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getAllRuleOutputDetail() - ruleOutputDetails = " + String.valueOf(this.ruleOutputDetails));
        }
        if (this.ruleOutputDetails.equals(RuleOutputDetail.EMPTY_LIST)) {
            if (logger.isDebugEnabled()) {
                logger.debug("getAllRuleOutputDetail() - Fetched list: " + String.valueOf(this.ruleOutputDetails));
            }
            if (ruleOutputDetailDAO.isLastValidationRun()) {
                if (logger.isWarnEnabled()) {
                    String message = "Failed lazy fetching of RuleOutputDetail. Does this RuleOutput refer to last validation run?";
                    logger.warn("getAllRuleOutputDetail() - " + message + " RuleOutput: " + this.toString());
                }
            } else if (this.messageType != null && this.messageType.isUnexpected()) {
                if (logger.isDebugEnabled()) {
                    String message = "Failed lazy fetching of RuleOutputDetail, because RuleOutput message is unexpected";
                    logger.debug("getAllRuleOutputDetail() - " + message + " RuleOutput: " + this.toString());
                }
            } else {
                String message = "Lazy fetching of RuleOutputDetail failed for unknown reasons.";
                throw new IllegalStateException(message);
            }
        }
        return this.ruleOutputDetails;
    }

    public RuleDefinition getRule() {
        if (this.isWrongID(this.ruleID)) {
            return RuleDefinition.UNDEF;
        }
        return (RuleDefinition)ruleDAO.getByID(this.ruleID);
    }

    @Override
    public void setId(int id) {
        List<RuleOutputDetail> ruleOutputDetails;
        super.setId(id);
        if (this.detached && (ruleOutputDetails = this.getAllRuleOutputDetail()) != null) {
            for (RuleOutputDetail ruleOutputDetail : ruleOutputDetails) {
                ruleOutputDetail.setRuleOutputID(id);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("setID() - Set '" + ruleOutputDetail.getFieldName() + "' detail foreign key to " + id);
            }
        }
    }

    public void setValidationRunID(String validationRunID) {
        this.setForeignId(validationRunID);
    }

    public void setValidationRunID(int validationRunID) {
        this.setForeignId(validationRunID);
    }

    public int getValidationRunID() {
        return this.getForeignId();
    }

    public void setMessageNumber(String messageNumber) {
        this.messageNumber = this.parseInteger("messageNumber", messageNumber);
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = this.parseInteger("lineNumber", lineNumber);
        if (logger.isDebugEnabled()) {
            logger.debug("setLineNumber(String) for line number: " + lineNumber + " for output: " + this.toShortString());
        }
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
        if (logger.isDebugEnabled()) {
            logger.debug("setLineNumber(int) - line number: " + lineNumber + " for output: " + this.toShortString());
        }
    }

    public void setValidRecord(String validRecord) {
        this.validRecord = this.parseBoolean("validRecord", validRecord, true);
    }

    public void setRuleID(String ruleID) {
        this.ruleID = this.parseInteger("ruleID", ruleID);
    }

    public void setMessageType(String type) {
        this.messageType = MessageType.parseMessageType(type);
    }

    public void setReferenceData(String serializedData) {
        this.referenceData = new ReferenceData(serializedData);
    }

    public void resetReferenceData() {
        this.referenceData = null;
    }

    public int getMessageNumber() {
        return this.messageNumber;
    }

    public void setMessageNumber(int messageNumber) {
        this.messageNumber = messageNumber;
    }

    public boolean isValidRecord() {
        return this.validRecord;
    }

    public void setValidRecord(boolean validRecord) {
        this.validRecord = validRecord;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public void setValidationRun(ValidationRun validationRun) {
        this.validationRun = validationRun;
    }

    public void setReferenceData(ReferenceData referenceData) {
        this.referenceData = referenceData;
    }

    public ReferenceData getReferenceData() {
        return this.referenceData;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getRuleID() {
        return this.ruleID;
    }

    public void setRuleID(int ruleID) {
        this.ruleID = ruleID;
    }

    public boolean isAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(boolean additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public void setRuleOutputDetails(List<RuleOutputDetail> ruleOutputDetails) {
        this.ruleOutputDetails = ruleOutputDetails;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public void setDetached(boolean detached) {
        this.detached = detached;
    }

    @Override
    public String[] serialize() {
        String messageNumber = String.valueOf(this.messageNumber);
        String lineNumber = String.valueOf(this.lineNumber);
        String isValid = this.valueOf(this.validRecord);
        String ruleID = String.valueOf(this.ruleID);
        String errorCode = String.valueOf(this.errorCode);
        String errorType = String.valueOf((Object)this.messageType);
        String description = String.valueOf(this.description);
        String referenceData = this.referenceData == null ? "" : this.referenceData.stringfy();
        String validationRunID = String.valueOf(this.getValidationRunID());
        String[] values = new String[]{this.getIdAsString(), messageNumber, lineNumber, isValid, ruleID, errorCode, errorType, description, referenceData, validationRunID};
        return values;
    }

    @Override
    protected String[] getHeader() {
        String[] values = new String[]{"ID", "MESSAGE_NUMBER", "LINE_NUMBER", "VALID_RECORD", "RULE_ID", "ERROR_CODE", "ERROR_TYPE", "ERROR_DESCRIPTION", "REFERENCE_DATA", "VALIDATION_RUN_ID"};
        return values;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleOutput other = (RuleOutput)obj;
        if (this.additionalInfo != other.additionalInfo) {
            return false;
        }
        if (this.detached != other.detached) {
            return false;
        }
        if (this.errorCode == null ? other.errorCode != null : !this.errorCode.equals(other.errorCode)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.lineNumber != other.lineNumber) {
            return false;
        }
        if (this.messageNumber != other.messageNumber) {
            return false;
        }
        if (this.messageType != other.messageType) {
            return false;
        }
        if (this.ruleID != other.ruleID) {
            return false;
        }
        return this.validRecord == other.validRecord;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("id=");
        builder.append(this.getIdAsString());
        builder.append(", messageNumber=");
        builder.append(this.messageNumber);
        builder.append(", lineNumber=");
        builder.append(this.lineNumber);
        builder.append(", valid=");
        builder.append(this.validRecord);
        builder.append(", ruleID=");
        builder.append(this.ruleID);
        builder.append(", code=");
        builder.append(this.errorCode);
        builder.append(", line=");
        builder.append(this.lineNumber);
        builder.append(", type=");
        builder.append((Object)this.messageType);
        builder.append(", desc=");
        builder.append(this.description);
        builder.append(", runID=");
        builder.append(this.getValidationRunID());
        builder.append("]");
        return builder.toString();
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.messageNumber);
        builder.append(", line=");
        builder.append(this.lineNumber);
        builder.append(", code=");
        builder.append(this.errorCode);
        List<RuleOutputDetail> allRuleOutputDetails = this.getAllRuleOutputDetail();
        if (allRuleOutputDetails != null) {
            String sep = "";
            builder.append(", ");
            for (RuleOutputDetail ruleOutputDetail : allRuleOutputDetails) {
                builder.append(sep);
                builder.append(ruleOutputDetail.getFieldName());
                builder.append("=");
                builder.append(ruleOutputDetail.getFieldValue());
                sep = ", ";
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static String printShortList(List<RuleOutput> list) {
        if (list == null) {
            return "N/A";
        }
        String sep = "";
        StringBuilder builder = new StringBuilder();
        for (RuleOutput element : list) {
            builder.append(sep);
            builder.append("[ID=");
            builder.append(element.getId());
            builder.append(", ruleID=");
            builder.append(element.getRuleID());
            builder.append(", code=");
            builder.append(element.getErrorCode());
            builder.append("]");
            sep = " - ";
        }
        return builder.toString();
    }

    static {
        ruleDAO = null;
        logger = LoggerFactory.getLogger(RuleOutput.class);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        ruleDAO = (RuleDefinitionDAO)((Object)daoFactory.getDAO(DAO.RULE_DEFINITION));
        validationRunDAO = (ValidationRunDAO)((Object)daoFactory.getDAO(DAO.VALIDATION_RUN));
        ruleOutputDetailDAO = (RuleOutputDetailDAO)((Object)daoFactory.getDAO(DAO.RULE_OUTPUT_DETAIL));
    }
}

