/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.output;

import eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceDatum {
    protected ReferenceField referenceField;
    protected String value;
    public static boolean escapeJSON = true;
    protected static Logger logger = LoggerFactory.getLogger(ReferenceDatum.class);

    public ReferenceDatum(ReferenceField referenceField) {
        this.referenceField = referenceField;
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor(ReferenceField) - Created using referenceField:" + String.valueOf(referenceField));
        }
    }

    public ReferenceDatum(ReferenceField referenceField, String value) {
        this.referenceField = referenceField;
        this.value = value;
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor(ReferenceField, value) - Created using referenceField:" + String.valueOf(referenceField));
        }
    }

    public String stringfy() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getFieldLabel());
        builder.append(":");
        builder.append("\"");
        if (escapeJSON && this.value != null) {
            this.value = this.value.replaceAll(":", "_COLON_");
            this.value = this.value.replaceAll(",", "_COMMA_");
        }
        builder.append(this.value);
        builder.append("\"");
        if (logger.isTraceEnabled()) {
            logger.trace("stringfy() - Input objects     : " + this.getFieldLabel() + " -> " + this.value);
            logger.trace("stringfy() - Serialized object : " + String.valueOf(builder));
        }
        return builder.toString();
    }

    public Field getField() {
        if (this.referenceField == null) {
            String message = "getField() - Null ReferenceField property";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        return this.referenceField.getField();
    }

    public String getFieldLabel() {
        if (this.referenceField == null) {
            String message = "getFieldLabel() - Null ReferenceField property";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        return this.referenceField.getFieldLabel();
    }

    public ReferenceField getReferenceField() {
        return this.referenceField;
    }

    public void setReferenceField(ReferenceField referenceField) {
        this.referenceField = referenceField;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("key=");
        builder.append(this.referenceField.getFieldLabel());
        builder.append(", value=");
        builder.append(this.value);
        builder.append("]");
        return builder.toString();
    }
}

