/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.output;

import eu.europa.ec.jrc.qcs.dao.CachedMap;
import eu.europa.ec.jrc.qcs.dao.model.GenericJSON;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField;
import eu.europa.ec.jrc.qcs.dao.model.output.ReferenceDatum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceData
extends GenericModel
implements GenericJSON,
CachedMap {
    protected List<ReferenceDatum> allReferenceData;
    protected String json;
    protected List<ReferenceField> referenceFields;
    protected Map<String, ReferenceField> referenceFieldsByLabel;
    public static final ReferenceData UNDEF = new ReferenceData();
    protected static Logger logger = LoggerFactory.getLogger(ReferenceData.class);

    public ReferenceData() {
        this.setValid(false);
        this.setName("undefined_referenceData");
        this.setDescription("Empty reference for a \"null\" ReferenceData instance");
        this.setId(0);
    }

    public ReferenceData(String json) {
        this();
        this.json = json;
    }

    public ReferenceData(List<ReferenceDatum> allReferenceData) {
        this.allReferenceData = allReferenceData;
    }

    public ReferenceData(List<ReferenceField> referenceFields, boolean init) {
        this();
        this.referenceFields = referenceFields;
        if (logger.isDebugEnabled()) {
            logger.debug("Creating ReferenceData with referenceFields: " + String.valueOf(referenceFields));
        }
        if (init) {
            this.loadData();
        }
    }

    @Override
    public void initCache() {
        this.referenceFieldsByLabel = new HashMap<String, ReferenceField>();
    }

    public void loadData() {
        if (this.referenceFields == null) {
            String message = "loadData() - Cache can't be created from a null list of ReferenceFields";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        int size = this.referenceFields.size();
        if (size == 0) {
            String message = "loadData() - Cache can't be created from an empty list of ReferenceFields";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        this.initCache();
        for (ReferenceField referenceField : this.referenceFields) {
            String fieldLabel = referenceField.getFieldLabel();
            this.referenceFieldsByLabel.put(fieldLabel, referenceField);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadData() - Created ReferenceFieldsByLabel map with : " + this.referenceFieldsByLabel.size() + " elements");
        }
    }

    @Override
    public void parse() {
        this.parse(this.json);
    }

    @Override
    public void parse(String json) {
        if (json == null) {
            String message = "parse() - Impossible to parse a null JSON string";
            logger.warn(message);
            return;
        }
        json.trim();
        boolean debug = logger.isTraceEnabled();
        if (json.length() <= 2) {
            String message = "parse() - Impossible to parse an empty JSON string: " + json;
            if (debug) {
                logger.info(message);
            }
            return;
        }
        if (this.parseJSON()) {
            if (debug) {
                logger.info("parse() - Parsed JSON: " + json);
            }
        } else {
            logger.warn("parse() - NOT_ PARSED JSON: " + this.json);
        }
        this.json = new String(json);
    }

    @Override
    public String stringfy() {
        if (this == UNDEF) {
            return "";
        }
        if (this.allReferenceData == null && this.json != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("stringfy() - Null list of reference data: returning existing JSON");
            }
            return this.json;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("stringfy() - Serialising collection data: " + String.valueOf(this.allReferenceData));
        }
        this.json = this.getJSON();
        return this.json;
    }

    public void setReferenceData(ReferenceData referenceData) {
        this.referenceFieldsByLabel = referenceData.getReferenceFieldsByLabel();
    }

    public void setReferenceFields(List<ReferenceField> referenceFields) {
        this.referenceFields = referenceFields;
        this.loadData();
    }

    public ReferenceField getReferenceFieldByLabel(String fieldLabel) {
        if (this.referenceFieldsByLabel == null) {
            this.loadData();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReferenceFieldByLabel() - Searching for field label: #" + fieldLabel + "#");
        }
        if (this.referenceFieldsByLabel == null) {
            String message = "Found null list of reference fields";
            logger.error("getReferenceFieldByLabel() - " + message);
            throw new IllegalStateException(message);
        }
        if (fieldLabel == null) {
            String message = "Found null field label";
            logger.error("getReferenceFieldByLabel() - " + message);
            throw new IllegalStateException(message);
        }
        fieldLabel = fieldLabel.trim();
        return this.referenceFieldsByLabel.get(fieldLabel);
    }

    public List<ReferenceDatum> getAllReferenceData() {
        if (this.allReferenceData == null) {
            this.parse();
        }
        return this.allReferenceData;
    }

    protected String getJSON() {
        String sep = "";
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (this.allReferenceData != null) {
            for (ReferenceDatum referenceDatum : this.allReferenceData) {
                builder.append(sep);
                builder.append(referenceDatum.stringfy());
                sep = ",";
            }
        } else {
            logger.warn("getJSON() - Null collection data for instance: " + this.toShortString());
        }
        builder.append("}");
        return builder.toString();
    }

    protected boolean parseJSON() {
        if (logger.isTraceEnabled()) {
            logger.trace("parseJSON() - Parsing: #" + this.json + "#");
        }
        this.allReferenceData = new ArrayList<ReferenceDatum>();
        String stripped = this.json.substring(1, this.json.length() - 1);
        Object[] tokens = stripped.split(",");
        if (logger.isTraceEnabled()) {
            logger.trace("parseJSON() - Tokens: " + Arrays.toString(tokens));
        }
        for (Object token : tokens) {
            String[] arguments;
            if (token == null) {
                String message = "parseJSON() - Found a null JSON's token";
                logger.error(message);
                throw new IllegalStateException(message);
            }
            ((String)token).trim();
            if (logger.isTraceEnabled()) {
                logger.trace("parseJSON() - Parsing token (escaped): #" + (String)token + "#");
            }
            if (ReferenceDatum.escapeJSON) {
                token = ((String)token).replaceAll("_COMMA_", ",");
            }
            if (logger.isTraceEnabled()) {
                logger.trace("parseJSON() - Parsing token (un-escaped): #" + (String)token + "#");
            }
            if ((arguments = ((String)token).split(":")) == null || arguments.length != 2) {
                String message = "parseJSON() - Wrong JSON's token syntax: " + (String)token;
                logger.error(message);
                return false;
            }
            String key = this.removeLeadingTrailingQuotes(arguments[0]);
            String value = this.removeLeadingTrailingQuotes(arguments[1]);
            if (ReferenceDatum.escapeJSON) {
                value = value.replaceAll("_COLON_", ":");
            }
            if (key != null) {
                key = key.trim();
            } else {
                logger.error("parseJSON() - Found null key for value: " + value);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("parseJSON() - Argument: " + key + " -> " + value);
            }
            ReferenceField referenceField = this.getReferenceFieldByLabel(key);
            ReferenceDatum referenceDatum = new ReferenceDatum(referenceField, value);
            this.allReferenceData.add(referenceDatum);
        }
        return this.allReferenceData.size() > 0;
    }

    protected String removeLeadingTrailingQuotes(String string) {
        if (string == null) {
            return null;
        }
        string.trim();
        if (string.startsWith("\"")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public void setAllReferenceData(List<ReferenceDatum> allReferenceData) {
        this.allReferenceData = allReferenceData;
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public List<ReferenceField> getReferenceFields() {
        return this.referenceFields;
    }

    public void setReferenceFieldsByLabel(Map<String, ReferenceField> referenceFieldsByLabel) {
        this.referenceFieldsByLabel = referenceFieldsByLabel;
    }

    public Map<String, ReferenceField> getReferenceFieldsByLabel() {
        return this.referenceFieldsByLabel;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (this.allReferenceData != null) {
            String sep = "";
            for (ReferenceDatum referenceDatum : this.allReferenceData) {
                builder.append(sep);
                builder.append(referenceDatum);
                sep = ",";
            }
        } else {
            builder.append("N/A");
        }
        return builder.toString();
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("data=");
        if (this.allReferenceData != null) {
            builder.append(this.allReferenceData.size());
        } else {
            builder.append("null");
        }
        if (this.json != null) {
            int max = 30;
            builder.append(", json=");
            if (this.json.length() < max) {
                builder.append(this.json);
            } else {
                builder.append(this.json.substring(0, max));
                builder.append("...}");
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

