/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.input;

import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRecordCSV
extends DataRecord {
    protected String[] array;
    protected String[] columnNames;
    protected Map<String, Integer> columnMap;
    protected Map<Integer, String> functionValues;
    protected int[] filter;
    protected static Logger logger = LoggerFactory.getLogger(DataRecordCSV.class);

    public DataRecordCSV() {
    }

    public DataRecordCSV(String[] array) {
        this.array = array;
    }

    public DataRecordCSV(DataRecord record) {
        String[] array = record.getArray();
        this.array = (String[])array.clone();
    }

    protected void init() {
        if (this.columnNames == null) {
            return;
        }
        this.columnMap = new HashMap<String, Integer>();
        for (String column : this.columnNames) {
            int index = this.getIndexByName(column);
            this.columnMap.put(column, index);
        }
    }

    @Override
    public void setValue(int index, String value) {
        if (this.array == null) {
            logger.warn("setValue(): null array");
            return;
        }
        if (index >= this.array.length) {
            logger.error("setValue() - Index " + index + " is bigger then array size (" + this.array.length + ")");
            return;
        }
        this.array[index] = value;
    }

    @Override
    public String getValue(int index) {
        if (this.array == null) {
            logger.warn("getValue(): null array");
            return null;
        }
        if (index < 0) {
            logger.warn("getValue() - Negative index " + index);
            return null;
        }
        if (index >= this.array.length) {
            if (logger.isDebugEnabled()) {
                logger.debug("getValue() - Index " + index + " is bigger then array size (" + this.array.length + ")");
            }
            return null;
        }
        return this.array[index];
    }

    @Override
    public String getValue(String name) {
        int index = this.getIndexByName(name);
        if (index < 0) {
            logger.warn("getValue - Failed to find index for column: " + name);
            return null;
        }
        return this.getValue(index);
    }

    @Override
    public void setFunctionValue(int fieldID, String value) {
        if (this.functionValues == null) {
            this.functionValues = new HashMap<Integer, String>();
        }
        this.functionValues.put(fieldID, value);
        if (logger.isDebugEnabled()) {
            logger.debug("setFunctionValue() - Stored function value for fieldID " + fieldID + " -> " + value);
        }
    }

    @Override
    public String getFunctionValue(int fieldID) {
        if (this.functionValues == null) {
            logger.warn("getFunctionValue(): null collection");
            return null;
        }
        String value = this.functionValues.get(fieldID);
        if (logger.isDebugEnabled()) {
            logger.debug("setFunctionValue() - Fetched function value for fieldID " + fieldID + " -> " + value);
        }
        return value;
    }

    @Override
    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
        boolean verbose = false;
        if (columnNames == null || columnNames.length > 0) {
            // empty if block
        }
        if (verbose) {
            logger.info("setColumnNames() - Set columns: " + Arrays.toString(this.columnNames));
        }
    }

    @Override
    public int getSize() {
        if (this.array == null) {
            logger.warn("getSize invoked on null array");
            return -1;
        }
        return this.array.length;
    }

    @Override
    public int unshift(String header, String value) {
        String[] oldArray = this.getArray();
        String[] oldColummNames = this.getHeader();
        int length = oldColummNames.length + 1;
        String[] newArray = new String[length];
        Object[] newColumnNames = new String[length];
        newArray[0] = new String(value);
        newColumnNames[0] = new String(header);
        for (int i = 1; i < length; ++i) {
            try {
                newArray[i] = oldArray[i - 1];
                newColumnNames[i] = oldColummNames[i - 1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                logger.warn("unshift() - Column names not coherent with record: " + oldColummNames.length + " columns, but array.length = " + oldArray.length);
                break;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("unshift() - array[" + (i - 1) + "] -> array[" + i + "] = " + (String)newColumnNames[i] + ", " + newArray[i]);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("unshift() - Setting columnNames: " + Arrays.toString(newColumnNames));
        }
        this.setArray(newArray);
        this.setColumnNames((String[])newColumnNames);
        return newArray.length;
    }

    @Override
    public int push(String header, String value) {
        String[] oldArray = this.getArray();
        String[] oldColummNames = this.getHeader();
        int length = oldColummNames.length + 1;
        String[] newArray = new String[length];
        Object[] newColumnNames = new String[length];
        for (int i = 0; i < length - 1; ++i) {
            try {
                newArray[i] = oldArray[i];
                newColumnNames[i] = oldColummNames[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                logger.warn("push() - Column names not coherent with record: " + oldColummNames.length + " columns, but array.length = " + oldArray.length);
                break;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("push() - array[" + (i - 1) + "] -> array[" + i + "] = " + (String)newColumnNames[i] + ", " + newArray[i]);
        }
        newArray[i] = new String(value);
        newColumnNames[i] = new String(header);
        if (logger.isTraceEnabled()) {
            logger.trace("push() - Setting columnNames: " + Arrays.toString(newColumnNames));
        }
        this.setArray(newArray);
        this.setColumnNames((String[])newColumnNames);
        return newArray.length;
    }

    @Override
    public String pop() {
        String[] oldArray = this.getArray();
        String[] oldColummNames = this.getHeader();
        String[] newArray = new String[oldArray.length - 1];
        Object[] newColumnNames = new String[oldColummNames.length - 1];
        String poppedValue = oldArray[oldArray.length - 1];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = oldArray[i];
            newColumnNames[i] = oldColummNames[i];
            if (!logger.isDebugEnabled()) continue;
            logger.debug("pop() - array[" + i + "] = " + (String)newColumnNames[i] + ", " + newArray[i]);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("pop() - Setting columnNames: " + Arrays.toString(newColumnNames));
        }
        this.setArray(newArray);
        this.setColumnNames((String[])newColumnNames);
        return poppedValue;
    }

    @Override
    public DataRecord getFilteredRecord() {
        String[] filtered = this.getFilteredArray();
        return new DataRecordCSV(filtered);
    }

    @Override
    public String[] getFilteredArray() {
        String[] array = new String[this.filter.length];
        for (int i = 0; i < this.filter.length; ++i) {
            array[i] = this.getValue(this.filter[i]);
        }
        return array;
    }

    protected int getIndexByName(String name) {
        if (this.columnNames == null) {
            return -1;
        }
        for (int i = 0; i < this.columnNames.length && this.columnNames[i] != null; ++i) {
            if (!this.columnNames[i].equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String[] serialize() {
        return this.getArray();
    }

    @Override
    protected String[] getHeader() {
        Object[] columns = this.getColumnNames();
        if (logger.isTraceEnabled()) {
            logger.trace("getHeader() - Handling columns: " + Arrays.toString(columns));
        }
        if (columns == null || columns.length < 1) {
            String[] data = this.getArray();
            columns = data == null || data.length < 1 ? new String[1] : new String[data.length];
            for (int i = 0; i < columns.length; ++i) {
                columns[i] = "COLUMN_" + i;
            }
        }
        return columns;
    }

    @Override
    public String toShortString() {
        int max = 10;
        int span = max < this.getSize() ? max : this.getSize();
        String sep = "";
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < span; ++i) {
            builder.append(sep);
            builder.append(this.getValue(i));
            sep = ";";
        }
        if (max < this.getSize()) {
            builder.append("...");
        }
        return builder.toString();
    }

    @Override
    public String[] getArray() {
        return this.array;
    }

    public void setArray(String[] array) {
        this.array = array;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public int[] getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(int[] filter) {
        this.filter = filter;
    }

    @Override
    public DataRecord clone() {
        String[] values = this.getArray();
        String[] columns = this.getColumnNames();
        Object[] newColumns = null;
        String[] newValues = (String[])values.clone();
        if (columns != null) {
            newColumns = (String[])columns.clone();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("clone() - Setting columnNames: " + Arrays.toString(newColumns));
        }
        DataRecordCSV dataRecord = new DataRecordCSV(newValues);
        dataRecord.setColumnNames((String[])newColumns);
        return dataRecord;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

