/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.config;

import eu.europa.ec.jrc.qcs.dao.CachedMap;
import eu.europa.ec.jrc.qcs.dao.ProtocolDAO;
import eu.europa.ec.jrc.qcs.dao.ReferenceFieldDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaGroupDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.GenericProperties;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemasGroup;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultProtocolID;
import eu.europa.ec.jrc.qcs.gui.model.LicenseModel;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.SwingPropertyChangeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationOptions
extends GenericProperties
implements CachedMap {
    protected List<SchemasGroup> schemaGroups;
    protected List<Protocol> protocols;
    protected Map<Integer, List<ReferenceField>> referenceFields;
    private SwingPropertyChangeSupport pcSupport = new SwingPropertyChangeSupport(this);
    protected LicenseModel licenseModel;
    public static final int DISABLE_STRIP_QUOTES = 0;
    public static final int STRIP_ALL_QUOTES = 1;
    protected static Logger logger = LoggerFactory.getLogger(ValidationOptions.class);

    public ValidationOptions(Properties properties) {
        super(properties);
        if (properties == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Null properties file: setting default configuration");
            }
            this.setDefaults();
        }
        this.licenseModel = new LicenseModel();
        this.initCache();
    }

    @Override
    public void initCache() {
        this.schemaGroups = this.loadSchemaGroups();
        this.protocols = this.loadProtocols();
        this.referenceFields = this.loadReferenceFields();
    }

    public void setDefaults() {
        String rootDir = this.getWorkingDir();
        String dataset = rootDir + "docs/data/input/incidence/incidence_1.csv";
        this.properties = new Properties();
        this.properties.setProperty(Property.DEFAULT_PROTOCOL.key, Integer.toString(DefaultProtocolID.INCIDENCE_2020.id));
        this.properties.setProperty(Property.MANDATORY_FLAG_1.key, "true");
        this.properties.setProperty(Property.REPORTS_DETAILED.key, "true");
        this.properties.setProperty(Property.REFERENCE_DATA.key, "true");
        this.properties.setProperty(Property.DEFAULT_INPUT_DIR.key, rootDir);
        this.properties.setProperty(Property.DEFAULT_INPUT_FILE.key, "C:/Home/workspace/qcs-2.0/incidence_1_2020.csv");
        if (logger.isInfoEnabled()) {
            logger.info("setDefaults() - Loaded default configuration. Root: " + rootDir);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("setDefaults() - Set default dataset: " + dataset);
        }
    }

    protected String getWorkingDir() {
        String rootDir = null;
        try {
            String path = ValidationOptions.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            File file = new File(path);
            file = file.isFile() ? file.getParentFile() : new File(file.getPath()).getParentFile().getParentFile();
            rootDir = file.getAbsolutePath();
            if (logger.isDebugEnabled()) {
                logger.debug("getWorkingDir() - Root Directory: " + rootDir);
            }
        }
        catch (URISyntaxException e) {
            logger.error("getWorkingDir() - URISyntaxException: " + e.getMessage());
            e.printStackTrace();
        }
        return rootDir;
    }

    protected List<SchemasGroup> loadSchemaGroups() {
        if (logger.isDebugEnabled()) {
            logger.debug("loadSchemaGroups: loading all schemas groups");
        }
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        SchemaGroupDAO schemaGroupDAO = (SchemaGroupDAO)((Object)daoFactory.getDAO(DAO.SCHEMAS_GROUP));
        List<SchemasGroup> list = schemaGroupDAO.getAll();
        if (logger.isDebugEnabled()) {
            logger.debug("loadSchemaGroups - groupsList: " + String.valueOf(list) + " [" + list.size() + "]");
        }
        return list;
    }

    protected List<Protocol> loadProtocols() {
        if (logger.isDebugEnabled()) {
            logger.debug("loadProtocols() - Loading all protocols");
        }
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        ProtocolDAO protocolDAO = (ProtocolDAO)((Object)daoFactory.getDAO(DAO.PROTOCOL));
        List<Protocol> list = protocolDAO.getAllByOrder();
        if (logger.isDebugEnabled()) {
            logger.debug("loadProtocols() - GroupsList: " + String.valueOf(list) + " [" + list.size() + "]");
        }
        ArrayList<Protocol> filteredList = new ArrayList<Protocol>();
        for (Protocol protocol : list) {
            if (protocol.getOrder() > 0) {
                filteredList.add(protocol);
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("loadProtocols() - Evaluated protocol: " + protocol.toShortString());
        }
        return filteredList;
    }

    protected Map<Integer, List<ReferenceField>> loadReferenceFields() {
        this.referenceFields = new HashMap<Integer, List<ReferenceField>>();
        if (logger.isDebugEnabled()) {
            logger.debug("loadReferenceFields() - Created brand new Registry Fields map");
        }
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        ReferenceFieldDAO referenceFieldDAO = (ReferenceFieldDAO)((Object)daoFactory.getDAO(DAO.REFERENCE_FIELD));
        for (Protocol protocol : this.protocols) {
            int protocolID = protocol.getId();
            List<ReferenceField> listByProtocol = referenceFieldDAO.getSortedByProtocolID(protocolID);
            this.referenceFields.put(protocolID, listByProtocol);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("loadReferenceFields() - Number of RegistryFields for protocol " + protocolID + " : " + listByProtocol.size());
        }
        return this.referenceFields;
    }

    public int getIntegerValue(Property option) {
        int integer;
        block2: {
            String value = this.getValue(option);
            try {
                integer = Integer.parseInt(value);
            }
            catch (Exception e) {
                integer = -1;
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("getIntegerProperty() - Wrong integer property: " + value);
            }
        }
        return integer;
    }

    public boolean getBooleanValue(Property option) {
        boolean flag;
        block2: {
            String value = this.getValue(option);
            try {
                flag = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                flag = false;
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("getBooleanProperty() - Wrong boolean property: " + value);
            }
        }
        return flag;
    }

    public String getValue(Property option) {
        if (this.properties != null) {
            return this.properties.getProperty(option.key);
        }
        throw new UnsupportedOperationException("Database DAO pattern not implemented yet");
    }

    public void setValue(Property option, String value) {
        if (value != null) {
            this.properties.setProperty(option.key, value);
        }
    }

    public void setValue(Property option, int value) {
        this.properties.setProperty(option.key, Integer.toString(value));
    }

    public void setValue(Property option, boolean value) {
        this.properties.setProperty(option.key, Boolean.toString(value));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcSupport.addPropertyChangeListener(listener);
        if (logger.isDebugEnabled()) {
            logger.debug("addPropertyChangeListener(): Added - " + String.valueOf(listener));
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcSupport.removePropertyChangeListener(listener);
        if (logger.isDebugEnabled()) {
            logger.debug("removePropertyChangeListener(): Removed - " + String.valueOf(listener));
        }
    }

    public List<ReferenceField> getReferenceFields(int protocolID) {
        if (this.referenceFields == null) {
            return ReferenceField.EMPTY;
        }
        List<ReferenceField> list = this.referenceFields.get(protocolID);
        if (list == null || list.size() == 0) {
            return ReferenceField.EMPTY;
        }
        return list;
    }

    public boolean checkLicenseKey() {
        LicenseModel licenseModel = this.getLicenseModel();
        return licenseModel.checkLicenseKey();
    }

    public boolean isDemoMode(String licenseKey) {
        return "demo".equalsIgnoreCase(licenseKey);
    }

    public List<SchemasGroup> getSchemaGroups() {
        return this.schemaGroups;
    }

    public void setSchemaGroups(List<SchemasGroup> schemaGroups) {
        this.schemaGroups = schemaGroups;
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<Protocol> protocols) {
        this.protocols = protocols;
    }

    public Map<Integer, List<ReferenceField>> getReferenceFields() {
        return this.referenceFields;
    }

    public void setReferenceFields(Map<Integer, List<ReferenceField>> referenceFields) {
        this.referenceFields = referenceFields;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public void setLicenseModel(LicenseModel licenseModel) {
        this.licenseModel = licenseModel;
    }

    public void doSomething() {
        if (logger.isDebugEnabled()) {
            logger.debug("doSomething() - Example of property change event MVC compliant");
        }
    }
}

