/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.config;

import eu.europa.ec.jrc.qcs.dao.FieldDAO;
import eu.europa.ec.jrc.qcs.dao.ProtocolDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolToRule;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceField
extends GenericModel {
    protected Protocol protocol;
    protected Field field;
    protected String fieldLabel;
    protected int position;
    protected int order;
    protected int keyPosition;
    public static final String FK_PROTOCOL_ID = "protocolId";
    public static final ReferenceField UNDEF = new ReferenceField();
    public static final List<ReferenceField> EMPTY = new ArrayList<ReferenceField>();
    protected static ProtocolDAO protocolDAO;
    protected static FieldDAO fieldDAO;
    protected static Logger logger;

    public ReferenceField() {
        super(0, 0);
        this.setValid(false);
        this.setName("undefined_referenceField");
        this.setDescription("Empty reference for a \"null\" ReferenceField instance");
    }

    public ReferenceField(int id) {
        super(id);
    }

    public ReferenceField(int id, String protocolID, String fieldID, String fieldLabel) {
        this(id);
        this.setProtocolID(protocolID);
        this.setFieldID(fieldID);
    }

    public ReferenceField(String[] array) {
        this();
        this.valid = true;
        if (array[7] != null && array[7].trim().length() > 0) {
            this.setName(array[7]);
        } else if (array[3] != null && array[3].trim().length() > 0) {
            this.setName(array[3]);
        } else {
            this.setName("Field_" + array[2]);
        }
        this.setId(array[0]);
        this.setProtocolID(array[1]);
        this.setFieldID(array[2]);
        if (array[3] != null && array[3].trim().length() > 0) {
            this.setFieldLabel(array[3]);
        } else {
            this.setFieldLabel(Integer.toString(this.getFieldID()));
        }
        this.setPosition(array[4]);
        this.setOrder(array[5]);
        this.setKeyPosition(array[6]);
        this.setDescription(this.getName());
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor(array) - Input array: " + Arrays.toString(array));
        }
    }

    public ReferenceField(eu.europa.ec.jrc.qcs.dao.dto.ReferenceField dto) {
        this();
        if (dto == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Costructor(dto) - Null argument");
            }
            this.valid = false;
            return;
        }
        this.setId(dto.getId());
        this.setProtocolID(String.valueOf(dto.getProtocol().getId()));
        this.setFieldID(dto.getField().getId());
        this.setName(dto.getName());
        this.setFieldLabel(dto.getFieldLabel());
        this.setPosition(dto.getPosition());
        this.setKeyPosition(dto.getKeyPosition());
        this.setOrder(dto.getOrderNumber());
        this.setKeyPosition(dto.getKeyPosition());
        this.valid = true;
    }

    public Protocol getProtocol() {
        int protocolID = this.getProtocolID();
        if (this.isWrongID(protocolID)) {
            return Protocol.UNDEF;
        }
        if (this.protocol == null) {
            this.protocol = (Protocol)protocolDAO.getByID(protocolID);
        }
        return this.protocol;
    }

    public Field getField() {
        int fieldID = this.getFieldID();
        if (this.isWrongID(fieldID)) {
            return Field.UNDEF;
        }
        if (this.field == null) {
            this.field = (Field)fieldDAO.getByID(fieldID);
        }
        return this.field;
    }

    public void setProtocolID(String value) {
        this.setForeignId(FK_PROTOCOL_ID, value);
    }

    public int getProtocolID() {
        return this.getForeignId(FK_PROTOCOL_ID);
    }

    public void setFieldID(String value) {
        if (GenericModel.isNullInteger(value) && this.isNillableForeignKey()) {
            this.setNullForeignId();
        } else {
            this.setForeignId(value);
        }
    }

    public void setFieldID(int ruleID) {
        this.setForeignId(ruleID);
    }

    public int getFieldID() {
        return this.getForeignId();
    }

    public void setPosition(String position) {
        this.position = this.parseInteger("position", position);
    }

    public void setPosition(int position) {
        this.position = this.parseInteger("position", position);
    }

    public void setOrder(String order) {
        this.order = this.parseInteger("order", order);
        if (this.order == -2147483001) {
            this.order = 0;
        }
    }

    public void setOrder(int order) {
        this.order = this.parseInteger("order", order);
        if (this.order == -2147483001) {
            this.order = 0;
        }
    }

    public void setKeyPosition(String keyPosition) {
        this.keyPosition = this.parseInteger("keyPosition", keyPosition);
        if (this.keyPosition == -2147483001) {
            this.keyPosition = 0;
        }
    }

    public void setKeyPosition(int keyPosition) {
        this.keyPosition = this.parseInteger("keyPosition", keyPosition);
        if (this.keyPosition == -2147483001) {
            this.keyPosition = 0;
        }
    }

    public boolean isCollated(List<ReferenceField> list) {
        for (ReferenceField referenceField : list) {
            if (this.position != referenceField.getPosition() || this.id == referenceField.getId()) continue;
            return true;
        }
        return false;
    }

    public boolean isFirstKeyField() {
        return this.keyPosition == 1;
    }

    public String getFieldLabel() {
        return this.fieldLabel;
    }

    public void setFieldLabel(String fieldLabel) {
        this.fieldLabel = fieldLabel;
    }

    public int getPosition() {
        return this.position;
    }

    public int getOrder() {
        return this.order;
    }

    public int getKeyPosition() {
        return this.keyPosition;
    }

    public static void sortByOrder(List<ReferenceField> list) {
        Comparator<ReferenceField> compareByOrder = new Comparator<ReferenceField>(){

            @Override
            public int compare(ReferenceField field_1, ReferenceField field_2) {
                Integer order_1 = field_1.getOrder();
                Integer order_2 = field_2.getOrder();
                return order_1.compareTo(order_2);
            }
        };
        Collections.sort(list, compareByOrder);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("id=");
        builder.append(this.getId());
        builder.append(", protocolID=");
        builder.append(this.getIntegerLabel(this.getProtocolID()));
        builder.append(", fieldID=");
        builder.append(this.getIntegerLabel(this.getFieldID()));
        builder.append(", fieldLabel=");
        builder.append(this.fieldLabel);
        builder.append(", position=");
        builder.append(this.position);
        builder.append(", order=");
        builder.append(this.order);
        builder.append(", keyPosition=");
        builder.append(this.keyPosition);
        if (this.name != null) {
            builder.append(", name=");
            builder.append(this.name);
        }
        builder.append("]");
        return builder.toString();
    }

    public String formatMapping(String fieldValue) {
        Field field = this.getField();
        StringBuilder builder = new StringBuilder();
        Formatter formatter = new Formatter(builder, Locale.ENGLISH);
        String format = "%-12s %-10s %-1s %-10s %-2s %-2s %-11s %-12s %-5s %-13s";
        formatter.format(format, "Schema.Field", field.getName(), "=", fieldValue, "->", this.getPosition(), "FieldLabel:", this.getFieldLabel(), "Name:", this.getName());
        formatter.close();
        return builder.toString();
    }

    public static String formatList(List<ReferenceField> list) {
        String sep = "";
        StringBuilder builder = new StringBuilder();
        for (ReferenceField referenceField : list) {
            builder.append(sep);
            builder.append(referenceField.getFieldLabel());
            sep = ", ";
        }
        return builder.toString();
    }

    static {
        logger = LoggerFactory.getLogger(ProtocolToRule.class);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        protocolDAO = (ProtocolDAO)((Object)daoFactory.getDAO(DAO.PROTOCOL));
        fieldDAO = (FieldDAO)((Object)daoFactory.getDAO(DAO.FIELD));
    }
}

