/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.config;

public enum Property {
    NAME("version.name", "Name of the application", "Quality Check Software", 0),
    PREFIX("version.prefix", "Prefix of the version label", "QCS", 0),
    VERSION("version.code", "Actual version reference code", "2.0", 0),
    TITLE("window.title", "Title of the main GUI's window", "QCS - Fallback version (broken)", 0),
    BANNER_IMG("window.banner", "Top banner of the main GUI", "/images/eu-jrc-banner.png", 0),
    BANNER_COL("window.banner.col", "Right tiny column of the top banner", "/images/eu-jrc-banner-column.png", 0),
    MAX_GROUP_ID("max.group.id", "Maximum ID of the validation groups", "4", 0),
    DEFAULT_PROTOCOL("default.protocol.id", "ID of the default validation protocol", "11", 0),
    MPMT_CRITERION("mpmt.acceptance.criterion", "Select the acceptance criterion for the MP rule", "2", 1),
    MPMT_ALGORITHM("mpmt.merge.enabled", "Enable/disable the MPMT Algorithm", "false", 0),
    MANDATORY_FLAG_1("survival.unknown", "Enable/disable W-UNKN for survival vars", "false", 0),
    DEFAULT_INPUT_DIR("default.input.dir", "Path of the default input directory", "/.", 0),
    DEFAULT_INPUT_FILE("default.input.file", "Path of the default input file", "/.", 0),
    REPORTS_DETAILED("reports.detailed", "Enable/disable detailed output (privacy)", "true", 0),
    REPORTS_FIELDS("reports.fields", "Enable/disable fields statistics", "false", 0),
    REFERENCE_DATA("reference.data", "Enable/disable the registry data feature", "true", 0),
    REPORT_CSV("report.csv", "If true, the CSV report is produced", "true", 0),
    REPORT_TXT("report.txt", "If true, the TXT report is produced", "true", 0),
    REPORT_PDF("report.pdf", "If true, the PDF report is produced", "true", 0),
    REPORT_SUMMARY("report.summary", "If true, the short TXT report is produced", "true", 0),
    GUI_INIT_ALERT("gui.init.alert", "If true, the 'init' alert is shown at start", "true", 0),
    GUI_FILE_CHOOSER("gui.file.chooser", "The Swing/AWT component used as file chooser", "awt", 0),
    GUI_LICENSE_VALUE("gui.license.value", "Stores if user accepted license", "no", 0),
    REPORT_HASH("report.hash", "If true, hashed info are added to reports", "false", 0),
    MONITOR_BUNCH_SIZE("monitor.bunch.size", "The number of lines triggering log messages", "1000", 0),
    STRIP_CRITERION("strip.quotes.criterion", "Select the criterion for trimming quotes", "0", 2),
    MPMT_MATCH_INFO("mpmt.match.info", "If true, all MP matching info are printed", "false", 0);

    public final String key;
    public final String description;
    public final String fallback;
    public final int index;

    private Property(String key, String description, String fallback, int index) {
        this.key = key;
        this.description = description;
        this.fallback = fallback;
        this.index = index;
    }

    public static Property getProperty(String key) {
        for (Property entry : Property.values()) {
            if (!key.equalsIgnoreCase(entry.key)) continue;
            return entry;
        }
        return null;
    }
}

