/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.config;

import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import java.net.URI;
import java.util.List;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerConfiguration
extends GenericModel {
    private List<LoggerContext> contexts;
    private List<Appender> appenders;
    private boolean matchesAppenders;
    private boolean external;
    protected static Logger logger = LoggerFactory.getLogger(LoggerConfiguration.class);

    public LoggerConfiguration(List<LoggerContext> contexts) {
        this.contexts = contexts;
    }

    @Override
    public boolean isValid() {
        return this.contexts != null;
    }

    public boolean matchesAppenders() {
        return this.matchesAppenders;
    }

    public void setMatchesAppenders(boolean mathesFile) {
        this.matchesAppenders = mathesFile;
    }

    public List<LoggerContext> getContexts() {
        return this.contexts;
    }

    public void setContexts(List<LoggerContext> contexts) {
        this.contexts = contexts;
    }

    public List<Appender> getAppenders() {
        return this.appenders;
    }

    public void setAppenders(List<Appender> appenders) {
        this.appenders = appenders;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public String getLoggersInfo() {
        if (this.contexts.size() < 1) {
            return "ERROR: empty logger's contexts!";
        }
        LoggerContext context = this.contexts.get(0);
        URI configFile = context.getConfigLocation();
        boolean hasThisLogger = context.hasLogger(this.getClass().getCanonicalName());
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        builder.append("Logger contexts      : ");
        builder.append(this.contexts.size());
        builder.append("\n");
        builder.append("Has this logger      : ");
        builder.append(hasThisLogger);
        builder.append("\n");
        builder.append("Logger configuration : ");
        builder.append(configFile);
        if (this.appenders != null) {
            for (Appender appender : this.appenders) {
                builder.append("\n\n");
                builder.append("Appender             : ");
                builder.append(appender.getName());
                builder.append("\n");
                builder.append("             Handler : ");
                builder.append(this.getAppendersInfo(appender));
                builder.append("\n");
                builder.append("              Layout : ");
                builder.append(appender.getLayout());
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    private String getAppendersInfo(Appender appender) {
        StringBuilder builder = new StringBuilder();
        if (appender instanceof FileAppender) {
            FileAppender fileAppender = (FileAppender)appender;
            builder.append("FileAppender");
            builder.append("\n");
            builder.append("              Output : ");
            builder.append(fileAppender.getFileName());
        } else {
            builder.append(appender.getClass());
        }
        return builder.toString();
    }
}

