/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model.config;

import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Internationalization
extends GenericModel {
    private ResourceBundle bundle;
    protected static Logger logger = LoggerFactory.getLogger(Internationalization.class);

    public Internationalization(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public boolean isValid() {
        return this.bundle != null;
    }

    public String getLabel(Label label) {
        String value = null;
        if (this.bundle != null) {
            try {
                value = this.bundle.getString(label.propertiesKey);
            }
            catch (MissingResourceException e) {
                logger.warn("Missing entry in i18n configuration file (labels.properties) for label: " + String.valueOf((Object)label));
            }
        }
        if (value == null) {
            value = label.fallback;
        }
        return value;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public String getSampleLabels() {
        StringBuilder builder = new StringBuilder();
        if (this.bundle != null) {
            builder.append("File  : ");
            builder.append(this.getLabel(Label.FILE));
            builder.append("\n");
            builder.append("Exit  : ");
            builder.append(this.getLabel(Label.EXIT));
            builder.append("\n");
            builder.append("About : ");
            builder.append(this.getLabel(Label.ABOUT));
            builder.append("\n");
        } else {
            builder.append("NULL resource bundle");
        }
        return builder.toString();
    }
}

