/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model;

import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SerializableModel
extends GenericModel {
    protected static Logger logger = LoggerFactory.getLogger(SerializableModel.class);

    public SerializableModel() {
    }

    public SerializableModel(int id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public abstract String[] serialize();

    public String[] serializeHeader() {
        Object[] model = this.serialize();
        Object[] header = this.getHeader();
        if (model != null && header != null) {
            if (model.length == header.length) {
                return header;
            }
            Object message = "Model and header must have the same number of elements when serialized.\n";
            message = (String)message + "Model : " + Arrays.toString(model) + "\n";
            message = (String)message + "Header: " + Arrays.toString(header) + "\n";
            logger.error((String)message);
            throw new IllegalStateException((String)message);
        }
        return null;
    }

    protected abstract String[] getHeader();

    public static Object deserialize(Class<?> type, String[] stringArray) {
        Constructor<?> constructor = null;
        if (type == null) {
            logger.error("deserialize(array) - No model's class (type is null)");
            return null;
        }
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("deserialize(array) - Creating object: " + type.getName() + " with values " + Arrays.toString(stringArray));
        }
        try {
            Class[] signature = new Class[]{String[].class};
            constructor = type.getConstructor(signature);
        }
        catch (NoSuchMethodException e) {
            logger.error("deserialize(array) - Missing String[] based constructor in model: " + type.getName());
            return null;
        }
        catch (SecurityException e) {
            logger.error("deserialize(array) - NoSecurityException: " + e.getMessage());
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("deserialize(array) - Using constructor: " + String.valueOf(constructor) + " withvalues " + Arrays.toString(stringArray));
        }
        try {
            Object instance = constructor.newInstance(new Object[]{stringArray});
            if (debug) {
                logger.info("deserialize(array) - Created object: " + String.valueOf(instance) + " for class " + type.getName());
            }
            return instance;
        }
        catch (IllegalArgumentException e) {
            logger.error("deserialize(array) - IllegalArgumentException: " + e.getMessage());
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("deserialize(array) - Unknown error: " + e.getMessage());
            return null;
        }
        catch (InvocationTargetException e) {
            logger.error("deserialize(array) - InvocationTargetException for constructor " + String.valueOf(constructor) + " : " + String.valueOf(e.getCause()));
            logger.error("deserialize(array) - InvocationTargetException  stringArray = " + Arrays.toString(stringArray));
            return null;
        }
    }

    public static Object getInstance(Class<?> type) {
        Constructor<?> constructor = null;
        if (type == null) {
            logger.error("No model's class (type is null)");
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("deserialize() - Creating object: " + type.getName() + " using empty constructor");
        }
        try {
            constructor = type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.error("NoSuchMethodException | SecurityException: " + e.getMessage());
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("deserialize() - Using constructor: " + String.valueOf(constructor));
        }
        try {
            Object instance = constructor.newInstance(new Object[0]);
            if (logger.isTraceEnabled()) {
                logger.trace("deserialize() - Created object: " + String.valueOf(instance) + " for class " + type.getName());
            }
            return instance;
        }
        catch (IllegalArgumentException e) {
            logger.error("IllegalArgumentException: " + e.getMessage());
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("deserialize() - Unknown error: " + e.getMessage());
            return null;
        }
        catch (InvocationTargetException e) {
            logger.error("deserialize() - InvocationTargetException for constructor " + String.valueOf(constructor) + " : " + String.valueOf(e.getCause()));
            return null;
        }
    }

    public String getCSVRepresentation() {
        String[] values = this.serialize();
        String sep = "";
        StringBuilder builder = new StringBuilder();
        for (String string : values) {
            builder.append(sep);
            builder.append(string);
            if (sep.length() != 0) continue;
            sep = ";";
        }
        return builder.toString();
    }
}

