/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MessageType {
    WARNING("A soft error, which does not compromise the target entity", "warning", 2),
    ERROR("An hard error, which does compromise the target entity", "error", 1),
    CRITICAL("A critical error, which can never be ignored", "critical", 0),
    FATAL("A fatal error, which abruptly breaks the process", "fatal", 0),
    UNDEF("An unknow error, not well defined (wrong configuration)", "N/A", 0);

    public final String description;
    public final String name;
    public final int order;
    protected static Logger logger;

    private MessageType(String description, String name, int order) {
        this.description = description;
        this.name = name;
        this.order = order;
    }

    public static MessageType parseMessageType(String value) {
        for (MessageType note : MessageType.values()) {
            if (!value.equalsIgnoreCase(note.name)) continue;
            return note;
        }
        return UNDEF;
    }

    public boolean isUnexpected() {
        return this.order == 0;
    }

    public static List<MessageType> getReportMessageTypes(boolean sorted) {
        ArrayList<MessageType> list = new ArrayList<MessageType>();
        for (MessageType messageType2 : MessageType.values()) {
            if (messageType2.order <= 0) continue;
            list.add(messageType2);
        }
        if (sorted) {
            list.sort(Comparator.comparingInt(messageType -> messageType.order));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReportMessageTypes() - Returning: " + String.valueOf(list));
        }
        return list;
    }

    static {
        logger = LoggerFactory.getLogger(MessageType.class);
    }
}

