/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model;

import eu.europa.ec.jrc.qcs.dao.model.ForeignKey;
import eu.europa.ec.jrc.qcs.dao.model.GenericEntity;
import eu.europa.ec.jrc.qcs.dao.model.Message;
import eu.europa.ec.jrc.qcs.dao.model.MessageType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericModel
extends GenericEntity {
    protected int id;
    protected String name;
    protected String description;
    protected Map<String, ForeignKey> foreignId = new HashMap<String, ForeignKey>();
    protected boolean valid = true;
    protected boolean unreferred = false;
    protected HashMap<MessageType, Set<Message>> allMessages;
    public static final String NULL_STRING = "0";
    public static final String FK_MODEL_ID = "id";
    public static final String FK_DEFAULT = "default";
    public static final ForeignKey UNDEF_KEY = new ForeignKey("UNDEF", 0);
    public static final GenericModel UNDEF = new GenericModel(0, 0){
        {
            this.setValid(false);
            this.setName("GenericModel");
            this.setDescription("Empty reference for a \"null\" GenericModel instance");
        }
    };
    protected String className = this.getClass().getSimpleName().toLowerCase();
    protected FORMAT format = FORMAT.UNDEF;
    protected String formatString;
    protected static Logger logger = LoggerFactory.getLogger(GenericModel.class);

    public GenericModel() {
    }

    public GenericModel(int id) {
        this.setId(id);
    }

    public GenericModel(int id, String name) {
        this.setId(id);
        this.setName(name);
    }

    public GenericModel(int id, int foreignId) {
        this.setId(id);
        this.setForeignId(foreignId);
    }

    public GenericModel(int id, String name, int foreignId) {
        this.setId(id);
        this.setName(name);
        this.setForeignId(foreignId);
    }

    public GenericModel(int id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public void setId(String value) {
        try {
            int id = Integer.parseInt(value);
            this.setId(id);
        }
        catch (NumberFormatException e) {
            this.id = -2147483001;
            this.addErrorMessage("Wrong model ID for " + this.getModelLabel(value));
        }
    }

    public void setId(int id) {
        if (id < 0) {
            this.id = -2147483001;
            this.addErrorMessage("Negative model ID for " + this.getModelLabel(id));
        } else {
            this.id = id;
        }
    }

    public int getId() {
        return this.id;
    }

    public int getGenericId(String key) {
        if (FK_MODEL_ID.equals(key)) {
            return this.getId();
        }
        return this.getForeignId(key);
    }

    public void setForeignId(String key, String value) {
        try {
            int foreignId = Integer.parseInt(value);
            this.setForeignId(key, foreignId);
        }
        catch (NumberFormatException e) {
            this.setForeignKey(key, -2147483001);
            this.addErrorMessage("Wrong foreign ID for " + this.getModelLabel(value));
        }
    }

    public void setForeignId(String key, int id) {
        if (id < 0) {
            this.setForeignKey(key, -2147483001);
            this.addErrorMessage("Negative foreign ID for " + this.getModelLabel(id));
        } else {
            this.setForeignKey(key, id);
        }
    }

    public void setNullForeignId(String key) {
        this.setForeignKey(key, 0);
    }

    public int getForeignId(String key) {
        ForeignKey foreignKey = this.getForeignKey(key);
        if (foreignKey != UNDEF_KEY) {
            return foreignKey.getValue();
        }
        return -2147483001;
    }

    public boolean isNillableForeignKey(String key) {
        ForeignKey foreignKey = this.getForeignKey(key);
        if (foreignKey != UNDEF_KEY) {
            return foreignKey.isNillable();
        }
        return false;
    }

    public void setForeignKey(String key, int id) {
        ForeignKey foreignKey = this.getForeignKey(key);
        if (foreignKey == UNDEF_KEY) {
            foreignKey = new ForeignKey(key, id);
            this.foreignId.put(key, foreignKey);
        } else {
            foreignKey.setValue(id);
        }
    }

    public void setForeignKeyToNillable(String key) {
        ForeignKey foreignKey = this.getForeignKey(key);
        if (foreignKey == UNDEF_KEY) {
            foreignKey = new ForeignKey(key, true);
            this.foreignId.put(key, foreignKey);
        } else {
            foreignKey.setNillable(true);
        }
    }

    public ForeignKey getForeignKey(String key) {
        ForeignKey foreignKey = this.foreignId.get(key);
        if (foreignKey != null) {
            return foreignKey;
        }
        return UNDEF_KEY;
    }

    public int parseInteger(String label, String value) {
        try {
            int number = Integer.parseInt(value);
            return this.parseInteger(label, number);
        }
        catch (NumberFormatException e) {
            String message = "Wrong " + label + " value for " + this.getModelLabel(value);
            if (logger.isDebugEnabled()) {
                logger.debug("parseInteger() - " + message);
            }
            this.addErrorMessage(message);
            return -2147483001;
        }
    }

    public int parseInteger(String label, int value) {
        if (value >= 0) {
            return value;
        }
        this.addErrorMessage("Negative " + label + " value for " + this.getModelLabel(value));
        return -2147483001;
    }

    public boolean parseBoolean(String label, String value, boolean strict) {
        return this.parseBoolean(label, value, strict, !strict);
    }

    public boolean parseBoolean(String label, String value, boolean error, boolean warning) {
        if ("Y".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("N".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return false;
        }
        String message = "Wrong " + label + " flag for " + this.getModelLabel(value);
        if (logger.isDebugEnabled()) {
            logger.debug("parseBoolean() - " + message);
        }
        if (error) {
            this.addErrorMessage(message);
        } else if (warning) {
            this.addWarningMessage(message);
        }
        return false;
    }

    public String valueOf(boolean value) {
        if (value) {
            return "Y";
        }
        return "N";
    }

    public void setForeignId(String value) {
        this.setForeignId(FK_DEFAULT, value);
    }

    public void setForeignId(int id) {
        this.setForeignId(FK_DEFAULT, id);
    }

    public int getForeignId() {
        return this.getForeignId(FK_DEFAULT);
    }

    public void setNullForeignId() {
        this.setNullForeignId(FK_DEFAULT);
    }

    public boolean isNillableForeignKey() {
        return this.isNillableForeignKey(FK_DEFAULT);
    }

    public void addErrorMessage(String message) {
        LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
        messages.add(new Message(message));
        this.addMessages(MessageType.ERROR, messages);
    }

    public void addErrorMessages(Set<Message> messages) {
        this.addMessages(MessageType.ERROR, messages);
    }

    public void addErrorMessages(Set<Message> messages, String note) {
        if (messages == null) {
            return;
        }
        if (note != null) {
            for (Message message : messages) {
                message.setNote(note);
            }
        }
        this.addMessages(MessageType.ERROR, messages);
    }

    public void addWarningMessage(String message) {
        LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
        messages.add(new Message(message));
        this.addMessages(MessageType.WARNING, messages);
    }

    public void addWarningMessages(Set<Message> messages) {
        this.addMessages(MessageType.WARNING, messages);
    }

    public void addWarningMessages(Set<Message> messages, String note) {
        if (messages == null) {
            return;
        }
        if (note != null) {
            for (Message message : messages) {
                message.setNote(note);
            }
        }
        this.addMessages(MessageType.WARNING, messages);
    }

    public void addMessages(MessageType type, Set<Message> messages) {
        Set<Message> set;
        if (type == null) {
            return;
        }
        if (messages == null) {
            return;
        }
        if (this.allMessages == null) {
            this.allMessages = new HashMap();
        }
        if ((set = this.allMessages.get((Object)type)) == null) {
            set = new LinkedHashSet<Message>();
            this.allMessages.put(type, set);
        }
        set.addAll(messages);
        if (type == MessageType.ERROR || type == MessageType.FATAL) {
            this.setValid(false);
        }
    }

    public Set<Message> getMessages(MessageType type) {
        if (this.allMessages == null) {
            return null;
        }
        return this.allMessages.get((Object)type);
    }

    public void setMessages(MessageType type, Set<Message> messages) {
        if (this.allMessages == null) {
            this.allMessages = new HashMap();
        }
        this.allMessages.put(type, messages);
    }

    public Set<Message> getErrorMessages() {
        return this.getMessages(MessageType.ERROR);
    }

    public Set<Message> getWarningMessages() {
        return this.getMessages(MessageType.WARNING);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isUnreferred() {
        return this.unreferred;
    }

    public void setUnreferred(boolean orphan) {
        this.unreferred = orphan;
    }

    public FORMAT getFormat() {
        return this.format;
    }

    public void setFormat(FORMAT format) {
        this.format = format;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public String getIdAsString() {
        return this.getIntegerLabel(this.getId());
    }

    public String getForeignIdAsString() {
        return this.getIntegerLabel(this.getForeignId());
    }

    public String getModelName() {
        if (this.getName() != null && this.getName().length() > 0) {
            return this.getName();
        }
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            return this.getDescription();
        }
        return this.className;
    }

    public String getModelLabel() {
        return this.getModelLabel(null);
    }

    public String getModelLabel(int value) {
        return this.getModelLabel(Integer.toString(value));
    }

    public String getModelLabel(String value) {
        if (value == null) {
            return this.className + ": " + this.getModelName() + " [id=" + this.getIdAsString() + "]";
        }
        if (this.getId() == -2147483001) {
            return this.className + ": " + this.getModelName() + " [id=" + value + "]";
        }
        return this.className + ": " + this.getModelName() + " [id=" + this.getIdAsString() + "] - Original value: " + value;
    }

    public String getAllMessages() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getModelLabel(null));
        builder.append("\n");
        builder.append("- Errors:\n");
        if (this.getErrorMessages() != null) {
            for (Message message : this.getErrorMessages()) {
                if (message == null) continue;
                builder.append("\t");
                builder.append(message);
                builder.append("\n");
            }
        }
        builder.append("- Warnings:\n");
        if (this.getWarningMessages() != null) {
            for (Message message : this.getWarningMessages()) {
                if (message == null) continue;
                builder.append("\t");
                builder.append(message);
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public String getFirstErrorMessage() {
        Set<Message> messages = this.getErrorMessages();
        if (messages == null) {
            return "";
        }
        Message firstMessage = messages.iterator().next();
        return firstMessage.getDescription();
    }

    public static boolean isNullInteger(String value) {
        if (value == null) {
            return true;
        }
        if (value.trim().length() == 0) {
            return true;
        }
        return NULL_STRING.equals(value);
    }

    public static String getObjectIdentifier(Object object) {
        if (object == null) {
            return "NULL_OBJECT";
        }
        String[] fullName = object.toString().split("@");
        String hash = fullName[fullName.length - 1];
        String objectIdentifier = object.getClass().getSimpleName() + "@" + hash;
        return objectIdentifier;
    }

    public static <T extends GenericModel> boolean areSameList(List<T> list_1, List<T> list_2) {
        if (list_1 == null || list_2 == null) {
            return false;
        }
        if (list_1.size() != list_2.size()) {
            return false;
        }
        ArrayList<T> list_1_copy = new ArrayList<T>(list_1);
        ArrayList<T> list_2_copy = new ArrayList<T>(list_2);
        Collections.sort(list_1_copy, new GenericModelComparator());
        Collections.sort(list_2_copy, new GenericModelComparator());
        for (int i = 0; i < list_1.size(); ++i) {
            boolean sameElement;
            GenericModel element_1 = (GenericModel)list_1_copy.get(i);
            GenericModel element_2 = (GenericModel)list_2_copy.get(i);
            boolean bl = sameElement = element_1.getId() == element_2.getId();
            if (sameElement) continue;
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("areSameList() - Same list ? true");
        }
        return true;
    }

    public static enum FORMAT {
        UNDEF,
        PLAIN,
        FIXED;

    }

    static class GenericModelComparator<T extends GenericModel>
    implements Comparator<T> {
        GenericModelComparator() {
        }

        @Override
        public int compare(T object_1, T object_2) {
            int id_2;
            int id_1 = ((GenericModel)object_1).getId();
            if (id_1 < (id_2 = ((GenericModel)object_2).getId())) {
                return -1;
            }
            if (id_1 > id_2) {
                return 1;
            }
            return 0;
        }
    }
}

