/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericEntity {
    public static final int ZERO = 0;
    public static final int WRONG = -2147483001;
    public static final String EMPTY = "";
    protected static Logger logger = LoggerFactory.getLogger(GenericEntity.class);

    protected boolean isNumeric(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected int parseIntegerValue(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return -2147483001;
        }
    }

    protected double parseDoubleValue(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            return -2.147483001E9;
        }
    }

    public boolean parseBooleanValue(String value) {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isWrongID(int id) {
        if (0 == id) {
            return true;
        }
        return -2147483001 == id;
    }

    public String getIntegerLabel(int id) {
        if (id == 0) {
            return "ZERO";
        }
        if (id == -2147483001) {
            return "WRONG";
        }
        return Integer.toString(id);
    }

    public String getClassName() {
        String qualifiedName = this.getClass().getName();
        String[] tokens = qualifiedName.split("\\.");
        return tokens[tokens.length - 1];
    }

    public String getObjectIdentifier() {
        String[] fullName = super.toString().split("@");
        String hash = fullName[fullName.length - 1];
        String objectName = this.getClass().getSimpleName();
        String objectIdentifier = objectName + "@" + hash;
        return objectIdentifier;
    }
}

