/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.jpa;

import eu.europa.ec.jrc.qcs.dao.ValidationMessageDAO;
import eu.europa.ec.jrc.qcs.dao.file.AbstractDAO;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ValidationMessage;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationMessageRepository
extends AbstractDAO<ValidationMessage>
implements ValidationMessageDAO {
    private EntityManager entityManager;
    protected static Logger logger = LoggerFactory.getLogger(ValidationMessageRepository.class);

    public ValidationMessageRepository(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public List<ValidationMessage> getAll() {
        TypedQuery query = this.entityManager.createNamedQuery("validationMessage.getAll", eu.europa.ec.jrc.qcs.dao.dto.ValidationMessage.class);
        List listDTO = query.getResultList();
        ArrayList<ValidationMessage> list = new ArrayList<ValidationMessage>();
        for (eu.europa.ec.jrc.qcs.dao.dto.ValidationMessage dto : listDTO) {
            list.add(new ValidationMessage(dto));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("getAll() - Added ValidationMessageDTO " + dto.toPrettyString());
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getAll() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public ValidationMessage getByID(int recordID) {
        eu.europa.ec.jrc.qcs.dao.dto.ValidationMessage validationMessageDTO = (eu.europa.ec.jrc.qcs.dao.dto.ValidationMessage)this.entityManager.find(eu.europa.ec.jrc.qcs.dao.dto.ValidationMessage.class, (Object)recordID);
        if (logger.isTraceEnabled()) {
            logger.trace("getByID() - Fetched dto: " + String.valueOf(validationMessageDTO));
        }
        ValidationMessage validationMessage = new ValidationMessage(validationMessageDTO);
        if (logger.isTraceEnabled()) {
            logger.trace("getByID() - Created model: " + String.valueOf(validationMessage));
        }
        return validationMessage;
    }

    @Override
    public int getMaxID() {
        Query query = this.entityManager.createQuery("SELECT MAX(s.id) FROM validationMessage s");
        int maxRecordID = (Integer)query.getSingleResult();
        if (logger.isTraceEnabled()) {
            logger.trace("getMaxID() - Fetched max ID: " + maxRecordID);
        }
        return maxRecordID;
    }

    @Override
    public List<ValidationMessage> getByDescription(String text) {
        if (text == null || text.trim().length() == 0) {
            return ValidationMessage.EMPTY;
        }
        String description = text.toLowerCase().trim();
        if (logger.isTraceEnabled()) {
            logger.trace("getByDescription() - Searching description: " + description);
        }
        TypedQuery query = this.entityManager.createNamedQuery("validationMessage.getByDescription", eu.europa.ec.jrc.qcs.dao.dto.ValidationMessage.class);
        List listDTO = query.setParameter("description", (Object)description).getResultList();
        if (logger.isTraceEnabled()) {
            logger.trace("getByDescription() - Prepared query: " + String.valueOf(query));
        }
        ArrayList<ValidationMessage> list = new ArrayList<ValidationMessage>();
        for (eu.europa.ec.jrc.qcs.dao.dto.ValidationMessage dto : listDTO) {
            list.add(new ValidationMessage(dto));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("getByDescription() - Added ValidationMessageDTO " + dto.toPrettyString());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getByDescription() - Returning List<ValidationMessage>: " + String.valueOf(list));
        }
        return list;
    }
}

