/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.jpa;

import eu.europa.ec.jrc.qcs.dao.SchemaViewDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import eu.europa.ec.jrc.qcs.dao.jpa.SchemaRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.SchemaToFieldRepository;
import eu.europa.ec.jrc.qcs.dao.model.schema.Schema;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaToField;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaViewRepository
extends GenericHandler<SchemaView>
implements SchemaViewDAO {
    protected SchemaRepository schemaRepository;
    protected SchemaToFieldRepository schemaToFieldRepository;
    protected static Logger logger = LoggerFactory.getLogger(SchemaViewRepository.class);

    public SchemaViewRepository() {
        DAOFactory daoFactory = DAOFactory.getDAOFactory(1);
        GenericHandler<?> schemaHandler = daoFactory.getDAO(DAO.SCHEMA);
        GenericHandler<?> schemaToFieldHandler = daoFactory.getDAO(DAO.SCHEMA_TO_FIELD);
        if (logger.isTraceEnabled()) {
            logger.trace("SchemaViewRepository() - Fetched schemaHandler        : " + String.valueOf(schemaHandler));
            logger.trace("SchemaViewRepository() - Fetched schemaToFieldHandler : " + String.valueOf(schemaToFieldHandler));
        }
        if (schemaHandler instanceof SchemaRepository) {
            this.schemaRepository = (SchemaRepository)schemaHandler;
        } else if (logger.isWarnEnabled()) {
            logger.warn("SchemaViewRepository() - Wrong schemaHandler: " + String.valueOf(schemaHandler));
        }
        if (schemaToFieldHandler instanceof SchemaToFieldRepository) {
            this.schemaToFieldRepository = (SchemaToFieldRepository)schemaToFieldHandler;
        } else if (logger.isWarnEnabled()) {
            logger.warn("SchemaViewRepository() - Wrong schemaToFieldHandler: " + String.valueOf(schemaToFieldHandler));
        }
    }

    @Override
    public List<SchemaView> getAll() {
        List<Schema> schemas = this.schemaRepository.getAll();
        ArrayList<SchemaView> list = new ArrayList<SchemaView>();
        for (Schema schema : schemas) {
            int schemaId = schema.getId();
            List<SchemaToField> allSchemaToFields = this.schemaToFieldRepository.getBySchemaID(schemaId);
            SchemaView schemaView = new SchemaView(schema, allSchemaToFields);
            list.add(schemaView);
        }
        return list;
    }

    @Override
    public SchemaView getByID(int schemaId) {
        List<SchemaView> list = this.getAll();
        for (SchemaView schemaView : list) {
            Schema schema = schemaView.getSchema();
            if (schema.getId() != schemaId) continue;
            return schemaView;
        }
        return SchemaView.UNDEF;
    }

    @Override
    public int getMaxID() {
        return this.schemaRepository.getMaxID();
    }

    @Override
    public SchemaView getFullSchemaViewByID(int schemaID) {
        SchemaView schemaView = this.getByID(schemaID);
        Schema schema = schemaView.getSchema();
        int parentID = schema.getParentID();
        if (parentID <= 0) {
            return schemaView;
        }
        SchemaView parentSchemaView = this.getByID(parentID);
        List<SchemaToField> targetFields = schemaView.getSchemaToFields();
        List<SchemaToField> parentFields = parentSchemaView.getSchemaToFields();
        parentFields.addAll(targetFields);
        SchemaView fullSchemaView = new SchemaView(schema, parentFields);
        return fullSchemaView;
    }
}

