/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.jpa;

import eu.europa.ec.jrc.qcs.dao.SchemaToFieldDAO;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.Schema;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaToField;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaToFieldRepository
extends GenericHandler<SchemaToField>
implements SchemaToFieldDAO {
    private EntityManager entityManager;
    protected static Logger logger = LoggerFactory.getLogger(SchemaToFieldRepository.class);

    public SchemaToFieldRepository(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public List<SchemaToField> getAll() {
        TypedQuery query = this.entityManager.createNamedQuery("schemaToField.getAll", eu.europa.ec.jrc.qcs.dao.dto.SchemaToField.class);
        List listDTO = query.getResultList();
        ArrayList<SchemaToField> list = new ArrayList<SchemaToField>();
        for (eu.europa.ec.jrc.qcs.dao.dto.SchemaToField dto : listDTO) {
            list.add(new SchemaToField(dto));
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getAll() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public SchemaToField getByID(int recordID) {
        eu.europa.ec.jrc.qcs.dao.dto.SchemaToField fieldDTO = (eu.europa.ec.jrc.qcs.dao.dto.SchemaToField)this.entityManager.find(eu.europa.ec.jrc.qcs.dao.dto.SchemaToField.class, (Object)recordID);
        SchemaToField field = new SchemaToField(fieldDTO);
        if (logger.isTraceEnabled()) {
            logger.trace("getByID() - Fetched object: " + String.valueOf(field));
        }
        return field;
    }

    @Override
    public int getMaxID() {
        Query query = this.entityManager.createQuery("SELECT MAX(s.id) FROM schemaToField s");
        int maxRecordID = (Integer)query.getSingleResult();
        if (logger.isTraceEnabled()) {
            logger.trace("getMaxID() - Fetched max ID: " + maxRecordID);
        }
        return maxRecordID;
    }

    @Override
    public List<SchemaToField> getBySchemaID(int schemaID) {
        TypedQuery query = this.entityManager.createNamedQuery("schemaToField.getBySchemaID", eu.europa.ec.jrc.qcs.dao.dto.SchemaToField.class);
        List listDTO = query.setParameter("schemaID", (Object)schemaID).getResultList();
        ArrayList<SchemaToField> list = new ArrayList<SchemaToField>();
        for (eu.europa.ec.jrc.qcs.dao.dto.SchemaToField dto : listDTO) {
            if (logger.isTraceEnabled()) {
                logger.trace("getBySchemaID() - Added dto: " + String.valueOf(dto));
            }
            SchemaToField schemaToField = new SchemaToField(dto);
            list.add(schemaToField);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("getBySchemaID() - Added model: " + String.valueOf(schemaToField));
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getBySchemaID() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public List<SchemaToField> getByFieldID(int fieldID) {
        TypedQuery query = this.entityManager.createNamedQuery("schemaToField.getByFieldID", eu.europa.ec.jrc.qcs.dao.dto.SchemaToField.class);
        List listDTO = query.setParameter("fieldID", (Object)fieldID).getResultList();
        ArrayList<SchemaToField> list = new ArrayList<SchemaToField>();
        for (eu.europa.ec.jrc.qcs.dao.dto.SchemaToField dto : listDTO) {
            list.add(new SchemaToField(dto));
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("schemaToField.getByFieldID - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public List<Schema> getSchemasByFieldID(int fieldID) {
        TypedQuery query = this.entityManager.createNamedQuery("schemaToField.getByFieldID", eu.europa.ec.jrc.qcs.dao.dto.SchemaToField.class);
        List listDTO = query.setParameter("fieldID", (Object)fieldID).getResultList();
        ArrayList<Schema> list = new ArrayList<Schema>();
        for (eu.europa.ec.jrc.qcs.dao.dto.SchemaToField dto : listDTO) {
            list.add(new Schema(dto.getSchema()));
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("schemaToField.getByFieldID - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public List<Integer> getSchemasIDsByFieldID(int fieldID) {
        TypedQuery query = this.entityManager.createNamedQuery("schemaToField.getByFieldID", eu.europa.ec.jrc.qcs.dao.dto.SchemaToField.class);
        List listDTO = query.setParameter("fieldID", (Object)fieldID).getResultList();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (eu.europa.ec.jrc.qcs.dao.dto.SchemaToField dto : listDTO) {
            list.add(dto.getSchema().getId());
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("schemaToField.getByFieldID - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public List<Field> getFieldsBySchemaID(int schemaID) {
        TypedQuery query = this.entityManager.createNamedQuery("schemaToField.getBySchemaID", eu.europa.ec.jrc.qcs.dao.dto.SchemaToField.class);
        List listDTO = query.setParameter("schemaID", (Object)schemaID).getResultList();
        ArrayList<Field> list = new ArrayList<Field>();
        for (eu.europa.ec.jrc.qcs.dao.dto.SchemaToField dto : listDTO) {
            list.add(new Field(dto.getField()));
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("schemaToField.getBySchemaID - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public List<Integer> getFieldsIDsBySchemaID(int schemaID) {
        TypedQuery query = this.entityManager.createNamedQuery("schemaToField.getBySchemaID", eu.europa.ec.jrc.qcs.dao.dto.SchemaToField.class);
        List listDTO = query.setParameter("schemaID", (Object)schemaID).getResultList();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (eu.europa.ec.jrc.qcs.dao.dto.SchemaToField dto : listDTO) {
            list.add(dto.getField().getId());
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("schemaToField.getBySchemaID - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public int getMaxSchemaID() {
        Query query = this.entityManager.createQuery("SELECT MAX(s.id) FROM schemaToField s");
        int maxRecordID = (Integer)query.getSingleResult();
        if (logger.isTraceEnabled()) {
            logger.trace("getMaxID() - Fetched max ID: " + maxRecordID);
        }
        return maxRecordID;
    }
}

