/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.jpa;

import eu.europa.ec.jrc.qcs.dao.SchemaDAO;
import eu.europa.ec.jrc.qcs.dao.dto.Schema;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRepository
extends GenericHandler<eu.europa.ec.jrc.qcs.dao.model.schema.Schema>
implements SchemaDAO {
    private EntityManager entityManager;
    protected static Logger logger = LoggerFactory.getLogger(SchemaRepository.class);

    public SchemaRepository(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public List<eu.europa.ec.jrc.qcs.dao.model.schema.Schema> getAll() {
        TypedQuery query = this.entityManager.createNamedQuery("schema.getAll", Schema.class);
        List listDTO = query.getResultList();
        ArrayList<eu.europa.ec.jrc.qcs.dao.model.schema.Schema> list = new ArrayList<eu.europa.ec.jrc.qcs.dao.model.schema.Schema>();
        for (Schema dto : listDTO) {
            list.add(new eu.europa.ec.jrc.qcs.dao.model.schema.Schema(dto));
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getAll() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public eu.europa.ec.jrc.qcs.dao.model.schema.Schema getByID(int recordID) {
        Schema schemaDTO = (Schema)this.entityManager.find(Schema.class, (Object)recordID);
        eu.europa.ec.jrc.qcs.dao.model.schema.Schema schema = new eu.europa.ec.jrc.qcs.dao.model.schema.Schema(schemaDTO);
        if (logger.isTraceEnabled()) {
            logger.trace("getByID() - Fetched object: " + String.valueOf(schema));
        }
        return schema;
    }

    @Override
    public int getMaxID() {
        Query query = this.entityManager.createQuery("SELECT MAX(s.id) FROM schema s");
        int maxRecordID = (Integer)query.getSingleResult();
        if (logger.isTraceEnabled()) {
            logger.trace("getMaxID() - Fetched max ID: " + maxRecordID);
        }
        return maxRecordID;
    }

    @Override
    public List<eu.europa.ec.jrc.qcs.dao.model.schema.Schema> getByGroupID(int groupID) {
        TypedQuery query = this.entityManager.createNamedQuery("schema.getByGroupID", Schema.class);
        List listDTO = query.setParameter("groupID", (Object)groupID).getResultList();
        ArrayList<eu.europa.ec.jrc.qcs.dao.model.schema.Schema> list = new ArrayList<eu.europa.ec.jrc.qcs.dao.model.schema.Schema>();
        for (Schema dto : listDTO) {
            list.add(new eu.europa.ec.jrc.qcs.dao.model.schema.Schema(dto));
        }
        if (logger.isTraceEnabled()) {
            int size = list != null ? list.size() : 0;
            logger.trace("getByGroupID() - Fetched list with " + size + " elements");
        }
        return list;
    }
}

