/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.jpa;

import eu.europa.ec.jrc.qcs.dao.SchemaGroupDAO;
import eu.europa.ec.jrc.qcs.dao.dto.SchemaGroup;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import eu.europa.ec.jrc.qcs.dao.jpa.SchemaRepository;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemasGroup;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaGroupRepository
extends GenericHandler<SchemaGroup>
implements SchemaGroupDAO {
    private EntityManager entityManager;
    protected static Logger logger = LoggerFactory.getLogger(SchemaRepository.class);

    public SchemaGroupRepository(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public List<SchemasGroup> getAll() {
        TypedQuery query = this.entityManager.createNamedQuery("schemaGroup.getAll", SchemaGroup.class);
        List listDTO = query.getResultList();
        ArrayList<SchemasGroup> list = new ArrayList<SchemasGroup>();
        for (SchemaGroup dto : listDTO) {
            list.add(new SchemasGroup(dto));
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getAll() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public SchemasGroup getByID(int recordID) {
        SchemaGroup schemaDTO = (SchemaGroup)this.entityManager.find(SchemaGroup.class, (Object)recordID);
        SchemasGroup schemaGroup = new SchemasGroup(schemaDTO);
        if (logger.isTraceEnabled()) {
            logger.trace("getByID() - Fetched object: " + String.valueOf(schemaGroup));
        }
        return schemaGroup;
    }

    @Override
    public int getMaxID() {
        Query query = this.entityManager.createQuery("SELECT MAX(s.id) FROM schemaGroup s");
        int maxRecordID = (Integer)query.getSingleResult();
        if (logger.isTraceEnabled()) {
            logger.trace("getMaxID() - Fetched max ID: " + maxRecordID);
        }
        return maxRecordID;
    }

    @Override
    public SchemasGroup getByName(String name) {
        TypedQuery query = this.entityManager.createNamedQuery("schemaGroup.getByName", SchemaGroup.class);
        SchemaGroup schemaGroup = (SchemaGroup)query.setParameter("SchemaGroupName", (Object)name).getSingleResult();
        return new SchemasGroup(schemaGroup);
    }
}

