/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.jpa;

import eu.europa.ec.jrc.qcs.dao.ReferenceFieldDAO;
import eu.europa.ec.jrc.qcs.dao.dto.ReferenceField;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceFieldRepository
extends GenericHandler<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField>
implements ReferenceFieldDAO {
    private EntityManager entityManager;
    protected static Logger logger = LoggerFactory.getLogger(ReferenceFieldRepository.class);

    public ReferenceFieldRepository(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public List<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField> getAll() {
        TypedQuery query = this.entityManager.createNamedQuery("referenceField.getAll", ReferenceField.class);
        List listDTO = query.getResultList();
        ArrayList<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField> list = new ArrayList<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField>();
        for (ReferenceField dto : listDTO) {
            list.add(new eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField(dto));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("getAll() - Added referenceFieldDTO " + dto.toPrettyString());
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getAll() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField getByID(int recordID) {
        ReferenceField referenceFieldDTO = (ReferenceField)this.entityManager.find(ReferenceField.class, (Object)recordID);
        if (logger.isTraceEnabled()) {
            logger.trace("getByID() - Fetched dto: " + String.valueOf(referenceFieldDTO));
        }
        eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField referenceField = new eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField(referenceFieldDTO);
        if (logger.isTraceEnabled()) {
            logger.trace("getByID() - Created model: " + String.valueOf(referenceField));
        }
        return referenceField;
    }

    @Override
    public int getMaxID() {
        Query query = this.entityManager.createQuery("SELECT MAX(s.id) FROM referenceField s");
        int maxRecordID = (Integer)query.getSingleResult();
        if (logger.isTraceEnabled()) {
            logger.trace("getMaxID() - Fetched max ID: " + maxRecordID);
        }
        return maxRecordID;
    }

    @Override
    public List<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField> getByProtocolID(int protocolID) {
        TypedQuery query = this.entityManager.createNamedQuery("referenceField.getByProtocolID", ReferenceField.class);
        List listDTO = query.setParameter("protocolID", (Object)protocolID).getResultList();
        ArrayList<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField> list = new ArrayList<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField>();
        for (ReferenceField dto : listDTO) {
            list.add(new eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField(dto));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("getByProtocolID() - Added referenceFieldDTO " + dto.toPrettyString());
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getByProtocolID() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public List<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField> getByFieldID(int fieldID) {
        TypedQuery query = this.entityManager.createNamedQuery("referenceField.getByFieldID", ReferenceField.class);
        List listDTO = query.setParameter("fieldID", (Object)fieldID).getResultList();
        ArrayList<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField> list = new ArrayList<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField>();
        for (ReferenceField dto : listDTO) {
            list.add(new eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField(dto));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("getByFieldID() - Added referenceFieldDTO " + dto.toPrettyString());
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getByFieldID() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public List<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField> getByProtocolIDAndPosition(int protocolID, int position) {
        TypedQuery query = this.entityManager.createNamedQuery("referenceField.getByProtocolIDAndPosition", ReferenceField.class);
        List listDTO = query.setParameter("protocolID", (Object)protocolID).setParameter("position", (Object)position).getResultList();
        ArrayList<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField> list = new ArrayList<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField>();
        for (ReferenceField dto : listDTO) {
            list.add(new eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField(dto));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("getByProtocolIDAndPosition() - Added referenceFieldDTO " + dto.toPrettyString());
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getByProtocolIDAndPosition() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public List<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField> getSortedByProtocolID(int protocolID) {
        TypedQuery query = this.entityManager.createNamedQuery("referenceField.getSortedByProtocolID", ReferenceField.class);
        List listDTO = query.setParameter("protocolID", (Object)protocolID).getResultList();
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getSortedByProtocolID() - Fetched listDTO with " + size + " elements");
        }
        ArrayList<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField> referenceFields = new ArrayList<eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField>();
        for (ReferenceField dto : listDTO) {
            referenceFields.add(new eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField(dto));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("getSortedByProtocolID() - Added referenceFieldDTO " + dto.toPrettyString());
        }
        return referenceFields;
    }

    @Override
    public List<String> getNamesSortedByProtocolID(int protocolID) {
        TypedQuery query = this.entityManager.createNamedQuery("referenceField.getSortedNamesByProtocolID", String.class);
        List stringList = query.setParameter("protocolID", (Object)protocolID).getResultList();
        return stringList;
    }

    @Override
    public int getMaxPositionByProtocolID(int protocolID) {
        TypedQuery query = this.entityManager.createNamedQuery("referenceField.getMaxPositionByProtocolID", Integer.class);
        Integer integerResult = (Integer)query.setParameter("protocolID", (Object)protocolID).getSingleResult();
        return integerResult;
    }
}

