/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.jpa;

import eu.europa.ec.jrc.qcs.dao.RangeDAO;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import eu.europa.ec.jrc.qcs.dao.model.schema.Range;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeRepository
extends GenericHandler<Range>
implements RangeDAO {
    private EntityManager entityManager;
    protected static Logger logger = LoggerFactory.getLogger(RangeRepository.class);

    public RangeRepository(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public List<Range> getAll() {
        TypedQuery query = this.entityManager.createNamedQuery("range.getAll", eu.europa.ec.jrc.qcs.dao.dto.Range.class);
        List listDTO = query.getResultList();
        ArrayList<Range> list = new ArrayList<Range>();
        for (eu.europa.ec.jrc.qcs.dao.dto.Range dto : listDTO) {
            if (logger.isTraceEnabled()) {
                logger.trace("getAll() - Calling Range Costructor(dto) from getAll()");
            }
            list.add(new Range(dto));
        }
        if (logger.isTraceEnabled()) {
            int size;
            int n = size = listDTO != null ? listDTO.size() : 0;
            if (logger.isTraceEnabled()) {
                logger.trace("getAll() - Fetched list with " + size + " elements");
            }
        }
        return list;
    }

    @Override
    public Range getByID(int recordID) {
        eu.europa.ec.jrc.qcs.dao.dto.Range rangeDTO = (eu.europa.ec.jrc.qcs.dao.dto.Range)this.entityManager.find(eu.europa.ec.jrc.qcs.dao.dto.Range.class, (Object)recordID);
        if (logger.isTraceEnabled()) {
            logger.trace("getByID() - Calling Range Costructor(dto) from getByID()");
        }
        Range range = new Range(rangeDTO);
        if (logger.isTraceEnabled()) {
            logger.trace("getByID() - Fetched object: " + String.valueOf(range));
        }
        return range;
    }

    @Override
    public int getMaxID() {
        Query query = this.entityManager.createQuery("SELECT MAX(s.id) FROM range s");
        int maxRecordID = (Integer)query.getSingleResult();
        if (logger.isTraceEnabled()) {
            logger.trace("getMaxID() - Fetched max ID: " + maxRecordID);
        }
        return maxRecordID;
    }

    @Override
    public List<Range> getByRangeId(int rangeId) {
        ArrayList<Range> list = new ArrayList<Range>();
        Range range = this.getByID(rangeId);
        list = new ArrayList();
        list.add(range);
        if (logger.isTraceEnabled()) {
            int size;
            int n = size = list != null ? list.size() : 0;
            if (logger.isTraceEnabled()) {
                logger.trace("getByRangeId() - Fetched list with " + size + " elements");
            }
        }
        return list;
    }
}

