/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.jpa;

import eu.europa.ec.jrc.qcs.dao.RangeDataDAO;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import eu.europa.ec.jrc.qcs.dao.model.schema.RangeData;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeDataRepository
extends GenericHandler<RangeData>
implements RangeDataDAO {
    private EntityManager entityManager;
    protected static Logger logger = LoggerFactory.getLogger(RangeDataRepository.class);

    public RangeDataRepository(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public List<RangeData> getAll() {
        TypedQuery query = this.entityManager.createNamedQuery("rangeData.getAll", eu.europa.ec.jrc.qcs.dao.dto.RangeData.class);
        List listDTO = query.getResultList();
        ArrayList<RangeData> list = new ArrayList<RangeData>();
        for (eu.europa.ec.jrc.qcs.dao.dto.RangeData dto : listDTO) {
            list.add(new RangeData(dto));
        }
        if (logger.isTraceEnabled()) {
            int size;
            int n = size = listDTO != null ? listDTO.size() : 0;
            if (logger.isTraceEnabled()) {
                logger.trace("getAll() - Fetched list with " + size + " elements");
            }
        }
        return list;
    }

    @Override
    public RangeData getByID(int recordID) {
        eu.europa.ec.jrc.qcs.dao.dto.RangeData rangeDTO = (eu.europa.ec.jrc.qcs.dao.dto.RangeData)this.entityManager.find(eu.europa.ec.jrc.qcs.dao.dto.RangeData.class, (Object)recordID);
        RangeData rangeData = new RangeData(rangeDTO);
        if (logger.isTraceEnabled()) {
            logger.trace("getByID() - Fetched object: " + String.valueOf(rangeData));
        }
        return rangeData;
    }

    @Override
    public int getMaxID() {
        Query query = this.entityManager.createQuery("SELECT MAX(s.id) FROM rangeData s");
        int maxRecordID = (Integer)query.getSingleResult();
        if (logger.isTraceEnabled()) {
            logger.trace("getMaxID() - Fetched max ID: " + maxRecordID);
        }
        return maxRecordID;
    }

    @Override
    public List<RangeData> getDistinctById() {
        Query query = this.entityManager.createNativeQuery("SELECT * FROM rangeData group by range_id", eu.europa.ec.jrc.qcs.dao.dto.RangeData.class);
        List data = query.getResultList();
        ArrayList<RangeData> listDTO = new ArrayList<RangeData>();
        for (eu.europa.ec.jrc.qcs.dao.dto.RangeData dto : data) {
            listDTO.add(new RangeData(dto));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("getDistinctById() - Added DTO :" + dto.toPrettyString());
        }
        return listDTO;
    }

    @Override
    public List<RangeData> getRangeDataById(int rangeId) {
        TypedQuery query = this.entityManager.createNamedQuery("rangeData.getRangeDataById", eu.europa.ec.jrc.qcs.dao.dto.RangeData.class);
        List listDTO = query.setParameter("rangeId", (Object)rangeId).getResultList();
        ArrayList<RangeData> list = new ArrayList<RangeData>();
        for (eu.europa.ec.jrc.qcs.dao.dto.RangeData dto : listDTO) {
            list.add(new RangeData(dto));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("getRangeDataById() - Added DTO :" + dto.toPrettyString());
        }
        if (logger.isTraceEnabled()) {
            int size = list != null ? list.size() : 0;
            logger.trace("getRangeDataByID() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public List<String> geValuesById(int rangeId) {
        Query query = this.entityManager.createNativeQuery("SELECT value FROM rangeData where range_id= :rangeId");
        List listDTO = query.setParameter("rangeId", (Object)rangeId).getResultList();
        if (logger.isTraceEnabled()) {
            logger.trace("getRangeDataById() - Size: " + listDTO.size());
        }
        return listDTO;
    }

    @Override
    public int getMaxRangeId() {
        Query query = this.entityManager.createQuery("SELECT MAX(s.range.id) FROM rangeData s");
        int maxRecordID = (Integer)query.getSingleResult();
        if (logger.isTraceEnabled()) {
            logger.trace("getMaxRangeId() - Fetched max ID: " + maxRecordID);
        }
        return maxRecordID;
    }
}

