/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.jpa;

import eu.europa.ec.jrc.qcs.dao.ProtocolViewDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import eu.europa.ec.jrc.qcs.dao.jpa.ProtocolRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.ProtocolToRuleRepository;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolToRule;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolView;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultProtocolID;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolViewRepository
extends GenericHandler<ProtocolView>
implements ProtocolViewDAO {
    protected ProtocolRepository protocolRepository;
    protected ProtocolToRuleRepository protocolToRuleRepository;
    protected static Logger logger = LoggerFactory.getLogger(ProtocolViewRepository.class);

    public ProtocolViewRepository() {
        DAOFactory daoFactory = DAOFactory.getDAOFactory(1);
        GenericHandler<?> protocolHandler = daoFactory.getDAO(DAO.PROTOCOL);
        GenericHandler<?> protocolToRuledHandler = daoFactory.getDAO(DAO.PROTOCOL_TO_RULE);
        if (logger.isTraceEnabled()) {
            logger.trace("ProtocolViewRepository() - Fetched protocolHandler        : " + String.valueOf(protocolHandler));
            logger.trace("ProtocolViewRepository() - Fetched protocolToRuledHandler : " + String.valueOf(protocolToRuledHandler));
        }
        if (protocolHandler instanceof ProtocolRepository) {
            this.protocolRepository = (ProtocolRepository)protocolHandler;
        } else if (logger.isWarnEnabled()) {
            logger.warn("ProtocolViewRepository() - Wrong protocolHandler: " + String.valueOf(protocolHandler));
        }
        if (protocolToRuledHandler instanceof ProtocolToRuleRepository) {
            this.protocolToRuleRepository = (ProtocolToRuleRepository)protocolToRuledHandler;
        } else if (logger.isWarnEnabled()) {
            logger.warn("ProtocolViewRepository() - Wrong protocolToRuledHandler: " + String.valueOf(protocolToRuledHandler));
        }
    }

    @Override
    public List<ProtocolView> getAll() {
        List<Protocol> protocols = this.protocolRepository.getAll();
        if (logger.isDebugEnabled()) {
            logger.debug("getAll() - Loaded protocols: " + String.valueOf(protocols));
        }
        ArrayList<ProtocolView> list = new ArrayList<ProtocolView>();
        for (Protocol protocol : protocols) {
            int protocolId = protocol.getId();
            List<ProtocolToRule> allProtocolToRules = this.protocolToRuleRepository.getByProtocolID(protocolId);
            ProtocolView protocolView = new ProtocolView(protocol, allProtocolToRules);
            list.add(protocolView);
        }
        return list;
    }

    @Override
    public ProtocolView getByID(int protocolID) {
        List<ProtocolView> list = this.getAll();
        for (ProtocolView protocolView : list) {
            Protocol protocol = protocolView.getProtocol();
            if (protocol.getId() != protocolID) continue;
            return protocolView;
        }
        return ProtocolView.UNDEF;
    }

    @Override
    public int getMaxID() {
        return this.protocolRepository.getMaxID();
    }

    @Override
    public ProtocolView getOrderedByLevel(int protocolID) {
        ProtocolView protocolView = this.getByID(protocolID);
        if (logger.isDebugEnabled()) {
            logger.debug("getOrderedByLevel() - Loaded ProtocolView : " + String.valueOf(protocolView) + " (" + protocolID + ")");
        }
        Set<Integer> levels = protocolView.getLevels();
        ArrayList<ProtocolToRule> orderedProtocolToRules = new ArrayList<ProtocolToRule>();
        for (int level : levels) {
            List<ProtocolToRule> protocolToRules = protocolView.getProtocolToRuleByLevel(level);
            orderedProtocolToRules.addAll(protocolToRules);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getOrderedByLevel() - Creating protocol view for protocolID: " + protocolID);
        }
        Protocol protocol = protocolView.getProtocol();
        ProtocolView orderedProtocolView = new ProtocolView(protocol, orderedProtocolToRules);
        return orderedProtocolView;
    }

    @Override
    public ProtocolView getOrderedByPriority(int protocolID) {
        ProtocolView protocolView = this.getByID(protocolID);
        if (logger.isDebugEnabled()) {
            logger.debug("getOrderedByPriority() - Loaded ProtocolView : " + String.valueOf(protocolView) + " (" + protocolID + ")");
        }
        Set<Integer> priorities = protocolView.getPriorities();
        ArrayList<ProtocolToRule> orderedProtocolToRules = new ArrayList<ProtocolToRule>();
        for (int priority : priorities) {
            List<ProtocolToRule> protocolToRules = protocolView.getProtocolToRuleByPrioriry(priority);
            orderedProtocolToRules.addAll(protocolToRules);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getOrderedByPriority() - Creating protocol view for protocolID: " + protocolID);
        }
        Protocol protocol = protocolView.getProtocol();
        ProtocolView orderedProtocolView = new ProtocolView(protocol, orderedProtocolToRules);
        return orderedProtocolView;
    }

    @Override
    public ProtocolView getFullProtocolViewByID(int protocolID) {
        ProtocolView protocolView = this.getByID(protocolID);
        Protocol protocol = protocolView.getProtocol();
        int parentID = protocol.getParentID();
        if (parentID <= 0) {
            return this.getOrderedByPriority(protocolID);
        }
        ProtocolView parentProtocolView = this.getByID(parentID);
        HashSet<Integer> allPriorities = new HashSet<Integer>();
        Set<Integer> targetPriorities = protocolView.getPriorities();
        Set<Integer> parentPriorities = parentProtocolView.getPriorities();
        allPriorities.addAll(parentPriorities);
        allPriorities.addAll(targetPriorities);
        ArrayList<ProtocolToRule> orderedProtocolToRules = new ArrayList<ProtocolToRule>();
        Iterator iterator = allPriorities.iterator();
        while (iterator.hasNext()) {
            int priority = (Integer)iterator.next();
            List<ProtocolToRule> targetRules = protocolView.getProtocolToRuleByPrioriry(priority);
            List<ProtocolToRule> parentRules = parentProtocolView.getProtocolToRuleByPrioriry(priority);
            orderedProtocolToRules.addAll(parentRules);
            orderedProtocolToRules.addAll(targetRules);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getFullProtocolViewByID() - Parent rules    : " + parentProtocolView.getNumberOfRules());
            logger.debug("getFullProtocolViewByID() - Target rules    : " + protocolView.getNumberOfRules());
            logger.debug("getFullProtocolViewByID() - Full view rules : " + orderedProtocolToRules.size());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getFullProtocolViewByID() - Creating protocol view");
        }
        ProtocolView fullProtocolView = new ProtocolView(protocol, orderedProtocolToRules);
        return fullProtocolView;
    }

    @Override
    public ProtocolView getDefaultProtocolView() {
        Protocol defaultProtocol = new Protocol("11", "Incidence (default)", "Default Incidence protocol 2022", "1", null, "11");
        ArrayList<ProtocolToRule> defaultRules = new ArrayList<ProtocolToRule>();
        defaultRules.add(new ProtocolToRule(1, DefaultProtocolID.INCIDENCE_2020.getID(), "1", "true", DefaultRuleID.FILE_SIZE.getID()));
        defaultRules.add(new ProtocolToRule(2, DefaultProtocolID.INCIDENCE_2020.getID(), "2", "true", DefaultRuleID.RECORD_FORMAT.getID()));
        defaultRules.add(new ProtocolToRule(3, DefaultProtocolID.INCIDENCE_2020.getID(), "3", "false", DefaultRuleID.FIELD_DATA_TYPE.getID()));
        defaultRules.add(new ProtocolToRule(4, DefaultProtocolID.INCIDENCE_2020.getID(), "3", "false", DefaultRuleID.FIELD_MANDATORY.getID()));
        defaultRules.add(new ProtocolToRule(5, DefaultProtocolID.INCIDENCE_2020.getID(), "3", "false", DefaultRuleID.FIELD_MAX_SIZE.getID()));
        defaultRules.add(new ProtocolToRule(6, DefaultProtocolID.INCIDENCE_2020.getID(), "4", "false", DefaultRuleID.FIELD_RANGE.getID()));
        ProtocolView defaultProtocolView = new ProtocolView(defaultProtocol, defaultRules);
        if (logger.isInfoEnabled()) {
            logger.info("getFullProtocolViewByID() - Created default protocol view:" + String.valueOf(defaultProtocolView));
        }
        return defaultProtocolView;
    }
}

