/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.jpa;

import eu.europa.ec.jrc.qcs.dao.ProtocolToRuleDAO;
import eu.europa.ec.jrc.qcs.dao.dto.Protocol;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolToRule;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolToRuleRepository
extends GenericHandler<ProtocolToRule>
implements ProtocolToRuleDAO {
    private EntityManager entityManager;
    protected static Logger logger = LoggerFactory.getLogger(ProtocolToRuleRepository.class);

    public ProtocolToRuleRepository(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public boolean save(ProtocolToRule record) {
        return false;
    }

    @Override
    public int save(List<ProtocolToRule> records) {
        return 0;
    }

    @Override
    public int updateAll(List<ProtocolToRule> records) {
        return 0;
    }

    @Override
    public List<ProtocolToRule> getAll() {
        TypedQuery query = this.entityManager.createNamedQuery("protocolToRule.getAll", eu.europa.ec.jrc.qcs.dao.dto.ProtocolToRule.class);
        List listDTO = query.getResultList();
        ArrayList<ProtocolToRule> list = new ArrayList<ProtocolToRule>();
        for (eu.europa.ec.jrc.qcs.dao.dto.ProtocolToRule dto : listDTO) {
            if (logger.isTraceEnabled()) {
                logger.trace("getAll() - Adding DTO: " + String.valueOf(dto));
            }
            list.add(new ProtocolToRule(dto));
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getAll() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public ProtocolToRule getByID(int recordID) {
        eu.europa.ec.jrc.qcs.dao.dto.ProtocolToRule protocolToRuleDTO = (eu.europa.ec.jrc.qcs.dao.dto.ProtocolToRule)this.entityManager.find(eu.europa.ec.jrc.qcs.dao.dto.ProtocolToRule.class, (Object)recordID);
        if (logger.isTraceEnabled()) {
            logger.trace("getByID() - Adding ProtocolToRule: " + String.valueOf(protocolToRuleDTO));
        }
        ProtocolToRule protocolToRule = new ProtocolToRule(protocolToRuleDTO);
        if (logger.isTraceEnabled()) {
            logger.trace("getByID() - Fetched object: " + String.valueOf(protocolToRule));
        }
        return protocolToRule;
    }

    @Override
    public int getMaxID() {
        Query query = this.entityManager.createQuery("SELECT MAX(s.id) FROM protocolToRule s");
        int maxRecordID = (Integer)query.getSingleResult();
        if (logger.isTraceEnabled()) {
            logger.trace("getMaxID() - Fetched max ID: " + maxRecordID);
        }
        return maxRecordID;
    }

    @Override
    public List<ProtocolToRule> getByProtocolID(int protocolID) {
        TypedQuery query = this.entityManager.createNamedQuery("protocolToRule.getByProtocolID", eu.europa.ec.jrc.qcs.dao.dto.ProtocolToRule.class);
        List listDTO = query.setParameter("protocolID", (Object)protocolID).getResultList();
        ArrayList<ProtocolToRule> list = new ArrayList<ProtocolToRule>();
        for (eu.europa.ec.jrc.qcs.dao.dto.ProtocolToRule dto : listDTO) {
            list.add(new ProtocolToRule(dto));
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getAll() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public List<ProtocolToRule> getByRuleID(int ruleID) {
        TypedQuery query = this.entityManager.createNamedQuery("protocolToRule.getByRuleID", eu.europa.ec.jrc.qcs.dao.dto.ProtocolToRule.class);
        List listDTO = query.setParameter("ruleID", (Object)ruleID).getResultList();
        ArrayList<ProtocolToRule> list = new ArrayList<ProtocolToRule>();
        for (eu.europa.ec.jrc.qcs.dao.dto.ProtocolToRule dto : listDTO) {
            if (logger.isTraceEnabled()) {
                logger.trace("getByRuleID() - Adding DTO: " + String.valueOf(dto));
            }
            list.add(new ProtocolToRule(dto));
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getAll() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public List<eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol> getProtocolsByRuleID(int ruleID) {
        TypedQuery query = this.entityManager.createNamedQuery("protocolToRule.getProtocolsByRuleID", Protocol.class);
        List listDTO = query.setParameter("ruleID", (Object)ruleID).getResultList();
        ArrayList<eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol> list = new ArrayList<eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol>();
        for (Protocol dto : listDTO) {
            list.add(new eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol(dto));
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getProtocolsByRuleID() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public List<Integer> getProtocolsIDsByRuleID(int ruleID) {
        TypedQuery query = this.entityManager.createNamedQuery("protocolToRule.getProtocolsIDsByRuleID", Integer.class);
        List list = query.setParameter("ruleID", (Object)ruleID).getResultList();
        return list;
    }

    @Override
    public List<RuleDefinition> getRulesByProtocolID(int protocolID) {
        TypedQuery query = this.entityManager.createNamedQuery("protocolToRule.getProtocolsByRuleID", eu.europa.ec.jrc.qcs.dao.dto.RuleDefinition.class);
        List listDTO = query.setParameter("protocolID", (Object)protocolID).getResultList();
        ArrayList<RuleDefinition> list = new ArrayList<RuleDefinition>();
        for (eu.europa.ec.jrc.qcs.dao.dto.RuleDefinition dto : listDTO) {
            list.add(new RuleDefinition(dto));
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO != null ? listDTO.size() : 0;
            logger.trace("getProtocolsByRuleID() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public List<Integer> getRulesIDsByProtocolID(int protocolID) {
        TypedQuery query = this.entityManager.createNamedQuery("protocolToRule.getRulesIDsByProtocolID", Integer.class);
        List list = query.setParameter("protocolID", (Object)protocolID).getResultList();
        return list;
    }
}

