/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.jpa;

import eu.europa.ec.jrc.qcs.dao.MetadataDAO;
import eu.europa.ec.jrc.qcs.dao.dto.Metadata;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import eu.europa.ec.jrc.qcs.dao.model.config.MetadataDB;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataRepository
extends GenericHandler<MetadataDB>
implements MetadataDAO {
    private final EntityManager entityManager;
    protected static Logger logger = LoggerFactory.getLogger(MetadataRepository.class);
    public static final String DB_VERSION_KEY = "db_version";

    public MetadataRepository(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public List<MetadataDB> getAll() {
        TypedQuery query = this.entityManager.createNamedQuery("metadata.getAll", Metadata.class);
        List listEntity = query.getResultList();
        ArrayList<MetadataDB> listMetadata = new ArrayList<MetadataDB>();
        for (Metadata entity : listEntity) {
            listMetadata.add(new MetadataDB(entity));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("getAll() - Added metadata " + entity.toPrettyString());
        }
        if (logger.isTraceEnabled()) {
            int size = listEntity.size();
            logger.trace("getAll() - Fetched listMetadata with {} elements", (Object)size);
        }
        return listMetadata;
    }

    @Override
    public MetadataDB getByID(int recordID) {
        if (logger.isWarnEnabled()) {
            logger.warn("getByID(int) - Not supported for Metadata (String keys used). Returning null.");
        }
        return null;
    }

    @Override
    public int getMaxID() {
        return 0;
    }

    @Override
    public String getValue(String key) {
        TypedQuery query = this.entityManager.createNamedQuery("metadata.getByKey", Metadata.class);
        query.setParameter("key", (Object)key);
        Metadata metadata = null;
        try {
            metadata = (Metadata)query.getSingleResult();
        }
        catch (NoResultException e) {
            if (logger.isTraceEnabled()) {
                logger.trace("getValue() - No metadata found for key: {}", (Object)key);
            }
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getValue() - Fetched value for key {}: {}", (Object)key, (Object)metadata.getValue());
        }
        return metadata != null ? metadata.getValue() : null;
    }
}

