/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.jpa;

import eu.europa.ec.jrc.qcs.dao.FieldDAO;
import eu.europa.ec.jrc.qcs.dao.dto.Field;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRepository
extends GenericHandler<eu.europa.ec.jrc.qcs.dao.model.schema.Field>
implements FieldDAO {
    private EntityManager entityManager;
    protected static Logger logger = LoggerFactory.getLogger(FieldRepository.class);

    public FieldRepository(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public List<eu.europa.ec.jrc.qcs.dao.model.schema.Field> getAll() {
        TypedQuery query = this.entityManager.createNamedQuery("field.getAll", Field.class);
        List listDTO = query.getResultList();
        ArrayList<eu.europa.ec.jrc.qcs.dao.model.schema.Field> list = new ArrayList<eu.europa.ec.jrc.qcs.dao.model.schema.Field>();
        for (Field dto : listDTO) {
            list.add(new eu.europa.ec.jrc.qcs.dao.model.schema.Field(dto));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("getAll() - Added fieldDTO " + dto.toPrettyString());
        }
        if (logger.isTraceEnabled()) {
            int size = listDTO.size();
            logger.trace("getAll() - Fetched list with " + size + " elements");
        }
        return list;
    }

    @Override
    public eu.europa.ec.jrc.qcs.dao.model.schema.Field getByID(int recordID) {
        Field fieldDTO = (Field)this.entityManager.find(Field.class, (Object)recordID);
        if (logger.isTraceEnabled()) {
            logger.trace("getByID() - Fetched dto: " + String.valueOf(fieldDTO));
        }
        eu.europa.ec.jrc.qcs.dao.model.schema.Field field = new eu.europa.ec.jrc.qcs.dao.model.schema.Field(fieldDTO);
        if (logger.isTraceEnabled()) {
            logger.trace("getByID() - Created model: " + String.valueOf(field));
        }
        return field;
    }

    @Override
    public int getMaxID() {
        Query query = this.entityManager.createQuery("SELECT MAX(s.id) FROM field s");
        int maxRecordID = (Integer)query.getSingleResult();
        if (logger.isTraceEnabled()) {
            logger.trace("getMaxID() - Fetched max ID: " + maxRecordID);
        }
        return maxRecordID;
    }
}

