/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.file.handler;

import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.BufferedFileHandler;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesHandler<T>
extends BufferedFileHandler<T> {
    protected static Logger logger = LoggerFactory.getLogger(PropertiesHandler.class);

    public PropertiesHandler() {
    }

    public PropertiesHandler(FileConnection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Properties getProperties(boolean mandatory) {
        String fileName = this.connection.getFileName();
        if (logger.isDebugEnabled()) {
            logger.debug("getProperties() - Loading file name: " + fileName);
        }
        this.connection.openConnection();
        InputStream inputStream = this.connection.getInputStream();
        if (logger.isDebugEnabled()) {
            logger.debug("getProperties - Using input stream: " + String.valueOf(inputStream));
        }
        if (inputStream == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("getProperties() - Found null input stream");
            }
            if (!mandatory) return null;
            this.notifyFatalError("Failed to load properties file: null input stream");
        } else if (logger.isTraceEnabled()) {
            logger.trace("getProperties() - Loading properties file: " + fileName + " [" + String.valueOf(inputStream) + "]");
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            return properties;
        }
        catch (IOException e) {
            this.notifyFatalError("I/O error when loading properties file:" + fileName + " [" + String.valueOf(inputStream) + "]");
            return properties;
        }
        catch (Exception e) {
            this.notifyFatalError("Failed to load properties file:" + fileName + " [" + String.valueOf(inputStream) + "]");
            return properties;
        }
        finally {
            this.connection.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveProperties(Properties properties) {
        if (logger.isDebugEnabled()) {
            logger.debug("saveProperties() - Saving properties file: " + String.valueOf(properties));
        }
        boolean saved = false;
        String fileName = this.connection.getFileName();
        if (logger.isDebugEnabled()) {
            logger.debug("saveProperties() - Saving to file: " + fileName);
        }
        this.connection.openConnection();
        String absolutePath = this.connection.getAbsolutePath();
        if (logger.isDebugEnabled()) {
            logger.debug("saveProperties() - Saving to file absolute path : " + absolutePath);
        }
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(absolutePath);
            properties.store(output, null);
            saved = true;
        }
        catch (IOException io) {
            saved = false;
            this.notifyFatalError("saveProperties() - Error saving properties file: " + io.getMessage());
        }
        finally {
            try {
                ((OutputStream)output).close();
            }
            catch (Exception e) {
                saved = false;
                this.notifyFatalError("saveProperties() - Error closing properties file: " + e.getMessage());
            }
        }
        return saved;
    }
}

