/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.file.handler;

import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.BufferedFileHandler;
import eu.europa.ec.jrc.qcs.dao.model.config.LoggerConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.spi.LoggerContextFactory;

public class LoggerConfigurationHandler
extends BufferedFileHandler<LoggerConfiguration> {
    protected LoggerConfiguration configuration;
    protected static final String APPENDER = "FILE";
    public static final boolean STDOUT = false;
    protected static final String SDOUT_PREFIX = ">>>>>>>> LoggerConfigurationHandler - ";

    public LoggerConfigurationHandler() {
        this.setCached(true);
    }

    public LoggerConfigurationHandler(FileConnection connection) {
        super(connection);
        this.setCached(true);
    }

    public LoggerConfiguration getConfiguration() {
        if (this.cached && this.configuration != null) {
            return this.configuration;
        }
        LoggerConfiguration configurationDTO = this.getLoggerConfiguration();
        if (configurationDTO.matchesAppenders()) {
            configurationDTO.setExternal(true);
            if (logger.isInfoEnabled()) {
                logger.info("getConfiguration() - Logger configuration loaded from Java classpath (external configuration)");
            }
            return configurationDTO;
        }
        System.out.println("WARN: getConfiguration() - Logger configuration not found in the Java classpath: looking for the internal configuration");
        String resourcePath = this.connection.getRelativePath() + File.separator + this.connection.getFileName();
        Configurator.initialize(null, (String)resourcePath);
        configurationDTO = this.getLoggerConfiguration();
        if (configurationDTO.matchesAppenders()) {
            configurationDTO.setExternal(false);
            if (logger.isInfoEnabled()) {
                logger.info("getConfiguration() - Logger external configuration not found");
                logger.info("getConfiguration() - Logger configuration loaded from internal file: " + resourcePath);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Logger info:\n" + configurationDTO.getLoggersInfo());
            }
        } else {
            configurationDTO.setMatchesAppenders(false);
            String message = "getConfiguration() - Logger configuration not found: using default setting";
            logger.error(message);
            System.err.println(message);
        }
        if (this.cached) {
            this.configuration = configurationDTO;
        }
        return configurationDTO;
    }

    private LoggerConfiguration getLoggerConfiguration() {
        if (logger.isDebugEnabled()) {
            logger.debug("getConfigurationDTO() - Testing logInfo BEFORE loading configuration");
        }
        List<LoggerContext> loggerContexts = this.getLoggerContexts();
        LoggerConfiguration loggerConfiguration = new LoggerConfiguration(loggerContexts);
        loggerConfiguration.setAppenders(this.getAllAppenders());
        loggerConfiguration.setMatchesAppenders(false);
        for (Appender appender : loggerConfiguration.getAppenders()) {
            if (!APPENDER.equalsIgnoreCase(appender.getName())) continue;
            loggerConfiguration.setMatchesAppenders(true);
            break;
        }
        for (Appender appender : loggerConfiguration.getAppenders()) {
            if (loggerConfiguration.matchesAppenders()) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("getConfigurationDTO() - Logger appender (project): " + appender.getName());
                continue;
            }
            System.out.println("WARN: getConfigurationDTO() - Using Logger appender (automatic) : " + appender.getName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getConfigurationDTO() - Testing logInfo AFTER loading configuration");
        }
        return loggerConfiguration;
    }

    private List<Appender> getAllAppenders() {
        ArrayList<Appender> list = new ArrayList<Appender>();
        for (LoggerContext ctx : this.getLoggerContexts()) {
            for (Appender appender : ctx.getConfiguration().getAppenders().values()) {
                list.add(appender);
            }
        }
        return list;
    }

    private List<LoggerContext> getLoggerContexts() {
        LoggerContextFactory factory = LogManager.getFactory();
        ContextSelector selector = ((Log4jContextFactory)factory).getSelector();
        return selector.getLoggerContexts();
    }

    protected List<LoggerContext> forceConfigLocation(int method) {
        method = 1;
        ArrayList<Object> loggerContexts = new ArrayList<LoggerContext>();
        ConfigurationSource source = null;
        String log4jConfigFile = "C:\\Users\\adriste\\Home\\workspace\\qcs-2.0\\target\\classes\\configuration\\my-log4j2.xml";
        switch (method) {
            case 1: {
                LoggerContext hardCodedcontext = (LoggerContext)LogManager.getContext((boolean)false);
                File file = new File("./configuration/my-log4j2.xml");
                hardCodedcontext.setConfigLocation(file.toURI());
                loggerContexts.add(hardCodedcontext);
                break;
            }
            case 2: {
                try {
                    source = new ConfigurationSource((InputStream)new FileInputStream(log4jConfigFile));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 3: {
                LoggerContext hardCodedcontext = Configurator.initialize(null, source);
                loggerContexts = new ArrayList();
                loggerContexts.add(hardCodedcontext);
            }
        }
        return loggerContexts;
    }

    protected void printLoggerContextInfo(List<LoggerContext> loggerContexts) {
        LoggerContext firstLoggerContext = null;
        if (loggerContexts != null && !loggerContexts.isEmpty()) {
            firstLoggerContext = loggerContexts.get(0);
            System.out.println(">>>>>>>> LoggerConfigurationHandler - printLoggerContextInfo() - Number of logger contexts : " + loggerContexts.size());
            System.out.println(">>>>>>>> LoggerConfigurationHandler - printLoggerContextInfo() - First logger context      : " + String.valueOf(firstLoggerContext));
        } else {
            System.out.println(">>>>>>>> LoggerConfigurationHandler - printLoggerContextInfo() - ERROR: no LoggerContext in classpath");
        }
        if (firstLoggerContext != null) {
            System.out.println(">>>>>>>> LoggerConfigurationHandler - printLoggerContextInfo() - Config location           : " + String.valueOf(firstLoggerContext.getConfigLocation()));
        } else {
            System.out.println(">>>>>>>> LoggerConfigurationHandler - printLoggerContextInfo() - Config location           : N/A (LoggerContext is null)");
        }
        LoggerConfiguration loggerConfiguration = new LoggerConfiguration(loggerContexts);
        System.out.println(">>>>>>>> LoggerConfigurationHandler - printLoggerContextInfo() - Logger configuration      : " + String.valueOf(loggerConfiguration));
    }
}

