/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.file.handler;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFile {
    protected File file;
    protected String fileName;
    protected String absolutePath;
    protected String relativePath;
    protected long lines;
    protected String description;
    protected boolean readAccess = true;
    protected boolean writeAccess = false;
    protected static Logger logger = LoggerFactory.getLogger(LocalFile.class);

    public LocalFile(LocalFile file) {
        this.fileName = file.getFileName();
        this.absolutePath = file.getAbsolutePath();
        this.relativePath = file.getRelativePath();
    }

    public LocalFile() {
    }

    public LocalFile(File file) {
        this.setFile(file);
    }

    public LocalFile(String absolutePath) {
        this.absolutePath = absolutePath;
        this.fileName = this.getNameByPath();
    }

    public LocalFile(String fileName, String relativePath) {
        this.fileName = fileName;
        this.relativePath = relativePath;
    }

    public LocalFile(String fileName, String absolutePath, String relativePath) {
        this.fileName = fileName;
        this.absolutePath = absolutePath;
        this.relativePath = relativePath;
    }

    public LocalFile(String fileName, String absolutePath, String relativePath, String description) {
        this.fileName = fileName;
        this.absolutePath = absolutePath;
        this.relativePath = relativePath;
        this.description = description;
    }

    public void setFile(File file) {
        this.file = file;
        this.fileName = file.getName();
        this.absolutePath = file.getAbsolutePath();
    }

    public File getFile() {
        if (this.absolutePath != null) {
            return new File(this.absolutePath);
        }
        logger.error("Creating File object via relativePath: placeholder");
        return null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String path) {
        this.absolutePath = path;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public long getLines() {
        return this.lines;
    }

    public void setLines(long lines) {
        this.lines = lines;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean hasReadAccess() {
        return this.readAccess;
    }

    public void setReadAccess(boolean readAccess) {
        this.readAccess = readAccess;
    }

    public boolean hasWriteAccess() {
        return this.writeAccess;
    }

    public void setWriteAccess(boolean writeAccess) {
        this.writeAccess = writeAccess;
    }

    protected String getNameByPath() {
        String[] tokens = this.absolutePath.split("\\\\");
        if (logger.isDebugEnabled()) {
            logger.debug("Tokenizing path: " + this.absolutePath);
        }
        if (tokens.length == 1) {
            tokens = this.absolutePath.split("/");
            if (logger.isDebugEnabled()) {
                logger.debug("Path not based on Windows -> tokenizing with portable path separator (\"/\")");
            }
        }
        return tokens[tokens.length - 1];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("File=");
        builder.append(this.file != null ? "yes" : "no");
        builder.append(": name=");
        builder.append(this.fileName);
        builder.append(", abs=");
        builder.append(this.absolutePath);
        builder.append(", rel=");
        builder.append(this.relativePath);
        builder.append("]");
        return builder.toString();
    }
}

