/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.file.handler;

import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.BufferedFileHandler;
import eu.europa.ec.jrc.qcs.dao.model.config.Internationalization;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternationalizationHandler
extends BufferedFileHandler<Internationalization> {
    protected Internationalization internationalization;
    protected static Logger logger = LoggerFactory.getLogger(InternationalizationHandler.class);

    public InternationalizationHandler() {
        this.setCached(true);
    }

    public InternationalizationHandler(FileConnection connection) {
        super(connection);
        this.setCached(true);
    }

    public Internationalization getLanguageConfiguration() {
        String innerPath;
        if (this.cached && this.internationalization != null) {
            return this.internationalization;
        }
        String fileName = this.connection.getFileName();
        String filePath = this.connection.getRelativePath();
        ResourceBundle bundle = this.loadResourceBundle(fileName);
        if (bundle != null && logger.isInfoEnabled()) {
            logger.info("Loaded resource bundle from external configuration: " + fileName);
        }
        if (bundle == null && (bundle = this.loadResourceBundle(innerPath = filePath + "/" + fileName)) != null && logger.isInfoEnabled()) {
            logger.info("Loaded resource bundle from internal configuration: " + innerPath);
        }
        Internationalization model = new Internationalization(bundle);
        if (this.cached) {
            this.internationalization = model;
        }
        return model;
    }

    private ResourceBundle loadResourceBundle(String resourcePath) {
        ResourceBundle bundle = null;
        ResourceBundle.clearCache();
        try {
            bundle = ResourceBundle.getBundle(resourcePath);
        }
        catch (Exception e) {
            logger.warn("Failed to load resource bundle: " + resourcePath);
        }
        if (bundle != null && logger.isTraceEnabled()) {
            logger.trace("Loaded resource bundle: " + resourcePath);
        }
        return bundle;
    }

    @Override
    public void purge() {
        this.internationalization = null;
        if (logger.isWarnEnabled()) {
            logger.warn("purge() - Cleaned reference to last read resource bundle");
        }
    }
}

