/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.file.handler;

import eu.europa.ec.jrc.qcs.dao.CachedMap;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.gui.view.AlertDialog;
import eu.europa.ec.jrc.qcs.test.SystemTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericHandler<T> {
    protected Class<T> type = null;
    protected List<T> allRecords;
    protected boolean cached;
    protected boolean strict = true;
    protected boolean benchmark = false;
    protected static Logger logger = LoggerFactory.getLogger(GenericHandler.class);

    public void notifyFatalError(String message) {
        logger.error("notifyFatalError() - Notifying message: " + message);
        AlertDialog alert = AlertDialog.getInstance();
        if (alert != null) {
            alert.setTitle("Fatal error");
            alert.setFirstButtonMessage("OK");
            alert.setAction(1);
            alert.setMessage(message);
            alert.openPanel();
        } else {
            JOptionPane.showMessageDialog(null, message);
            logger.error("Failed to open alert panel: exiting...");
            System.exit(-1);
        }
    }

    public void notifyCriticalWarning(String message) {
        logger.warn("notifyCriticalError() - Notifying message: " + message);
        AlertDialog alert = AlertDialog.getInstance();
        if (alert != null) {
            alert.setTitle("Critical error");
            alert.setFirstButtonMessage("OK");
            alert.setAction(1);
            alert.setMessage(message);
            alert.openPanel();
        } else {
            JOptionPane.showMessageDialog(null, message);
            logger.error("Failed to open alert panel");
        }
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public List<T> getAllRecords() {
        return this.allRecords;
    }

    public void setAllRecords(List<T> allRecords) {
        this.allRecords = allRecords;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isBenchmark() {
        return this.benchmark;
    }

    public void setBenchmark(boolean benchmark) {
        this.benchmark = benchmark;
    }

    protected int getMaxValue(List<? extends GenericModel> list, String key) {
        if (list == null) {
            return 0;
        }
        int maxID = Integer.MIN_VALUE;
        for (GenericModel genericModel : list) {
            int id = genericModel.getGenericId(key);
            if (id > maxID) {
                maxID = id;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("getMax - analyzing " + genericModel.getModelLabel(null));
        }
        if (maxID != Integer.MIN_VALUE) {
            return maxID;
        }
        return 0;
    }

    protected <K> List<T> getListFromMap(Map<K, List<T>> map) {
        ArrayList<T> list = new ArrayList<T>();
        Collection<List<T>> mapValues = map.values();
        for (List<T> protocolsList : mapValues) {
            list.addAll(protocolsList);
        }
        return list;
    }

    public void purge() {
        this.allRecords = null;
        logger.warn(this.getClassName() + " - purge() - Cleaned inner cache (list of all records)");
        if (this instanceof CachedMap) {
            ((CachedMap)((Object)this)).initCache();
            logger.warn(this.getClassName() + " - purge() - Cleaned inner cached maps (indexes)");
        }
    }

    protected void benchmark(String prefix, Object object) {
        String objectID = null;
        if (object instanceof List) {
            List list = (List)object;
            Object first = list.get(0);
            if (first instanceof GenericModel) {
                GenericModel model = (GenericModel)first;
                objectID = model.getModelName();
            } else {
                objectID = this.getObjectIdentifier(first);
            }
        } else {
            objectID = this.getObjectIdentifier(object);
        }
        StringBuilder label = new StringBuilder();
        label.append(prefix);
        SystemTester.benchmark(label.toString(), objectID);
    }

    protected String getClassName() {
        String qualifiedName = this.getClass().getName();
        String[] tokens = qualifiedName.split("\\.");
        return tokens[tokens.length - 1];
    }

    protected String getObjectIdentifier() {
        return this.getObjectIdentifier(this);
    }

    protected String getObjectIdentifier(Object object) {
        if (object == null) {
            return "null";
        }
        String[] fullName = object.toString().split("@");
        String hash = fullName[fullName.length - 1];
        Object tType = "";
        if (object instanceof GenericHandler) {
            tType = "<" + this.type.getSimpleName() + ">";
        }
        String objectName = object.getClass().getSimpleName() + (String)tType;
        String objectIdentifier = objectName + "@" + hash;
        return objectIdentifier;
    }
}

