/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.file.handler;

import eu.europa.ec.jrc.qcs.dao.datasource.DynamicFileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.BufferedFileHandler;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.SerializableModel;
import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHandlerTXT<T>
extends BufferedFileHandler<T> {
    protected List<T> allLines;
    protected int cursor;
    protected boolean complete = false;
    protected boolean header = false;
    protected boolean autoIncrement = false;
    protected String headerLine;
    protected boolean autoCommit = true;
    protected boolean trimLines = true;
    protected boolean skipEmptyLines = true;
    protected boolean newFile = false;
    private String LINE_TERMINATOR = "\n";
    protected static Logger logger = LoggerFactory.getLogger(FileHandlerTXT.class);

    public FileHandlerTXT() {
    }

    public FileHandlerTXT(FileConnection connection) {
        super(connection);
    }

    public FileHandlerTXT(FileConnection connection, Class<T> type) {
        this(connection);
        this.setType(type);
    }

    public void reset() {
        this.cursor = 0;
        this.complete = false;
        this.headerLine = null;
        this.allLines = new ArrayList<T>();
        if (logger.isTraceEnabled()) {
            logger.trace(this.getClassName() + " - reset(): reset all TXT cached properties");
        }
    }

    public boolean openReader() {
        return this.openReader(0);
    }

    public boolean openReader(int resourceID) {
        boolean debug;
        this.resourceID = resourceID;
        if (!this.connection.hasReadAccess()) {
            String message = "openReader() - Target resource has not read access: " + this.connection.getFileName();
            logger.error(message);
            throw new IllegalStateException(message);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("openReader() - Connection type             : " + String.valueOf(this.connection.getClass()));
            logger.trace("openReader() - Reading file for resourceID : " + resourceID + " (path=" + this.connection.getFileName() + ")");
            logger.trace("openReader() - Using input stream          : " + String.valueOf(this.connection.getInputStream()));
        }
        if (debug = false) {
            logger.info("openReader() - -------------------------------------------------------");
            logger.info("openReader() - Reading file for resourceID : " + resourceID + " (path=" + this.connection.getFileName() + ")");
            logger.info("openReader() - Connection type             : " + String.valueOf(this.connection.getClass()));
            logger.info("openReader() - Using input stream          : " + String.valueOf(this.connection.getInputStream()));
        }
        if (this.connection instanceof DynamicFileConnection) {
            return this.openBufferedReader(resourceID);
        }
        return this.openBufferedReader();
    }

    public void closeReader() {
        if (logger.isTraceEnabled()) {
            logger.trace("closeReader() - Closing : " + this.getObjectIdentifier(this.bufferedReader) + " [auto-commit=" + this.isAutoCommit() + "]");
        }
        this.closeBufferedReader();
    }

    public void openWriter() {
        this.openWriter(0, 0);
    }

    public void openWriter(int resourceID) {
        this.openWriter(0, resourceID);
    }

    public void openWriter(int folderID, int resourceID) {
        if (!this.connection.hasWriteAccess()) {
            String message = "openWriter() - Target resource has not write access: " + this.connection.getFileName();
            logger.error(message);
            throw new IllegalStateException(message);
        }
        if (this.connection instanceof DynamicFileConnection) {
            this.openFileWriter(folderID, resourceID);
        } else {
            this.openFileWriter();
        }
        if (logger.isDebugEnabled()) {
            String info = " [" + (this.isNewFile() ? "NEW" : "OLD") + " - " + (this.hasHeader() ? "HEADER" : "NO_HEADER") + "]";
            logger.info("writeAllLines - Writing lines for resourceID = " + resourceID + ", " + this.connection.getFileName() + info);
        }
    }

    public void closeWriter() {
        if (logger.isTraceEnabled()) {
            logger.trace("closeReader() - Closing : " + this.getObjectIdentifier(this.bufferedWriter) + " [auto-commit=" + this.isAutoCommit() + "]");
        }
        this.closeBufferedWriter();
    }

    public List<T> readFile() {
        return this.readFile(0);
    }

    public List<T> readFile(int targetID) {
        this.resourceID = targetID;
        this.readAllLines(targetID);
        return this.allLines;
    }

    public T readNextLine() throws EOFException, InterruptedIOException {
        return this.readLine();
    }

    public T readNextLine(int targetID) throws EOFException, InterruptedIOException {
        return this.readLine(targetID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readAllLines(int resourceID) {
        this.reset();
        if (this.isAutoCommit()) {
            if (!this.openReader(resourceID)) {
                String message = "Failed opening reader for resourceID = " + resourceID;
                if (logger.isDebugEnabled()) {
                    logger.debug("readAllLines() - " + this.getClassName() + " : " + message);
                }
                throw new MissingResourceException(message, this.getClassName(), Integer.toString(resourceID));
            }
        } else if (this.bufferedReader == null) {
            String message = "Autocommit is off: client code MUST invoke openReader()";
            logger.error("readAllLines() - Error accessing file: " + this.connection.getFileName() + " (resourceID=" + resourceID + ")");
            throw new IllegalStateException(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("readAllLines() - Reading all lines for resourceID = " + resourceID);
        }
        try {
            String line = null;
            while ((line = this.bufferedReader.readLine()) != null) {
                T model;
                ++this.cursor;
                if (logger.isTraceEnabled()) {
                    logger.trace("readAllLines() - Read line " + this.cursor + ": " + line + " [" + line.length() + " chars]");
                }
                if (this.applyOption(line) || (model = this.deserializeModel(line)) == null) continue;
                this.allLines.add(model);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("readAllLines() - ADDED line " + this.allLines.size() + " : " + line + " -> " + String.valueOf(model));
            }
            this.complete = true;
        }
        catch (IOException e) {
            logger.error("readAllLines() - IOException: " + e.getMessage());
        }
        catch (Exception e) {
            if (!this.connection.isTemporaryFile()) {
                logger.error("readAllLines() - Exception: " + e.getMessage());
            }
        }
        finally {
            if (this.isAutoCommit()) {
                this.closeReader();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("readAllLines() - Feched all lines for resourceID = " + resourceID);
        }
    }

    protected T readLine() throws EOFException, InterruptedIOException {
        return this.readLine(0);
    }

    protected T readLine(int resourceID) throws EOFException, InterruptedIOException {
        if (logger.isTraceEnabled()) {
            logger.trace("readLine() - Resource \"" + this.connection.getFileName() + "\" -> autocommit : " + this.isAutoCommit());
            logger.trace("readLine() - Resource \"" + this.connection.getFileName() + "\" -> cursor     : " + this.cursor);
        }
        if (this.cursor == 0) {
            if (this.isAutoCommit()) {
                this.openReader(resourceID);
                if (logger.isTraceEnabled()) {
                    logger.trace("readLine() - Resource \"" + this.connection.getFileName() + "\" -> Opened: " + this.getObjectIdentifier(this.bufferedReader));
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("readLine() - Resource \"" + this.connection.getFileName() + "\" -> Opened: " + this.getObjectIdentifier(this.connection.getInputStream()));
                }
            } else if (this.bufferedReader == null) {
                String message = "Autocommit is off: client code MUST invoke openReader()";
                logger.error("readLine() - Error accessing file: " + this.connection.getFileName() + " (resourceID=" + resourceID + ")");
                throw new IllegalStateException(message);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("readLine() - Resource \"" + this.connection.getFileName() + "\" -> Using: " + this.getObjectIdentifier(this.bufferedReader));
        }
        if (this.complete) {
            String message = "File has been read before (producing " + this.allLines.size() + " lines). ";
            message = message + "In order to read the next line, it's necessary to invoke reset()";
            throw new InterruptedIOException(message);
        }
        T model = null;
        try {
            while (model == null) {
                String line = this.bufferedReader.readLine();
                if (logger.isTraceEnabled()) {
                    logger.trace("readLine() - Read line: " + line);
                }
                if (line == null) {
                    this.complete = true;
                    break;
                }
                ++this.cursor;
                if (this.applyOption(line)) continue;
                model = this.deserializeModel(line);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("readLine() - Created model: " + String.valueOf(model));
            }
        }
        catch (IOException io) {
            logger.error("IOException: " + io.getMessage());
        }
        if (this.complete) {
            if (this.isAutoCommit()) {
                this.closeReader();
            }
            throw new EOFException("Reached EOF (after having succesfully fetched all lines)");
        }
        return model;
    }

    protected boolean applyOption(String line) {
        if (this.trimLines) {
            line = new String(line.trim());
        }
        if (this.skipEmptyLines && line.length() <= 0) {
            return true;
        }
        if (this.header && this.headerLine == null) {
            this.deserializeHeader(line);
            return true;
        }
        return false;
    }

    public boolean writeFile(T record) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(record);
        int written = this.writeFile((List<T>)list);
        return written > 0;
    }

    public int writeFile(List<T> list) {
        return this.writeFile(0, list);
    }

    public boolean writeFile(int targetID, T record) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(record);
        int written = this.writeFile(targetID, (List<T>)list);
        return written > 0;
    }

    public int writeFile(int targetID, List<T> list) {
        this.resourceID = targetID;
        return this.writeAllLines(targetID, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeAllLines(int resourceID, List<T> list) {
        if (list == null || list.size() == 0) {
            logger.warn("writeAllLines() - Input list is empty for file: " + this.connection.getFileName());
            return 0;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("writeAllLines() - Resource \"" + this.connection.getFileName() + "\" -> autocommit : " + this.isAutoCommit());
            logger.trace("writeAllLines() - Resource \"" + this.connection.getFileName() + "\" -> cursor     : " + this.cursor);
        }
        if (this.isAutoCommit()) {
            this.openWriter(resourceID);
            if (logger.isTraceEnabled()) {
                logger.trace("writeAllLines() - Resource \"" + this.connection.getFileName() + "\" -> Opened: " + this.getObjectIdentifier(this.bufferedWriter));
            }
        } else if (this.bufferedWriter == null) {
            String message = "Autocommit is off: client code MUST invoke openWriter()";
            throw new IllegalStateException(message);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("writeAllLines() - Resource \"" + this.connection.getFileName() + "\" -> Using: " + this.getObjectIdentifier(this.bufferedWriter));
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("writeAllLines() - Writing first line: " + String.valueOf(list.get(0)));
            }
            if (this.isNewFile()) {
                if (this.hasHeader()) {
                    String header = this.getHeaderLine(list);
                    this.bufferedWriter.write((String)header + this.LINE_TERMINATOR);
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.getObjectIdentifier() + " [" + this.connection.getFileName() + "] - Wrote header: " + (String)header);
                    }
                }
                this.setNewFile(false);
            }
            for (Object model : list) {
                String line = this.serializeModel(model);
                this.bufferedWriter.write(line + this.LINE_TERMINATOR);
                ++this.cursor;
                if (!logger.isTraceEnabled()) continue;
                logger.trace("writeAllLines() - Written line: " + line);
            }
        }
        catch (IOException e) {
            logger.error("IOException: " + e.getMessage());
        }
        finally {
            if (this.isAutoCommit()) {
                this.closeWriter();
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("writeAllLines() - Written lines: " + this.cursor);
        }
        return this.cursor;
    }

    public boolean writeNextLine(T object) {
        GenericModel model = null;
        if (!(object instanceof GenericModel)) {
            String message = "writeNextLine() -  Method requires a GenericModel instance as input";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        model = (GenericModel)object;
        if (model.getId() == 1) {
            this.setNewFile(true);
            this.setHeaderLine(this.serializeHeader(object));
        }
        ArrayList<T> list = new ArrayList<T>();
        list.add(object);
        try {
            this.writeFile((List<T>)list);
            if (logger.isTraceEnabled()) {
                logger.trace("writeNextLine() - Written lines: " + list.size() + " -> " + this.cursor);
            }
        }
        catch (MissingResourceException mre) {
            logger.warn("writeNextLine() - Persistence file/path not found -> creating new one");
            boolean created = this.checkResourcePath();
            if (created) {
                this.setNewFile(true);
                this.setHeaderLine(this.serializeHeader(object));
                this.writeFile((List<T>)list);
                if (logger.isInfoEnabled()) {
                    logger.info("writeNextLine() - Persistence file/path missing succesully created");
                }
            }
            String message = "writeNextLine() - Impossible to create persistence object";
            logger.error(message);
            throw new IOError(mre);
        }
        catch (Exception e) {
            logger.error("writeNextLine() - Unexepeted error: " + e.getMessage());
            return false;
        }
        catch (Throwable t) {
            logger.error("writeNextLine() - Fatal error: " + t.getMessage());
            return false;
        }
        if (logger.isTraceEnabled()) {
            String message = this.connection.getFileName() + " -> Written lines: " + this.cursor;
            message = message + " [" + this.getObjectIdentifier(this.connection.getFileWriter()) + "]";
            logger.trace("writeAllLines() - " + message);
        }
        return true;
    }

    protected String serializeModel(T model) {
        if ("String".equals(this.type.getSimpleName())) {
            String string = (String)model;
            return string;
        }
        throw new UnsupportedOperationException("FileHandlerTXT default implementation supports only T=String type");
    }

    protected String serializeHeader(T header) {
        return this.serializeModel(header);
    }

    protected String formatArray(String[] values) {
        return Arrays.toString(values);
    }

    protected T deserializeModel(String line) {
        if ("String".equals(this.type.getSimpleName())) {
            String string = line;
            return (T)string;
        }
        throw new UnsupportedOperationException("FileHandlerTXT default implementation supports only T=String type");
    }

    protected void deserializeHeader(String line) {
        this.setHeaderLine(new String(line));
    }

    public String getHeaderLine(List<T> list) {
        if (this.headerLine == null) {
            SerializableModel model = null;
            if (list != null && list.size() > 0) {
                T firstLine = list.get(0);
                if (firstLine instanceof SerializableModel) {
                    model = (SerializableModel)firstLine;
                } else {
                    logger.error("getHeaderLine() - Failed using statefull constructor for type: " + this.type.getSimpleName());
                }
            } else {
                model = (SerializableModel)SerializableModel.getInstance(this.type);
                logger.warn("getHeaderLine() - Used stateless constructor for type: " + this.type.getSimpleName());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getHeaderLine<" + this.type.getSimpleName() + ">: using model = " + String.valueOf(model));
            }
            String[] header = model.serializeHeader();
            this.headerLine = this.formatArray(header);
            if (logger.isDebugEnabled()) {
                logger.debug("getHeaderLine<" + this.type.getSimpleName() + ">: set new headerLine = " + this.headerLine);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getHeaderLine<" + this.type.getSimpleName() + ">: using headerLine = " + this.headerLine);
        }
        return this.headerLine;
    }

    protected void initTargetFile(int resourceID) {
        if (this.isNewFile()) {
            if (logger.isDebugEnabled()) {
                logger.debug("initTargetFile() - Target file already marked as \"new\"");
            }
            return;
        }
        FileConnection fileConnection = this.getConnection();
        if (fileConnection instanceof DynamicFileConnection) {
            DynamicFileConnection actualConnection = (DynamicFileConnection)fileConnection;
            boolean opened = actualConnection.openStreamFromDynamicPath(resourceID);
            if (!opened) {
                logger.error("initTargetFile() - Failed opening stream from dynamic path");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("initTargetFile() - Opened dynamic connection for resourceID : " + resourceID);
                logger.debug("initTargetFile() - Input stream for dynamic connection      : " + fileConnection.hasInputStream());
            }
        } else {
            fileConnection.openConnection();
            if (logger.isDebugEnabled()) {
                logger.debug("initTargetFile() - Opened simple file connection: " + String.valueOf(fileConnection));
            }
        }
        if (!fileConnection.hasInputStream() || !fileConnection.isAppend()) {
            this.setNewFile(true);
            if (logger.isDebugEnabled()) {
                logger.debug("initTargetFile() - Creating new file: " + fileConnection.getFileName());
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("initTargetFile() - Using already existing file: " + fileConnection.getFileName());
        }
        fileConnection.closeConnection();
    }

    public void setAutoCommit(boolean autoCommit) {
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("setAutoCommit() - Target file        : " + this.connection.getFileName() + " -> Autocommit: " + this.autoCommit + " -> " + autoCommit);
        }
        this.autoCommit = autoCommit;
        if (!this.isAutoCommit()) {
            if (this.connection.hasWriteAccess()) {
                if (logger.isDebugEnabled()) {
                    String message = "Disabling auto commit for a resource with write access (" + this.connection.getFileName() + ") ";
                    message = message + "requires some care: please make sure to open/close this handler from the client code";
                    logger.debug(this.getClassName() + " - setAutoCommit(): " + message);
                }
            } else {
                String message = "Disabling auto commit for a resource with only read access (" + this.connection.getFileName() + ") ";
                message = message + "is meaningless. It's suggested to use always auto commit in read-onlu mode.";
                logger.warn(this.getClassName() + " - setAutoCommit(): " + message);
            }
        }
    }

    public boolean isAutoCommit() {
        if (logger.isTraceEnabled()) {
            logger.trace("isAutoCommit() - Target file        : " + this.connection.getFileName() + " -> Autocommit = " + this.autoCommit);
        }
        return this.autoCommit;
    }

    public List<T> getAllLines() {
        return this.allLines;
    }

    public void setAllLines(List<T> resultSet) {
        this.allLines = resultSet;
    }

    public int getCursor() {
        return this.cursor;
    }

    public void setCursor(int cursor) {
        this.cursor = cursor;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean hasHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public void setHeaderLine(String headerLine) {
        this.headerLine = headerLine;
    }

    public boolean isTrimLines() {
        return this.trimLines;
    }

    public void setTrimLines(boolean trimLines) {
        this.trimLines = trimLines;
    }

    public boolean isSkipEmptyLines() {
        return this.skipEmptyLines;
    }

    public void setSkipEmptyLines(boolean skipEmptyLines) {
        this.skipEmptyLines = skipEmptyLines;
    }

    public boolean isNewFile() {
        return this.newFile;
    }

    public void setNewFile(boolean newFile) {
        this.newFile = newFile;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    @Override
    public void purge() {
        super.purge();
        this.reset();
        if (logger.isWarnEnabled()) {
            logger.warn("purge() - Cleaned inner cache (list of all lines)");
        }
    }
}

