/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.file.handler;

import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerTXT;
import eu.europa.ec.jrc.qcs.dao.model.SerializableModel;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHandlerCSV<T>
extends FileHandlerTXT<T> {
    protected boolean comments = true;
    protected String[] columnNames;
    protected String tokenSeparator = ";";
    public static final char COMMENT = '#';
    protected static Logger logger = LoggerFactory.getLogger(FileHandlerCSV.class);

    public FileHandlerCSV() {
    }

    public FileHandlerCSV(FileConnection connection) {
        super(connection);
    }

    public FileHandlerCSV(FileConnection connection, Class<T> type) {
        this(connection);
        this.setType(type);
    }

    public FileHandlerCSV(FileConnection connection, Class<T> type, boolean comments) {
        this(connection, type);
        this.setComments(comments);
    }

    @Override
    public void reset() {
        super.reset();
        this.columnNames = null;
        if (logger.isTraceEnabled()) {
            logger.trace(this.getClassName() + " - reset(): reset all CSV cached properties");
        }
    }

    @Override
    protected String serializeModel(T model) {
        if (model == null) {
            return null;
        }
        if (model instanceof SerializableModel) {
            SerializableModel serializableModel = (SerializableModel)model;
            String[] values = serializableModel.serialize();
            return this.formatArray(values);
        }
        String message = "Model " + String.valueOf(this.type) + " does not implement the SerializableModel abstract class";
        logger.error(message);
        throw new IllegalArgumentException(message);
    }

    @Override
    protected String serializeHeader(T header) {
        if (header == null) {
            return null;
        }
        if (header instanceof SerializableModel) {
            SerializableModel serializableHeader = (SerializableModel)header;
            String[] values = serializableHeader.serializeHeader();
            return this.formatArray(values);
        }
        String message = "Header " + String.valueOf(this.type) + " does not implement the SerializableModel abstract class";
        logger.error(message);
        throw new IllegalArgumentException(message);
    }

    @Override
    protected String formatArray(String[] values) {
        if (values == null) {
            return "NO_VALUES";
        }
        String sep = "";
        StringBuilder builder = new StringBuilder();
        for (String string : values) {
            builder.append(sep);
            builder.append(string);
            if (sep.length() != 0) continue;
            sep = this.tokenSeparator;
        }
        return builder.toString();
    }

    @Override
    protected T deserializeModel(String line) {
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("deserializeModel() - Input line: " + line);
        }
        if (this.skipLine(line)) {
            return null;
        }
        Object[] lineAsArray = this.tokenize(line);
        if (lineAsArray.length == 1) {
            String modelID = Integer.toString(this.resourceID);
            lineAsArray = new String[]{modelID, lineAsArray[0]};
        }
        if (debug) {
            logger.info("deserializeModel() - Line as array: " + Arrays.toString(lineAsArray));
        }
        Object model = SerializableModel.deserialize(this.type, (String[])lineAsArray);
        if (this.columnNames != null && debug) {
            logger.info("deserializeModel() - [" + this.connection.getFileName() + "] " + this.cursor + ") Setting columns: " + Arrays.toString(this.columnNames));
        }
        if (this.header && model instanceof DataRecordCSV) {
            ((DataRecordCSV)model).setColumnNames(this.columnNames);
        }
        return (T)model;
    }

    @Override
    protected void deserializeHeader(String line) {
        if (logger.isDebugEnabled()) {
            logger.debug("deserializeHeader(): " + line + " (" + (line == null) + ")");
        }
        if (this.skipLine(line)) {
            return;
        }
        super.deserializeHeader(line);
        String[] headerAsArray = this.tokenize(line);
        if (headerAsArray.length == 1) {
            headerAsArray = new String[]{"resourceID", headerAsArray[0]};
        }
        this.columnNames = headerAsArray;
        if (logger.isDebugEnabled()) {
            logger.debug("deserializeHeader() " + this.cursor + ") Set columns: " + Arrays.toString(this.columnNames));
        }
    }

    protected String[] tokenize(String line) {
        return line.split(this.tokenSeparator, -1);
    }

    protected boolean skipLine(String line) {
        if (line == null) {
            return true;
        }
        return this.comments && '#' == line.charAt(0);
    }

    public boolean hasComments() {
        return this.comments;
    }

    public void setComments(boolean comments) {
        this.comments = comments;
    }

    public String getTokenSeparator() {
        return this.tokenSeparator;
    }

    public void setTokenSeparator(String tokenSeparator) {
        this.tokenSeparator = tokenSeparator;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }
}

