/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.file.handler;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.Main;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackHandler {
    protected static Logger logger = LoggerFactory.getLogger(FallbackHandler.class);

    public boolean manageFallback(String fileName) {
        String className = FallbackHandler.class.getSimpleName() + ".class";
        URL resourceUrl = FallbackHandler.class.getResource(className);
        boolean runningFromJar = resourceUrl.getProtocol().equals("jar");
        if (logger.isInfoEnabled()) {
            logger.info("manageFallback() - Running from JAR ? " + runningFromJar);
        }
        File file = new File(fileName);
        Path fallbackFilePath = this.getFallbackFilePath(fileName);
        if (logger.isDebugEnabled()) {
            logger.debug("manageFallback() - Handling fallback for : " + fileName + " -> " + String.valueOf(fallbackFilePath));
        }
        String fallbackFileHash = null;
        if ("qcs.db".equalsIgnoreCase(fileName)) {
            fallbackFileHash = "b359d90ba6bd2590170ddfbb58d801b1c2d685ed947392739c0c14af93c43a08";
        } else {
            logger.error("manageFallback() - Cannot calculate hash of resource: " + fileName);
        }
        String fileHash = null;
        if (file.exists()) {
            fileHash = this.computeHash(file.toPath());
            if (logger.isInfoEnabled()) {
                logger.info("manageFallback() - Found file " + fileName + " in root folder: " + fileHash);
            }
            if (fileHash.equals(fallbackFileHash)) {
                if (logger.isInfoEnabled()) {
                    logger.info("manageFallback() - Work DB is the same as factory DB");
                }
            } else {
                logger.warn("manageFallback() - Work DB is NOT the same as factory DB");
            }
        } else {
            block26: {
                fallbackFilePath = null;
                if (logger.isWarnEnabled()) {
                    logger.warn("manageFallback() - File " + fileName + " is not in working folder -> restoring factory file");
                }
                try {
                    fallbackFilePath = Paths.get(Thread.currentThread().getContextClassLoader().getResource(fileName).getPath(), new String[0]);
                    if (logger.isDebugEnabled()) {
                        logger.debug("manageFallback() - fallbackFilePath: " + fallbackFilePath.toString());
                    }
                }
                catch (InvalidPathException e) {
                    fallbackFilePath = null;
                    if (!logger.isWarnEnabled()) break block26;
                    logger.warn("manageFallback() - Failed to find resource on Linux path -> trying Windows path");
                }
            }
            boolean alreadyCopied = false;
            if (fallbackFilePath == null) {
                if (logger.isInfoEnabled()) {
                    logger.info("manageFallback() - Null fallbackFilePath for: " + fileName);
                }
                boolean bl = alreadyCopied = (fallbackFilePath = this.getWindowsPath(fileName)) != null;
                if (logger.isInfoEnabled()) {
                    logger.info("manageFallback() - Found resource in: " + String.valueOf(fallbackFilePath));
                }
            }
            if (runningFromJar) {
                if (logger.isInfoEnabled()) {
                    logger.info("manageFallback() - Copying master file from the JAR");
                }
                try {
                    if (!alreadyCopied) {
                        this.copyFromJAR(fileName, fallbackFilePath);
                    } else if (logger.isInfoEnabled()) {
                        logger.info("manageFallback() - Resource already copied (Windows scenario)");
                    }
                }
                catch (IOException e) {
                    logger.error("manageFallback() - Error copying resource from JAR : " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info("manageFallback() - Copying master file from the IDE");
                }
                this.copyFromFS(fileName, fallbackFilePath);
            }
        }
        return true;
    }

    public Path getFallbackFilePath(String fileName) {
        Path fallbackFilePath = null;
        if (logger.isDebugEnabled()) {
            logger.debug("getFallbackFilePath() - Searching fallback Path for: " + fileName);
        }
        try {
            fallbackFilePath = Paths.get(Thread.currentThread().getContextClassLoader().getResource(fileName).getPath(), new String[0]);
        }
        catch (InvalidPathException e) {
            String message = "Error copying \"" + fileName + "\" from JAR: ";
            logger.error("getFallbackFilePath() - " + message + e.getMessage());
        }
        if (fallbackFilePath == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getFallbackFilePath() - Null fallback for: " + fileName);
            }
            fallbackFilePath = this.getWindowsPath(fileName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getFallbackFilePath() - Fallback File Path is: " + fallbackFilePath.toString());
        }
        return fallbackFilePath;
    }

    private void copyFromFS(String fileName, Path fallbackFilePath) {
        File file = new File(fileName);
        try {
            Files.copy(fallbackFilePath, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (logger.isWarnEnabled()) {
                logger.warn("copyFromFS() - Copied factory version of \"" + fileName + "\" from " + String.valueOf(fallbackFilePath));
            }
        }
        catch (IOException e) {
            logger.error("copyFromFS() - Failed copying file: " + fileName);
            e.printStackTrace();
        }
    }

    private void copyFromJAR(String fileName, Path fallbackFilePath) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("copyFromJAR() - Copy : " + fileName + " from " + String.valueOf(fallbackFilePath));
        }
        File file = new File(fileName);
        Path dbWorkCopy = file.toPath();
        Path path = this.getPathInJar(fallbackFilePath);
        if (logger.isDebugEnabled()) {
            logger.debug("copyFromJAR() - Using path in jar: " + String.valueOf(path));
        }
        Files.copy(path, dbWorkCopy, StandardCopyOption.REPLACE_EXISTING);
        if (logger.isWarnEnabled()) {
            logger.warn("copyFromJAR() - Copied factory version of \"" + fileName + "\" in: " + String.valueOf(fallbackFilePath));
        }
    }

    private Path getPathInJar(Path fallbackFilePath) {
        if (logger.isDebugEnabled()) {
            logger.debug("getPathInJar() - Fallback file's path: " + String.valueOf(fallbackFilePath));
        }
        Path path = null;
        Configuration configuration = Configuration.getInstance();
        if (!configuration.isWindows()) {
            String masterFile;
            HashMap env = new HashMap();
            String[] array = fallbackFilePath.toString().split("!");
            String masterPath = array[0];
            String string = masterFile = array.length > 1 ? array[1] : null;
            if (logger.isDebugEnabled()) {
                logger.debug("getPathInJar(GNU) - Copying from master's path: " + masterPath);
            }
            URI uri = URI.create("jar:file:/" + masterPath.replace("\\", "/"));
            if (logger.isDebugEnabled()) {
                logger.debug("getPathInJar(GNU) - Copying file from path: " + String.valueOf(uri));
            }
            FileSystem fs = null;
            try {
                fs = FileSystems.newFileSystem(uri, env);
            }
            catch (IOException e) {
                logger.error("getPathInJar() - Failed copying file in working directory");
                e.printStackTrace();
            }
            path = masterFile != null ? fs.getPath(masterFile, new String[0]) : fs.getPath(masterFile, new String[0]);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("getPathInJar(WIN) - Running on Windows: doing nothing");
            }
            logger.info("getPathInJar(WIN) - Running on Windows: doing nothing");
        }
        return path;
    }

    private Path getWindowsPath(String fileName) {
        return this.getWindowsPath(fileName, null);
    }

    private Path getWindowsPath(String fileName, String targetDir) {
        Path fallbackFilePath = null;
        if (logger.isInfoEnabled()) {
            logger.debug("getWindowsPath() - Searching path for " + fileName + " (target: " + targetDir + ")");
        }
        try {
            URL fileUrl = Thread.currentThread().getContextClassLoader().getResource(fileName);
            if (fileUrl != null) {
                if (fileUrl.getProtocol().equals("file")) {
                    fallbackFilePath = Paths.get(fileUrl.toURI());
                    if (logger.isWarnEnabled()) {
                        logger.warn("getWindowsPath() - Running from IDE -> ignoring fallback path: " + String.valueOf(fallbackFilePath));
                    }
                } else if (fileUrl.getProtocol().equals("jar")) {
                    InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
                    Path jarFilePath = Paths.get(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    Path externalDir = jarFilePath.getParent();
                    fallbackFilePath = externalDir.resolve(fileName);
                    boolean confirm = false;
                    if (confirm) {
                        Files.copy(inputStream, fallbackFilePath, StandardCopyOption.REPLACE_EXISTING);
                        if (logger.isWarnEnabled()) {
                            logger.warn("getWindowsPath() - Copied factory version of \"" + fileName + "\" in: " + String.valueOf(fallbackFilePath));
                        }
                    } else if (logger.isWarnEnabled()) {
                        logger.warn("getWindowsPath() - Restore of fatory configuration (fallback) is disabled");
                    }
                }
            }
            if (fallbackFilePath != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("getWindowsPath() - Found fallback file in path: " + String.valueOf(fallbackFilePath));
                }
            } else {
                logger.error("getWindowsPath() - Failed looking for file: " + fileName);
            }
        }
        catch (IOException | URISyntaxException e) {
            logger.error("getWindowsPath() - Error looking for file: " + fileName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getWindowsPath() - Returning fallback path: " + String.valueOf(fallbackFilePath));
        }
        return fallbackFilePath;
    }

    private String computeHash(Path filePath) {
        if (logger.isDebugEnabled()) {
            logger.debug("computeHash() - Target file: " + String.valueOf(filePath));
        }
        try {
            byte[] data = Files.readAllBytes(filePath);
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(data);
            String checksum = new BigInteger(1, hash).toString(16);
            return checksum;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            logger.error("computeHash() - Failed computing hash: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (NullPointerException e) {
            logger.error("computeHash() - Null target hash: " + String.valueOf(filePath));
            return null;
        }
    }
}

