/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.file.handler;

import eu.europa.ec.jrc.qcs.dao.datasource.DynamicFileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedFileHandler<T>
extends GenericHandler<T> {
    protected FileConnection connection;
    protected BufferedReader bufferedReader;
    protected BufferedWriter bufferedWriter;
    protected int resourceID;
    protected boolean checkConnections = false;
    protected static Logger logger = LoggerFactory.getLogger(BufferedFileHandler.class);

    public BufferedFileHandler() {
    }

    public BufferedFileHandler(FileConnection connection) {
        this.connection = connection;
    }

    protected boolean openBufferedReader() {
        this.connection.openConnection();
        InputStream inputStream = this.connection.getInputStream();
        if (inputStream == null) {
            String message = "Failed to open InputStream. File read access = " + this.connection.hasReadAccess();
            logger.warn(message);
            String fileName = this.connection.getFileName();
            String className = this.type.getCanonicalName().toString();
            logger.error("Failed to open : " + fileName);
            throw new MissingResourceException(message, className, fileName);
        }
        boolean result = this.openBufferedReaderFromInputStream(inputStream);
        if (this.checkConnections) {
            logger.info("openBufferedReader() - Using InputStream for \"" + this.getResourceName() + "\" : " + this.getObjectIdentifier(inputStream));
            logger.info("openBufferedReader() - Opened openBufferedReader for \"" + this.getResourceName() + "\" : " + this.getObjectIdentifier(this.bufferedReader));
        }
        return result;
    }

    protected boolean openBufferedReader(int resourceID) {
        DynamicFileConnection actualConnection = (DynamicFileConnection)this.connection;
        boolean opened = actualConnection.openStreamFromDynamicPath(resourceID);
        InputStream inputStream = null;
        if (opened) {
            inputStream = actualConnection.getInputStream();
        } else {
            if (!this.connection.isTemporaryFile()) {
                logger.error("openBufferedReader(int) - Impossible to open a BufferedReader without a valid InputStream: " + this.connection.getFileName());
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("openBufferedReader(int) - Failed to open a BufferedReader for a \"temporary\" file: " + this.connection.getFileName());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("openBufferedReader(int) - Opened InputStream : " + String.valueOf(inputStream));
        }
        boolean result = this.openBufferedReaderFromInputStream(inputStream);
        if (this.checkConnections) {
            logger.info("openBufferedReader(int) - Using InputStream for \"" + this.getResourceName() + "\" : " + this.getObjectIdentifier(inputStream));
            logger.info("openBufferedReader(int) - Opened openBufferedReader for \"" + this.getResourceName() + "\" : " + this.getObjectIdentifier(this.bufferedReader));
        }
        return result;
    }

    public void closeBufferedReader() {
        if (this.connection.hasWriteAccess() && this.bufferedWriter != null) {
            String message = "Connections with write access MUST close the Writer BEFORE closing the Reader";
            logger.error("closeBufferedReader() - " + message);
            throw new IllegalStateException(message);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("closeBufferedReader() - Closing BufferedReader AND related stream: " + this.getObjectIdentifier(this.bufferedReader));
        }
        try {
            if (this.bufferedReader != null) {
                this.bufferedReader.close();
                this.bufferedReader = null;
            }
            if (this.connection != null) {
                this.connection.closeConnection();
            }
        }
        catch (IOException e) {
            logger.error("closeBufferedReader() - IOException closing reader: " + e.getMessage());
        }
    }

    protected boolean openFileWriter() {
        this.connection.openConnection();
        FileWriter fileWriter = this.connection.getFileWriter();
        if (fileWriter == null) {
            String message = "Found null FileWriter (file write access = " + this.connection.hasWriteAccess() + ")";
            logger.error(message);
            String fileName = this.connection.getFileName();
            String className = this.type.getCanonicalName().toString();
            throw new MissingResourceException(message, className, fileName);
        }
        boolean result = this.openBufferedWriterFromFileWriter(fileWriter);
        if (this.checkConnections) {
            logger.info("openFileWriter() - Opened BufferedWriter for \"" + this.getResourceName() + "\" : " + this.getObjectIdentifier(this.bufferedWriter));
        }
        return result;
    }

    protected boolean openFileWriter(int folderID, int resourceID) {
        DynamicFileConnection actualConnection = (DynamicFileConnection)this.connection;
        if (!actualConnection.hasFileWriter()) {
            if (logger.isTraceEnabled()) {
                logger.trace("openFileWriter(int, int) - Checking path for resouce: " + String.valueOf(this.connection) + " [" + folderID + "-" + resourceID + "]");
            }
            this.checkResourcePath(folderID);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("openFileWriter(int, int) - Opened FileWriter for \"" + this.getResourceName() + "\" : " + this.getObjectIdentifier(actualConnection.getFileWriter()));
        }
        actualConnection.openWriterFromDynamicPath(folderID, resourceID);
        FileWriter fileWriter = actualConnection.getFileWriter();
        if (logger.isTraceEnabled()) {
            logger.trace("openFileWriter(int, int) - Opened FileWriter for \"" + this.getResourceName() + "\" : " + this.getObjectIdentifier(actualConnection.getFileWriter()));
        }
        boolean opened = this.openBufferedWriterFromFileWriter(fileWriter);
        if (this.checkConnections) {
            logger.info("openFileWriter(int, int) - Opened BufferedWriter for \"" + this.getResourceName() + "\" : " + this.getObjectIdentifier(this.bufferedWriter));
        }
        return opened;
    }

    public void flush() {
        try {
            this.bufferedWriter.flush();
        }
        catch (IOException e) {
            String message = "Error flushing writer " + this.getObjectIdentifier(this.bufferedReader) + " : " + e.getMessage();
            logger.error("flush() - " + message);
        }
    }

    public void closeBufferedWriter() {
        if (logger.isTraceEnabled()) {
            logger.trace("closeBufferedWriter() - Closing BufferedWriter AND related stream: " + this.getObjectIdentifier(this.bufferedWriter));
        }
        this.flush();
        try {
            if (this.bufferedWriter != null) {
                this.bufferedWriter.close();
                this.bufferedWriter = null;
            }
            if (this.connection != null) {
                this.connection.closeConnection();
            }
        }
        catch (IOException e) {
            logger.error("closeBufferedWriter() - Error closing connection: " + e.getMessage());
        }
    }

    protected boolean openBufferedReaderFromInputStream(InputStream inputStream) {
        this.bufferedReader = null;
        if (inputStream == null) {
            if (!this.connection.isTemporaryFile()) {
                logger.error("openBufferedReaderFromInputStream() - Failed to open BufferedReader for file: " + this.getResourceName() + " (null InputStream)");
            }
            return false;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        this.bufferedReader = new BufferedReader(inputStreamReader);
        if (logger.isTraceEnabled()) {
            logger.trace("openBufferedReaderFromInputStream() - Loading file: " + this.getResourceName() + " [" + String.valueOf(inputStream) + "]");
        }
        return this.bufferedReader != null;
    }

    protected boolean openBufferedWriterFromFileWriter(FileWriter fileWriter) {
        this.bufferedWriter = null;
        if (fileWriter == null) {
            logger.error("openBufferedWriterFromFileWriter() - Failed to open FileWriter for file: " + this.getResourceName() + " (null FileWriter)");
            return false;
        }
        this.bufferedWriter = new BufferedWriter(fileWriter);
        if (logger.isTraceEnabled()) {
            logger.trace("openBufferedWriterFromFileWriter() - Opened BufferedWriter: " + String.valueOf(this.bufferedWriter) + " for resource: " + this.getResourceName());
        }
        return this.bufferedWriter != null;
    }

    protected boolean checkResourcePath() {
        return this.checkResourcePath(-1);
    }

    protected boolean checkResourcePath(int folderID) {
        String subfolder;
        String string = subfolder = folderID > 0 ? "/" + String.valueOf(folderID) : "";
        if (this.connection.getRelativePath() != null) {
            String path = this.connection.getRelativePath() + subfolder;
            File directory = new File(path);
            if (logger.isTraceEnabled()) {
                logger.trace("createResource() - Checking relative path: " + path);
            }
            if (!directory.exists()) {
                if (logger.isInfoEnabled()) {
                    logger.info("createResource() - Creating relative path: " + path);
                }
                return directory.mkdir();
            }
        } else if (this.connection.getAbsolutePath() != null) {
            String path = this.connection.getAbsolutePath() + subfolder;
            if (logger.isInfoEnabled()) {
                logger.info("createResource() - Checking absolute path: " + path);
            }
            throw new UnsupportedOperationException("createResource() - Creation of absolute path not needed yet");
        }
        return false;
    }

    protected int getResourceID() {
        return this.resourceID;
    }

    protected void setResourceID(int resourceID) {
        this.resourceID = resourceID;
    }

    public FileConnection getConnection() {
        return this.connection;
    }

    public void setConnection(FileConnection connection) {
        this.connection = connection;
    }

    public BufferedReader getBufferedReader() {
        return this.bufferedReader;
    }

    public void setBufferedReader(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
    }

    public BufferedWriter getBufferedWriter() {
        return this.bufferedWriter;
    }

    public void setBufferedWriter(BufferedWriter bufferedWriter) {
        this.bufferedWriter = bufferedWriter;
    }

    protected String getResourceName() {
        Object filePath = null;
        if (this.connection instanceof DynamicFileConnection) {
            filePath = this.connection.getFileName() + " [resourceID=" + this.resourceID + "]";
        } else {
            filePath = this.connection.getRelativePath() + "/" + this.connection.getFileName();
            if (((String)filePath).length() <= 1) {
                filePath = this.connection.getAbsolutePath();
            }
        }
        return filePath;
    }
}

