/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.file;

import eu.europa.ec.jrc.qcs.dao.ValidationRunDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.AbstractDAO;
import eu.europa.ec.jrc.qcs.dao.model.output.ValidationRun;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationRunDAOImpl
extends AbstractDAO<ValidationRun>
implements ValidationRunDAO {
    protected static Logger logger = LoggerFactory.getLogger(ValidationRunDAOImpl.class);

    public ValidationRunDAOImpl() {
        this.setCached(false);
        this.setStrict(true);
        this.setHeader(true);
        this.setComments(true);
        this.setType(ValidationRun.class);
    }

    public ValidationRunDAOImpl(FileConnection connection) {
        this();
        this.connection = connection;
        this.connection.setWriteAccess(true);
    }

    @Override
    public List<ValidationRun> getAll() {
        if (this.cached && this.allRecords != null) {
            return this.allRecords;
        }
        List<ValidationRun> list = null;
        try {
            list = this.readFile();
        }
        catch (MissingResourceException mre) {
            if (logger.isInfoEnabled()) {
                logger.info("getAll() - Returning empty list: this should happen only when runnning from a clean installation");
            }
            list = new ArrayList<ValidationRun>();
        }
        if (this.cached) {
            this.allRecords = list;
        }
        return list;
    }

    @Override
    public ValidationRun getByID(int recordID) {
        ValidationRun validationRun = (ValidationRun)this.getRecordByID(recordID);
        if (validationRun != null) {
            return validationRun;
        }
        return ValidationRun.UNDEF;
    }

    @Override
    public List<ValidationRun> getByProtocolID(int protocolID) {
        List<ValidationRun> list = this.getAll();
        if (list == null) {
            return ValidationRun.EMPTY_LIST;
        }
        ArrayList<ValidationRun> result = new ArrayList<ValidationRun>();
        for (ValidationRun validationRun : list) {
            if (validationRun.getProtocolID() != protocolID) continue;
            result.add(validationRun);
        }
        return result;
    }

    @Override
    public boolean save(ValidationRun validationRun) {
        int nextRecordID = this.getMaxID() + 1;
        validationRun.setId(nextRecordID);
        if (logger.isDebugEnabled()) {
            logger.debug("save() - Next record ID: " + nextRecordID);
        }
        return this.writeNextLine(validationRun);
    }

    @Override
    public int save(List<ValidationRun> records) {
        this.notifyCriticalWarning("Saving list not requested for ValidationRun records: doing nothing");
        return 0;
    }

    @Override
    public int updateAll(List<ValidationRun> records) {
        this.notifyCriticalWarning("Overwriting records feature not requested for ValidationRun records: doing nothing");
        return 0;
    }
}

