/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.file;

import eu.europa.ec.jrc.qcs.dao.RuleOutputDetailDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFileDAOFactory;
import eu.europa.ec.jrc.qcs.dao.file.AbstractDAO;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerCSV;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.dao.model.output.ValidationRun;
import eu.europa.ec.jrc.qcs.engine.RawFilesWriter;
import eu.europa.ec.jrc.qcs.test.SystemTester;
import java.io.EOFException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleOutputDetailDAOImpl
extends AbstractDAO<RuleOutputDetail>
implements RuleOutputDetailDAO {
    protected static int lastRecordID;
    protected int currentValidationRunID;
    protected boolean lastValidationRun;
    protected FileConnection alternateConnection;
    protected static Logger logger;

    public RuleOutputDetailDAOImpl() {
        boolean firstInit;
        this.setCached(false);
        this.setStrict(true);
        this.setHeader(true);
        this.setComments(true);
        this.setType(RuleOutputDetail.class);
        this.benchmark = false;
        if (this.benchmark && !(firstInit = SystemTester.initBenchmark())) {
            SystemTester.benchmark("start.dao.RuleOutputDetailDAOImpl");
        }
    }

    public RuleOutputDetailDAOImpl(FileConnection connection) {
        this();
        this.connection = connection;
        this.connection.setWriteAccess(true);
    }

    @Override
    public List<RuleOutputDetail> getAll() {
        List allValidationRuns;
        if (this.cached && this.allRecords != null) {
            return this.allRecords;
        }
        List<Object> list = new ArrayList();
        if (logger.isDebugEnabled()) {
            logger.debug("getAll() - Started with cache = " + this.cached + " / allRecords: " + String.valueOf(this.allRecords));
        }
        FileConnection validationRunConnection = FlatFileDAOFactory.getConnection(DAO.VALIDATION_RUN);
        FileHandlerCSV<ValidationRun> validationRunReader = new FileHandlerCSV<ValidationRun>(validationRunConnection, ValidationRun.class, true);
        validationRunReader.setHeader(true);
        try {
            allValidationRuns = validationRunReader.readFile();
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info("First validation run: missing reference to VALIDATION_RUN datasource");
            }
            return RuleOutputDetail.EMPTY_LIST;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getAll() - currentValidationRunID: " + this.currentValidationRunID + ", lastValidationRun: " + this.lastValidationRun);
        }
        int maxValidationRunID = this.getMaxValue(allValidationRuns, "id");
        if (logger.isDebugEnabled()) {
            logger.debug("getAll() - maxValidationRunID: " + maxValidationRunID);
        }
        if (this.lastValidationRun) {
            list = this.getByValidationRunID(maxValidationRunID);
            if (logger.isDebugEnabled()) {
                logger.debug("getAll() - \"Filter last validation run\" enabled - maxValidationRunID: " + maxValidationRunID);
            }
        } else {
            for (ValidationRun validationRun : allValidationRuns) {
                if (logger.isDebugEnabled()) {
                    logger.debug("getAll() - Loading RuleOutputDetail for ValidationRun: " + String.valueOf(validationRun));
                }
                int validationRunID = validationRun.getId();
                if (logger.isDebugEnabled()) {
                    logger.debug("getAll() - Loading RuleOutputDetail for ValidationRunID: " + validationRunID);
                }
                List runOutputDetails = null;
                if (logger.isDebugEnabled()) {
                    logger.debug("getAll() - Reading flat file for ValidationRunID: " + validationRunID);
                }
                try {
                    runOutputDetails = this.readFile(validationRunID);
                }
                catch (MissingResourceException e) {
                    int spanID = maxValidationRunID - validationRunID;
                    int latencyID = RawFilesWriter.getLatencyIDSpan();
                    if (spanID >= latencyID) continue;
                    logger.error("getAll() - Missing RuleOutputDetail file for ValidationRunID: " + validationRunID + " (spanID=" + spanID + ")");
                    continue;
                }
                list.addAll(runOutputDetails);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("getAll() - Loaded " + runOutputDetails.size() + " RuleOutputDetails for ValidationRun: " + validationRunID);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getAll() - Loaded " + list.size() + " RuleOutputDetails records");
        }
        if (this.cached) {
            this.allRecords = list;
        }
        return list;
    }

    @Override
    public RuleOutputDetail getByID(int recordID) {
        RuleOutputDetail ruleOutputDetail = (RuleOutputDetail)this.getRecordByID(recordID);
        if (ruleOutputDetail != null) {
            return ruleOutputDetail;
        }
        return RuleOutputDetail.UNDEF;
    }

    @Override
    public List<RuleOutputDetail> getByValidationRunID(int validationRunID) {
        List<RuleOutputDetail> runOutputDetails = this.readFile(validationRunID);
        if (runOutputDetails != null && runOutputDetails.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("getByValidationRunID() - Loaded " + runOutputDetails.size() + " RuleOutputDetail for ValidationRunID: " + validationRunID);
            }
        } else {
            logger.warn("getByValidationRunID() - Wrong ValidationRunID: " + validationRunID);
        }
        return runOutputDetails;
    }

    @Override
    public RuleOutputDetail getNextByValidationRunID(int validationRunID) {
        RuleOutputDetail ruleOutputDetail = null;
        try {
            ruleOutputDetail = (RuleOutputDetail)this.readNextLine(validationRunID);
        }
        catch (EOFException | InterruptedIOException e) {
            logger.error("getNextByValidationRunID() - Error reading file: " + e.getMessage());
        }
        if (ruleOutputDetail != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getNextByValidationRunID() - Loaded RuleOutputDetail for validationRunID: " + validationRunID);
            }
        } else {
            logger.warn("getNextByValidationRunID() - Wrong validationRunID: " + validationRunID);
        }
        return ruleOutputDetail;
    }

    @Override
    public List<RuleOutputDetail> getByRuleOutputID(int ruleOutputID) {
        List<RuleOutputDetail> list = this.getAll();
        if (list == null) {
            return RuleOutputDetail.EMPTY_LIST;
        }
        ArrayList<RuleOutputDetail> result = new ArrayList<RuleOutputDetail>();
        for (RuleOutputDetail ruleOutputdetail : list) {
            if (ruleOutputdetail.getRuleOutputID() != ruleOutputID) continue;
            result.add(ruleOutputdetail);
        }
        return result;
    }

    @Override
    public boolean save(RuleOutputDetail ruleOutputDetail) {
        int nextRecordID = this.getNextRecordID();
        ruleOutputDetail.setId(nextRecordID);
        if (logger.isDebugEnabled()) {
            logger.debug("save(RuleOutputDetail) - Set next record ID: " + nextRecordID);
        }
        int validationRunID = this.getCurrentValidationRunID();
        if (logger.isDebugEnabled()) {
            logger.debug("save(RuleOutputDetail) - Next record ID: " + nextRecordID + " [validationRunID = " + validationRunID + "]");
        }
        if (validationRunID <= 0) {
            logger.warn("save(RuleOutputDetail) - ValidationRunID not initialized: triggering lazy fetching (could affect performances)");
            RuleOutput ruleOutput = ruleOutputDetail.getRuleOutput();
            validationRunID = ruleOutput.getValidationRunID();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("save(RuleOutputDetail) - Actual validationRunID: " + validationRunID);
        }
        ArrayList<RuleOutputDetail> list = new ArrayList<RuleOutputDetail>();
        list.add(ruleOutputDetail);
        int written = this.writeFile(validationRunID, list);
        if (written > 0) {
            RuleOutputDetailDAOImpl.setLastRecordID(nextRecordID);
            return true;
        }
        return false;
    }

    @Override
    public int save(List<RuleOutputDetail> records) {
        int counter = 0;
        int nextRecordID = this.getNextRecordID();
        int validationRunID = this.getCurrentValidationRunID();
        if (logger.isDebugEnabled()) {
            logger.debug("save(List<RuleOutputDetail>) - Next record ID: " + nextRecordID + " [validationRunID = " + validationRunID + "]");
        }
        if (this.benchmark) {
            this.benchmark("SAVE_PREPARE_", records);
        }
        for (RuleOutputDetail outputDetail : records) {
            outputDetail.setId(nextRecordID++);
            if (logger.isTraceEnabled()) {
                logger.trace("save(List<RuleOutputDetail>) - Saving RuleOutputDetail: " + String.valueOf(outputDetail));
            }
            if (validationRunID > 0) continue;
            logger.warn("save(List<RuleOutputDetail>) - ValidationRunID not initialized: triggering lazy fetching (could affect performances)");
            RuleOutput ruleOutput = outputDetail.getRuleOutput();
            if (validationRunID <= 0) {
                validationRunID = ruleOutput.getValidationRunID();
                continue;
            }
            if (validationRunID == ruleOutput.getValidationRunID()) continue;
            String message = "Wrong validationRunID for record: " + String.valueOf(ruleOutput) + " (expected: " + validationRunID + ")";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("save(List<RuleOutputDetail>) - Actual validationRunID: " + validationRunID);
        }
        if (this.benchmark) {
            this.benchmark("SAVE_BEFORE__", records);
        }
        counter += this.writeFile(validationRunID, records);
        if (this.benchmark) {
            this.benchmark("SAVE_AFTER___", records);
        }
        if (counter > 0) {
            RuleOutputDetailDAOImpl.setLastRecordID(nextRecordID);
        }
        return counter;
    }

    @Override
    public int updateAll(List<RuleOutputDetail> records) {
        this.notifyCriticalWarning("Overwriting records feature not requested for RuleOutputDetail records");
        return 0;
    }

    @Override
    public boolean openConnection() {
        this.setAutoCommit(false);
        int resourceID = this.getCurrentValidationRunID();
        if (logger.isTraceEnabled()) {
            logger.trace("openConnection() - Opening connection for resourceID: " + resourceID);
        }
        try {
            this.openReader(resourceID);
            this.openWriter(resourceID);
        }
        catch (Exception e) {
            logger.error("openConnection() - Error opening connection: " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean closeConnection() {
        if (logger.isTraceEnabled()) {
            logger.trace("closeConnection() - Closing connection for resourceID: " + this.resourceID);
        }
        try {
            this.closeBufferedWriter();
            this.closeBufferedReader();
        }
        catch (Exception e) {
            logger.error("closeConnection() - Error closing connection: " + e.getMessage());
            return false;
        }
        return true;
    }

    protected void checkConnection(int targetResourceID) {
        boolean verbose = logger.isTraceEnabled();
        if (verbose) {
            logger.info("checkConnection() - BEGIN");
            logger.info("checkConnection() - auto_commit          : " + this.isAutoCommit());
            logger.info("checkConnection() - current_connection   : " + String.valueOf(this.connection));
            logger.info("checkConnection() - alternate_connection : " + String.valueOf(this.alternateConnection));
            logger.info("checkConnection() - current_resourceID   : " + this.resourceID);
            logger.info("checkConnection() - target_resourceID    : " + targetResourceID);
        }
        if (this.autoCommit) {
            if (verbose) {
                logger.info("checkConnection() - Auto commit is enabled -> return");
            }
            return;
        }
        if (this.resourceID == targetResourceID) {
            if (verbose) {
                logger.info("checkConnection() - Currenct resourceID does match targetResourceID: return");
            }
            return;
        }
        this.alternateConnection = new FileConnection(this.connection);
        if (verbose) {
            logger.info("checkConnection() - Using alternate_connection: " + String.valueOf(this.alternateConnection));
        }
        try {
            this.openReader(targetResourceID);
            this.openWriter(targetResourceID);
        }
        catch (Exception e) {
            logger.error("checkConnection() - Error opening connection: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Throwable t) {
            logger.error("checkConnection() - Fatal error opening connection: " + t.getMessage());
            t.printStackTrace();
        }
        if (verbose) {
            logger.info("checkConnection() - new_connection  : " + String.valueOf(this.connection));
            logger.info("checkConnection() - new_resourceId  : " + this.resourceID);
            logger.info("checkConnection() - input_stream    : " + String.valueOf(this.connection.getInputStream()));
            logger.info("checkConnection() - buffered_reader : " + String.valueOf(this.getBufferedReader()));
            logger.info("checkConnection() - END");
        }
    }

    protected void restoreConnection() {
        if (this.alternateConnection != null) {
            this.connection.closeConnection();
            this.connection = this.alternateConnection;
            this.alternateConnection = null;
        }
    }

    @Override
    public void init(int validationRunID) {
        this.currentValidationRunID = validationRunID;
        this.checkResourceID(validationRunID);
    }

    @Override
    public void resetAll() {
        this.purge();
    }

    protected synchronized int getNextRecordID() {
        int nextRecordID = 0;
        if (RuleOutputDetailDAOImpl.getLastRecordID() == 0) {
            int maxId = this.getMaxID();
            nextRecordID = maxId + 1;
        } else {
            nextRecordID = RuleOutputDetailDAOImpl.getLastRecordID() + 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getNextRecordID - Found nextRecordID: " + nextRecordID);
        }
        return nextRecordID;
    }

    public static int getLastRecordID() {
        return lastRecordID;
    }

    public static void setLastRecordID(int lastRecordID) {
        RuleOutputDetailDAOImpl.lastRecordID = lastRecordID;
    }

    @Override
    public boolean isLastValidationRun() {
        return this.lastValidationRun;
    }

    @Override
    public void setLastValidationRun(boolean lastValidationRun) {
        this.lastValidationRun = lastValidationRun;
    }

    public int getCurrentValidationRunID() {
        return this.currentValidationRunID;
    }

    public void setCurrentValidationRunID(int currentValidationRunID) {
        this.currentValidationRunID = currentValidationRunID;
    }

    static {
        logger = LoggerFactory.getLogger(RuleOutputDetailDAOImpl.class);
    }
}

