/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.file;

import eu.europa.ec.jrc.qcs.dao.RuleOutputDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFileDAOFactory;
import eu.europa.ec.jrc.qcs.dao.file.AbstractDAO;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerCSV;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.ValidationRun;
import java.io.EOFException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleOutputDAOImpl
extends AbstractDAO<RuleOutput>
implements RuleOutputDAO {
    protected static int lastRecordID;
    protected int currentValidationRunID;
    protected boolean lastValidationRun;
    protected FileConnection alternateConnection;
    protected static Logger logger;

    public RuleOutputDAOImpl() {
        this.setCached(false);
        this.setStrict(true);
        this.setHeader(true);
        this.setComments(true);
        this.setType(RuleOutput.class);
    }

    public RuleOutputDAOImpl(FileConnection connection) {
        this();
        this.connection = connection;
        this.connection.setWriteAccess(true);
    }

    @Override
    public List<RuleOutput> getAll() {
        List allValidationRuns;
        if (this.cached && this.allRecords != null) {
            return this.allRecords;
        }
        ArrayList<RuleOutput> list = new ArrayList();
        FileConnection validationRunConnection = FlatFileDAOFactory.getConnection(DAO.VALIDATION_RUN);
        FileHandlerCSV<ValidationRun> validationRunReader = new FileHandlerCSV<ValidationRun>(validationRunConnection, ValidationRun.class, true);
        validationRunReader.setHeader(true);
        try {
            allValidationRuns = validationRunReader.readFile();
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info("getAll() - First validation run: missing reference to VALIDATION_RUN datasource");
            }
            return RuleOutput.EMPTY_LIST;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getAll() - Getting all records using connection: " + String.valueOf(this.connection));
        }
        if (this.lastValidationRun) {
            int maxValidationRunID = this.getMaxValue(allValidationRuns, "id");
            if (logger.isDebugEnabled()) {
                logger.debug("getAll() - \"Filter last validation run\" enabled - maxValidationRunID = " + maxValidationRunID);
            }
            list = this.getByValidationRunID(maxValidationRunID);
        } else {
            for (ValidationRun validationRun : allValidationRuns) {
                int validationRunID = validationRun.getId();
                if (logger.isDebugEnabled()) {
                    logger.debug("getAll() - Loading RuleOutput for ValidationRunID: " + validationRunID);
                }
                List runRuleOutputs = null;
                try {
                    runRuleOutputs = this.readFile(validationRunID);
                }
                catch (MissingResourceException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("getAll() - Missing RuleOutputDetail file for ValidationRunID: " + validationRunID);
                    continue;
                }
                list.addAll(runRuleOutputs);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("getAll() - Loaded " + runRuleOutputs.size() + " RuleOutputs for ValidationRun " + validationRunID);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getAll() - Loaded " + list.size() + " RuleOutputs records");
        }
        if (this.cached) {
            this.allRecords = list;
        }
        return list;
    }

    @Override
    public RuleOutput getByID(int recordID) {
        RuleOutput ruleOutput = (RuleOutput)this.getRecordByID(recordID);
        if (ruleOutput != null) {
            return ruleOutput;
        }
        return RuleOutput.UNDEF;
    }

    @Override
    public List<RuleOutput> getByValidationRunID(int validationRunID) {
        if (logger.isTraceEnabled()) {
            logger.trace("getByValidationRunID() - Accessing file for validation run: " + validationRunID);
        }
        this.checkConnection(validationRunID);
        List<RuleOutput> runRuleOutputs = this.readFile(validationRunID);
        if (logger.isTraceEnabled()) {
            logger.trace("getByValidationRunID() - Accessed file for validation run: " + validationRunID);
        }
        if (runRuleOutputs != null && runRuleOutputs.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("getByValidationRunID() - Loaded " + runRuleOutputs.size() + " RuleOutput for ValidationRunID: " + validationRunID);
            }
        } else {
            logger.warn("getByValidationRunID() - Wrong ValidationRunID: " + validationRunID);
        }
        this.restoreConnection();
        if (logger.isTraceEnabled()) {
            logger.trace("getByValidationRunID() - Accessing file for validation run (OK): " + validationRunID);
        }
        return runRuleOutputs;
    }

    @Override
    public RuleOutput getNextByValidationRunID(int validationRunID) {
        RuleOutput runRuleOutput = null;
        try {
            runRuleOutput = (RuleOutput)this.readNextLine(validationRunID);
        }
        catch (EOFException | InterruptedIOException e) {
            logger.error("getNextByValidationRunID() - Error reading file: " + e.getMessage());
        }
        if (runRuleOutput != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getNextByValidationRunID() - Loaded RuleOutput for validationRunID: " + validationRunID);
            }
        } else {
            logger.warn("getNextByValidationRunID() - Wrong validationRunID: " + validationRunID);
        }
        return runRuleOutput;
    }

    @Override
    public boolean save(RuleOutput ruleOutput) {
        int nextRecordID = this.getNextRecordID();
        ruleOutput.setId(nextRecordID);
        if (logger.isDebugEnabled()) {
            logger.debug("save(RuleOutput) - Next record ID: " + nextRecordID);
        }
        int validationRunID = ruleOutput.getValidationRunID();
        if (logger.isDebugEnabled()) {
            logger.debug("save(RuleOutput) - ValidationRunID: " + validationRunID);
        }
        ArrayList<RuleOutput> list = new ArrayList<RuleOutput>();
        list.add(ruleOutput);
        int written = this.writeFile(validationRunID, list);
        if (written > 0) {
            RuleOutputDAOImpl.setLastRecordID(nextRecordID);
            return true;
        }
        return false;
    }

    @Override
    public int save(List<RuleOutput> records) {
        int counter = 0;
        int nextRecordID = this.getNextRecordID();
        if (logger.isDebugEnabled()) {
            logger.debug("save(List<RuleOutput>) - Next record ID: " + nextRecordID);
        }
        int validationRunID = 0;
        for (RuleOutput ruleOutput : records) {
            ruleOutput.setId(nextRecordID++);
            if (logger.isDebugEnabled()) {
                logger.debug("save(List<RuleOutput>) - Preparing record: " + String.valueOf(ruleOutput));
            }
            if (validationRunID <= 0) {
                validationRunID = ruleOutput.getValidationRunID();
                continue;
            }
            if (validationRunID == ruleOutput.getValidationRunID()) continue;
            String message = "Wrong validationRunID for record: " + String.valueOf(ruleOutput) + " (expected: " + validationRunID + ")";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        if ((counter += this.writeFile(validationRunID, records)) > 0) {
            RuleOutputDAOImpl.setLastRecordID(nextRecordID);
        }
        return counter;
    }

    @Override
    public int updateAll(List<RuleOutput> records) {
        this.notifyCriticalWarning("Overwriting records feature not requested for RuleOutput records");
        return 0;
    }

    @Override
    public boolean openConnection() {
        this.setAutoCommit(false);
        int resourceID = this.getCurrentValidationRunID();
        if (logger.isTraceEnabled()) {
            logger.trace("openConnection() - Opening connection for resourceID: " + resourceID);
        }
        try {
            this.openReader(resourceID);
            this.openWriter(resourceID);
        }
        catch (Exception e) {
            logger.error("openConnection() - Error opening connection: " + e.getMessage());
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("openConnection() - Connection      : " + String.valueOf(this.connection));
            logger.trace("openConnection() - Input stream    : " + String.valueOf(this.connection.getInputStream()));
            logger.trace("openConnection() - Buffered Reader : " + String.valueOf(this.getBufferedReader()));
        }
        return true;
    }

    @Override
    public boolean closeConnection() {
        if (logger.isTraceEnabled()) {
            logger.trace("closeConnection() - Closing connection for resourceID: " + this.resourceID);
        }
        try {
            this.closeBufferedWriter();
            this.closeBufferedReader();
        }
        catch (Exception e) {
            logger.error("closeConnection() - Error closing connection: " + e.getMessage());
            return false;
        }
        return true;
    }

    protected void checkConnection(int targetResourceID) {
        if (logger.isTraceEnabled()) {
            logger.trace("checkConnection() - Current connection : " + String.valueOf(this.connection));
            logger.trace("checkConnection() - Current resourceID : " + this.resourceID);
            logger.trace("checkConnection() - Target  resourceID : " + targetResourceID);
        }
        if (this.autoCommit) {
            if (logger.isDebugEnabled()) {
                logger.debug("checkConnection() - Auto commit is enabled: return");
            }
            return;
        }
        if (this.resourceID == targetResourceID) {
            if (logger.isInfoEnabled()) {
                logger.info("checkConnection() - Currenct resourceID does match targetResourceID: return");
            }
            return;
        }
        this.alternateConnection = new FileConnection(this.connection);
        try {
            this.openReader(targetResourceID);
            this.openWriter(targetResourceID);
        }
        catch (Exception e) {
            logger.error("checkConnection() - Error opening connection: " + e.getMessage());
            e.printStackTrace();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("checkConnection() - New connection : " + String.valueOf(this.connection));
            logger.trace("checkConnection() - New resourceID : " + this.resourceID);
            logger.trace("checkConnection() - Input stream   : " + String.valueOf(this.connection.getInputStream()));
            logger.trace("checkConnection() - BufferedReader : " + String.valueOf(this.getBufferedReader()));
        }
    }

    protected void restoreConnection() {
        if (this.alternateConnection != null) {
            this.connection.closeConnection();
            this.connection = this.alternateConnection;
            this.alternateConnection = null;
        }
    }

    @Override
    public void init(int validationRunID) {
        this.currentValidationRunID = validationRunID;
        this.checkResourceID(validationRunID);
    }

    @Override
    public void resetAll() {
        this.purge();
    }

    protected synchronized int getNextRecordID() {
        int nextRecordID = 0;
        if (logger.isTraceEnabled()) {
            logger.trace("getNextRecordID() - lastRecordID" + RuleOutputDAOImpl.getLastRecordID());
        }
        nextRecordID = RuleOutputDAOImpl.getLastRecordID() == 0 ? this.getMaxID() + 1 : RuleOutputDAOImpl.getLastRecordID() + 1;
        return nextRecordID;
    }

    protected static int getLastRecordID() {
        return lastRecordID;
    }

    protected static void setLastRecordID(int lastRecordID) {
        RuleOutputDAOImpl.lastRecordID = lastRecordID;
    }

    public int getCurrentValidationRunID() {
        return this.currentValidationRunID;
    }

    public void setCurrentValidationRunID(int currentValidationRunID) {
        this.currentValidationRunID = currentValidationRunID;
    }

    @Override
    public boolean isLastValidationRun() {
        return this.lastValidationRun;
    }

    @Override
    public void setLastValidationRun(boolean lastValidationRun) {
        this.lastValidationRun = lastValidationRun;
    }

    static {
        logger = LoggerFactory.getLogger(RuleOutputDAOImpl.class);
    }
}

