/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.file;

import eu.europa.ec.jrc.qcs.dao.DataRecordDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.EndOfDataConnetionException;
import eu.europa.ec.jrc.qcs.dao.datasource.ExhaustedDataConnectionException;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerCSV;
import eu.europa.ec.jrc.qcs.dao.model.input.DataConnection;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRecordDAOImpl
extends FileHandlerCSV<DataRecordCSV>
implements DataRecordDAO {
    protected DataRecord header;
    protected int currentValidationRunID;
    protected static Logger logger = LoggerFactory.getLogger(DataRecordDAOImpl.class);

    public DataRecordDAOImpl() {
        this.setCached(false);
        this.setStrict(false);
        this.setHeader(true);
        this.setComments(false);
        this.setType(DataRecordCSV.class);
    }

    public DataRecordDAOImpl(FileConnection connection) {
        this();
        this.connection = connection;
        this.connection.setWriteAccess(true);
    }

    @Override
    public List<DataRecord> getAll() {
        if (logger.isTraceEnabled()) {
            logger.trace("getAll() - Using connection: " + String.valueOf(this.connection) + " [write = " + this.connection.hasWriteAccess() + "]");
        }
        List<DataRecord> lines = this.readFile();
        if (logger.isInfoEnabled()) {
            logger.info("getAll() - Fetched " + this.getCursor() + " lines (" + lines.size() + " if excluding header)");
        }
        List<DataRecord> result = lines;
        return result;
    }

    @Override
    public DataRecord getByID(int recordID) {
        throw new UnsupportedOperationException("Records to be validated could not have an unique ID");
    }

    @Override
    public int getMaxID() {
        throw new UnsupportedOperationException("Records to be validated could not have a numeric ID");
    }

    @Override
    public DataRecord getNext() throws EndOfDataConnetionException, ExhaustedDataConnectionException {
        DataRecord record = null;
        try {
            record = (DataRecord)this.readLine();
        }
        catch (EOFException e) {
            throw new EndOfDataConnetionException(e);
        }
        catch (InterruptedIOException e) {
            throw new ExhaustedDataConnectionException(e);
        }
        return record;
    }

    @Override
    public void setHeader(DataRecord header) {
        String[] headerValues = header.getArray();
        String formattedHeader = this.formatArray(headerValues);
        this.setHeaderLine(formattedHeader);
        if (logger.isDebugEnabled()) {
            logger.debug(this.getObjectIdentifier() + " - setHeader(): " + formattedHeader);
        }
    }

    @Override
    public DataRecord getHeader() {
        if (this.header != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("setHeader() - Getting header from inner chache: " + String.valueOf(this.header));
            }
            return this.header;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("setHeader() - Getting header from columnNames : " + Arrays.toString(this.getColumnNames()));
        }
        if (this.getColumnNames() != null) {
            this.header = new DataRecordCSV(this.getColumnNames());
            return this.header;
        }
        this.openBufferedReader();
        if (logger.isDebugEnabled()) {
            logger.debug("setHeader() - Using BufferedReader : " + String.valueOf(this.getBufferedReader()));
            logger.debug("setHeader() - Getting header from DAO: " + this.getObjectIdentifier());
        }
        try {
            String line = this.bufferedReader.readLine();
            boolean safeLine = this.isSafeInput(line);
            if (!safeLine) {
                this.handleInvalidInput(line);
            }
            String[] columns = this.tokenize(line);
            this.setColumnNames(columns);
        }
        catch (IOException e) {
            logger.error("setHeader() - Error getting header for file: " + this.connection.getAbsolutePath());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("setHeader() - Getting header from columnNames : " + Arrays.toString(this.getColumnNames()));
        }
        this.header = new DataRecordCSV(this.getColumnNames());
        return this.header;
    }

    @Override
    public boolean save(DataRecord record) {
        if (logger.isTraceEnabled()) {
            logger.trace("save(DataRecord) - Using connection: " + String.valueOf(this.connection) + " [write = " + this.connection.hasWriteAccess() + "]");
        }
        if (!(record instanceof DataRecordCSV)) {
            String message = "Input record is not an instance of DataRecordCSV: " + record.getClass().getSimpleName();
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        DataRecordCSV recordCSV = (DataRecordCSV)record;
        if (logger.isDebugEnabled()) {
            logger.debug("save(DataRecord) - Saving record: " + recordCSV.toShortString());
        }
        int validationRunID = this.getCurrentValidationRunID();
        if (logger.isTraceEnabled()) {
            logger.trace("save(DataRecord) - Actual validationRunID: " + validationRunID);
        }
        ArrayList<DataRecordCSV> list = new ArrayList<DataRecordCSV>();
        list.add(recordCSV);
        int written = this.writeFile(validationRunID, list);
        return written > 0;
    }

    @Override
    public int save(List<DataRecord> records) {
        ArrayList<DataRecordCSV> list = new ArrayList<DataRecordCSV>();
        if (logger.isTraceEnabled()) {
            logger.trace("save(List<DataRecord>) - Using connection: " + String.valueOf(this.connection) + " [write = " + this.connection.hasWriteAccess() + "]");
        }
        for (DataRecord record : records) {
            if (record instanceof DataRecordCSV) {
                DataRecordCSV recordCSV = (DataRecordCSV)record;
                list.add(recordCSV);
                continue;
            }
            String message = "Input record is not an instance of DataRecordCSV: " + record.getClass().getSimpleName();
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        int validationRunID = this.getCurrentValidationRunID();
        if (logger.isTraceEnabled()) {
            logger.trace("save(List<DataRecord>) - Actual validationRunID: " + validationRunID);
        }
        int written = this.writeAllLines(validationRunID, list);
        return written;
    }

    @Override
    public int updateAll(List<DataRecord> records) {
        this.notifyCriticalWarning("Overwriting records feature not requested for DataRecord records");
        return 0;
    }

    @Override
    public boolean openConnection() {
        this.setAutoCommit(false);
        int resourceID = this.getCurrentValidationRunID();
        try {
            this.openWriter(resourceID);
        }
        catch (Exception e) {
            logger.error("openConnection() - Error opening connection: " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean closeConnection() {
        try {
            this.closeBufferedWriter();
        }
        catch (Exception e) {
            logger.error("closeConnection() - Error closing connection: " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void setDataConnection(DataConnection dataConnection) {
        if (dataConnection instanceof FileConnection) {
            this.connection = (FileConnection)dataConnection;
            this.header = null;
            this.reset();
            if (logger.isDebugEnabled()) {
                logger.debug("setDataConnection() - Path: " + this.connection.getAbsolutePath());
            }
        } else {
            String message = "DataRecordDAO implementation based on file system require a DataConnection of type 'FileConnection'";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public DataConnection getDataConnection() {
        return this.connection;
    }

    @Override
    public void init(int validationRunID) {
        String lastName;
        int fileSuffixID;
        block6: {
            this.currentValidationRunID = validationRunID;
            fileSuffixID = 0;
            lastName = this.connection.getFileName();
            String resourceID = lastName.replaceAll("\\D+", "");
            if (logger.isDebugEnabled()) {
                logger.debug("init() - Connection file's name: " + lastName + " [resourceID = \"" + resourceID + "\"]");
            }
            try {
                fileSuffixID = Integer.parseInt(resourceID);
            }
            catch (NumberFormatException e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("init() - Resource \"" + lastName + "\" still with placeholder -> assume new file");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Comparing fileSuffixID vs validationRunID: " + fileSuffixID + " vs " + validationRunID);
        }
        if (fileSuffixID != validationRunID) {
            this.setNewFile(true);
            if (logger.isDebugEnabled()) {
                logger.debug("init() - Creating new " + lastName + " file for validation run: " + validationRunID);
            }
        }
    }

    public int getCurrentValidationRunID() {
        return this.currentValidationRunID;
    }

    public void setCurrentValidationRunID(int currentValidationRunID) {
        this.currentValidationRunID = currentValidationRunID;
    }

    private boolean isSafeInput(String input) {
        String allowedPattern = "^[a-zA-Z0-9.,;_\\s-]*$";
        Pattern pattern = Pattern.compile(allowedPattern);
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    private void handleInvalidInput(String line) {
        logger.error("handleInvalidInput() - Found unsafe chars in string: " + line);
        if (logger.isWarnEnabled()) {
            logger.warn("handleInvalidInput() - Exiting now ...");
        }
        System.exit(1);
    }
}

