/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.file;

import eu.europa.ec.jrc.qcs.dao.GenericPersistentDAO;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerCSV;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDAO<T extends GenericModel>
extends FileHandlerCSV<T>
implements GenericPersistentDAO<T> {
    protected static Logger logger = LoggerFactory.getLogger(AbstractDAO.class);

    @Override
    public int getMaxID() {
        List list = this.getAll();
        return this.getMaxValue(list, "id");
    }

    @Override
    public boolean save(T record) {
        if (logger.isDebugEnabled()) {
            logger.debug("save(List<T>) - Writing record in append mode");
        }
        return this.writeRecord(record);
    }

    @Override
    public int save(List<T> list) {
        if (logger.isDebugEnabled()) {
            logger.debug("save(List<T>) - Writing list in append mode");
        }
        return this.writeRecords(list, true);
    }

    @Override
    public int updateAll(List<T> list) {
        if (logger.isDebugEnabled()) {
            logger.debug("updateAll(List<T>) - Writing list in replace mode");
        }
        return this.writeRecords(list, false);
    }

    public int updateAll(List<T> list, int resourceID) {
        if (logger.isDebugEnabled()) {
            logger.debug("updateAll(List<T>, int) - Writing list in replace mode for resourceID: " + resourceID);
        }
        return this.writeRecords(list, false, resourceID);
    }

    protected boolean writeRecord(T record) {
        return this.writeRecord(record, 0);
    }

    protected boolean writeRecord(T record, int resourceID) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(record);
        int written = this.writeRecords(list, true, 0);
        return written > 0;
    }

    protected int writeRecords(List<T> records, boolean append) {
        return this.writeRecords(records, append, 0);
    }

    protected int writeRecords(List<T> records, boolean append, int resourceID) {
        int nextRecordID = this.getMaxID() + 1;
        if (logger.isDebugEnabled()) {
            logger.debug("writeRecords(List<T>) - Next record ID: " + nextRecordID);
        }
        if (this.autoIncrement) {
            for (GenericModel record : records) {
                if (record instanceof GenericModel) {
                    GenericModel model = record;
                    model.setId(nextRecordID++);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("writeRecords(List<T>) - Prepared record: " + String.valueOf(record));
                    continue;
                }
                logger.warn("writeRecord(T) - Cannot set record ID to object: " + String.valueOf(record.getClass()));
                return 0;
            }
        }
        this.connection.setAppend(append);
        this.initTargetFile(resourceID);
        int counter = 0;
        try {
            counter += this.writeFile(resourceID, records);
        }
        catch (MissingResourceException e) {
            this.notifyCriticalWarning("writeRecords(List<T>) - Failed to save list of records: " + String.valueOf(records.getClass()));
        }
        return counter;
    }

    protected void checkResourceID(int resourceID) {
        String lastName;
        int fileSuffixID;
        block6: {
            fileSuffixID = 0;
            lastName = this.connection.getFileName();
            String fileNameID = lastName.replaceAll("\\D+", "");
            if (logger.isDebugEnabled()) {
                logger.debug("checkResourceID() - Connection file's name: " + lastName + " [resourceID = \"" + fileNameID + "\"]");
            }
            try {
                fileSuffixID = Integer.parseInt(fileNameID);
            }
            catch (NumberFormatException e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("checkResourceID() - Resource \"" + lastName + "\" still with placeholder -> assume new file");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("checkResourceID() - Comparing fileSuffixID vs resourceID: " + fileSuffixID + " vs " + resourceID);
        }
        if (fileSuffixID != resourceID) {
            this.setNewFile(true);
            if (logger.isDebugEnabled()) {
                logger.debug("checkResourceID() - Creating new " + lastName + " file for resource: " + resourceID);
            }
        }
    }

    protected T getRecordByID(int recordID) {
        List list = this.getAll();
        if (list == null) {
            return null;
        }
        for (GenericModel record : list) {
            if (record.getId() != recordID) continue;
            return (T)record;
        }
        return null;
    }
}

