/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.dto;

import eu.europa.ec.jrc.qcs.dao.dto.Field;
import eu.europa.ec.jrc.qcs.dao.dto.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;

@Entity(name="schemaToField")
@NamedQueries(value={@NamedQuery(name="schemaToField.getAll", query="from schemaToField"), @NamedQuery(name="schemaToField.getBySchemaID", query="from schemaToField where schema.id= :schemaID"), @NamedQuery(name="schemaToField.getByFieldID", query="from schemaToField where field.id= :fieldID")})
public class SchemaToField {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @ManyToOne(optional=false)
    private Schema schema;
    @Min(value=1L)
    private @Min(value=1L) int position;
    @ManyToOne(optional=false)
    private Field field;
    @Pattern(regexp="[NUPCM]|PM|PC", message="Invalid key value. Enter N or U or P or C or M.")
    @Size(min=1, max=2, message="Invalid key size")
    private @Pattern(regexp="[NUPCM]|PM|PC", message="Invalid key value. Enter N or U or P or C or M.") @Size(min=1, max=2, message="Invalid key size") String key;
    @NotNull(message="function cannnot be null")
    private @NotNull(message="function cannnot be null") Boolean function;
    private String description;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Boolean getFunction() {
        return this.function;
    }

    public void setFunction(Boolean function) {
        this.function = function;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toPrettyString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("id=");
        builder.append(this.getId());
        builder.append(", schemaID=");
        builder.append(this.getSchema().getId());
        builder.append(", position=");
        builder.append(this.getPosition());
        builder.append(", fieldID=");
        builder.append(this.getField().getId());
        builder.append(", key=");
        if (this.getKey() != null) {
            builder.append(this.getKey());
        } else {
            builder.append("null");
        }
        builder.append(", function=");
        builder.append(this.getFunction());
        return builder.toString();
    }
}

