/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.dto;

import eu.europa.ec.jrc.qcs.dao.dto.ReportType;
import eu.europa.ec.jrc.qcs.dao.dto.SchemaGroup;
import eu.europa.ec.jrc.qcs.dao.dto.SchemaToField;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.validation.constraints.NotBlank;
import java.util.List;

@Entity(name="schema")
@NamedQueries(value={@NamedQuery(name="schema.getAll", query="from schema"), @NamedQuery(name="schema.getByGroupID", query="from schema  WHERE group.id = :groupID")})
public class Schema {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @NotBlank(message="Name cannot be blank")
    private @NotBlank(message="Name cannot be blank") String name;
    @NotBlank(message="Validation cannot be blank")
    private @NotBlank(message="Validation cannot be blank") String description;
    @ManyToOne(optional=false)
    private SchemaGroup group;
    @ManyToOne(optional=true)
    private Schema parent;
    @ManyToOne(optional=true)
    private ReportType reportType;
    @OneToMany(mappedBy="schema")
    @OrderBy(value="position ASC")
    private List<SchemaToField> schemaToField;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public SchemaGroup getGroup() {
        return this.group;
    }

    public void setGroup(SchemaGroup group) {
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Schema getParent() {
        return this.parent;
    }

    public void setParent(Schema parent) {
        this.parent = parent;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportType reportType) {
        this.reportType = reportType;
    }

    public List<SchemaToField> getSchemaToField() {
        return this.schemaToField;
    }

    public void setSchemaToField(List<SchemaToField> schemaToField) {
        this.schemaToField = schemaToField;
    }

    public String toPrettyString() {
        StringBuilder builder = new StringBuilder();
        builder.append("name=");
        builder.append(this.getName());
        builder.append(", id=");
        builder.append(this.getId());
        builder.append(", groupID=");
        builder.append(this.getGroup().getId());
        builder.append(", parentID=");
        builder.append(this.getParent().getId());
        builder.append(", reportID=");
        builder.append(this.getReportType().getId());
        builder.append("]");
        return builder.toString();
    }
}

