/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.dto;

import eu.europa.ec.jrc.qcs.dao.dto.Field;
import eu.europa.ec.jrc.qcs.dao.dto.Protocol;
import eu.europa.ec.jrc.qcs.dao.dto.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.dto.RuleTarget;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity(name="ruleToField")
@NamedQueries(value={@NamedQuery(name="ruleToField.getAll", query="from ruleToField"), @NamedQuery(name="ruleToField.getByProtocolID", query="from ruleToField where protocol.id=:protocolID"), @NamedQuery(name="ruleToField.getByRuleID", query="from ruleToField where ruleDefinition.id=:ruleID"), @NamedQuery(name="ruleToField.getByFieldID", query="from ruleToField where field.id=:fieldID")})
public class RuleToField {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @NotNull(message="key cannot be null")
    private @NotNull(message="key cannot be null") boolean key;
    @Min(value=0L)
    private @Min(value=0L) int position;
    @ManyToOne
    private Field field;
    @ManyToOne
    private Protocol protocol;
    @ManyToOne
    private RuleDefinition ruleDefinition;
    @ManyToOne
    private RuleTarget target;
    protected static Logger logger = LoggerFactory.getLogger(RuleToField.class);

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public RuleDefinition getRuleDefinition() {
        return this.ruleDefinition;
    }

    public void setRuleDefinition(RuleDefinition ruleDefinition) {
        this.ruleDefinition = ruleDefinition;
    }

    public RuleTarget getTarget() {
        return this.target;
    }

    public void setTarget(RuleTarget target) {
        this.target = target;
    }

    public String toPrettyString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("id=");
        builder.append(this.getId());
        builder.append(", protocolID=");
        builder.append(this.getProtocol().getId());
        builder.append(", ruleID=");
        builder.append(this.getRuleDefinition().getId());
        builder.append(", target=");
        builder.append(this.getTarget());
        if (this.getField() == null) {
            builder.append(", fieldID=*");
        } else {
            builder.append(", fieldID[");
            builder.append(this.getPosition());
            builder.append("]=");
            builder.append(this.getField().getId());
        }
        builder.append("}");
        return builder.toString();
    }
}

