/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.dto;

import eu.europa.ec.jrc.qcs.dao.dto.RuleType;
import eu.europa.ec.jrc.qcs.dao.dto.ValidationMessage;
import eu.europa.ec.jrc.qcs.dao.dto.annotations.ReflectionValidate;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity(name="ruleDefinition")
@NamedQueries(value={@NamedQuery(name="ruleDefinition.getAll", query="from ruleDefinition"), @NamedQuery(name="ruleDefinition.getByRuleTypeID", query="from ruleDefinition  WHERE ruleType.id = : ruleTypeID"), @NamedQuery(name="ruleDefinition.getByValidationMessageID", query="from ruleDefinition  WHERE validationMessage.id = : ValidationMessageID")})
@ReflectionValidate.List(value={@ReflectionValidate(location="location", implementation="implementation")})
public class RuleDefinition {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @NotBlank(message="name is blank")
    private @NotBlank(message="name is blank") String name;
    @NotBlank(message="description is blank")
    private @NotBlank(message="description is blank") String description;
    @NotNull(message="positive cannnot be null")
    private @NotNull(message="positive cannnot be null") Boolean positive;
    @Pattern(regexp="INSENSITIVE|FIELD_LEVEL", message="Invalid caseSensitivity value. Enter INSENSITIVE or FIELD_LEVEL.")
    private @Pattern(regexp="INSENSITIVE|FIELD_LEVEL", message="Invalid caseSensitivity value. Enter INSENSITIVE or FIELD_LEVEL.") String caseSensitivity;
    @NotBlank(message="location is blank")
    private @NotBlank(message="location is blank") String location;
    @NotBlank(message="implementation is blank")
    private @NotBlank(message="implementation is blank") String implementation;
    @ManyToOne
    private ValidationMessage validationMessage;
    @ManyToOne
    private RuleType ruleType;
    protected static Logger logger = LoggerFactory.getLogger(RuleDefinition.class);

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getPositive() {
        return this.positive;
    }

    public void setPositive(Boolean positive) {
        this.positive = positive;
    }

    public String getCaseSensitivity() {
        return this.caseSensitivity;
    }

    public void setCaseSensitivity(String caseSensitivity) {
        this.caseSensitivity = caseSensitivity;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public ValidationMessage getValidationMessage() {
        return this.validationMessage;
    }

    public void setValidationMessage(ValidationMessage validationMessage) {
        this.validationMessage = validationMessage;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(RuleType ruleType) {
        this.ruleType = ruleType;
    }

    public String toPrettyString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("id=");
        builder.append(this.getId());
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", class=");
        if (this.implementation != null) {
            builder.append(this.implementation);
        } else {
            builder.append("default");
        }
        builder.append(", type=");
        builder.append(this.ruleType);
        builder.append("]");
        return builder.toString();
    }
}

