/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.dto;

import eu.europa.ec.jrc.qcs.dao.dto.Field;
import eu.europa.ec.jrc.qcs.dao.dto.Protocol;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;

@Entity(name="referenceField")
@NamedQueries(value={@NamedQuery(name="referenceField.getAll", query="from referenceField"), @NamedQuery(name="referenceField.getByProtocolID", query="from referenceField where protocol.id = :protocolID"), @NamedQuery(name="referenceField.getByFieldID", query="from referenceField where field.id = :fieldID"), @NamedQuery(name="referenceField.getByProtocolIDAndPosition", query="from referenceField where protocol.id = :protocolID and position = :position"), @NamedQuery(name="referenceField.getSortedByProtocolID", query="from referenceField where protocol.id = :protocolID order by position"), @NamedQuery(name="referenceField.getSortedNamesByProtocolID", query="select DISTINCT name from referenceField where protocol.id = :protocolID order by position"), @NamedQuery(name="referenceField.getMaxPositionByProtocolID", query="select MAX(position) from referenceField where protocol.id = :protocolID")})
public class ReferenceField {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @ManyToOne
    private Protocol protocol;
    @NotBlank(message="Name cannot be nlank")
    private @NotBlank(message="Name cannot be nlank") String name;
    @ManyToOne
    private Field field;
    @NotBlank(message="fieldLabel cannot be blank")
    private @NotBlank(message="fieldLabel cannot be blank") String fieldLabel;
    @Min(value=0L)
    private @Min(value=0L) Integer position;
    @Min(value=0L)
    private @Min(value=0L) Integer orderNumber;
    @Min(value=0L)
    private @Min(value=0L) Integer keyPosition;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public String getFieldLabel() {
        return this.fieldLabel;
    }

    public void setFieldLabel(String fieldLabel) {
        this.fieldLabel = fieldLabel;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public Integer getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(Integer orderNumber) {
        this.orderNumber = orderNumber;
    }

    public Integer getKeyPosition() {
        return this.keyPosition;
    }

    public void setKeyPosition(Integer keyPosition) {
        this.keyPosition = keyPosition;
    }

    public String toPrettyString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("name=");
        builder.append(this.name);
        builder.append(", id=");
        builder.append(this.getId());
        builder.append(", order=");
        builder.append(this.getOrderNumber());
        builder.append(", protocolID=");
        builder.append(this.getProtocol().getId());
        builder.append(", pfieldID=");
        builder.append(this.getField().getId());
        builder.append(", position=");
        builder.append(this.getPosition());
        builder.append(", key position=");
        builder.append(this.getKeyPosition());
        builder.append(", order=");
        builder.append(this.getOrderNumber());
        builder.append("]");
        return builder.toString();
    }
}

